SET QUOTED_IDENTIFIER ON
GO

IF EXISTS
  (SELECT *
     FROM [dbo].[KYScriptLog] SKL
    WHERE SKL.[MajorVersion] = 5
      AND SKL.[MinorVersion] = 1
      AND SKL.[Build] = 1
      AND SKL.[Revision] = 163
      AND SKL.[COMMENT] = '001 MakeSAM4SAM3Compatible.SQL')
BEGIN
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
VALUES(GetDate(),
       5,
       1,
       1,
       163,
       'Build 5.1.1.163',
       '001 MakeSAM4SAM3Compatible.SQL **FAILED**')
GO

SET IMPLICIT_TRANSACTIONS OFF
GO

DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'ALTER DATABASE [' + DB_NAME() + '] SET RECOVERY SIMPLE'

EXEC (@COMMAND)
GO

-- Remove old Web Module Foreign Keys.
DECLARE @FK NVARCHAR(128)
DECLARE @NCOMMAND NVARCHAR(MAX)

SELECT TOP 1 @FK = FK.[name]
  FROM SYS.[objects] SO
       INNER JOIN sys.foreign_keys FK
               ON FK.[parent_object_id] = SO.[object_id]
 WHERE SO.[name] = 'WebForms'
WHILE @FK IS NOT NULL
  BEGIN
    SET @NCOMMAND = N'ALTER TABLE [dbo].[WebForms] DROP CONSTRAINT [' + @FK + N']'

    EXEC sp_executesql @NCOMMAND

    SET @FK = NULL

    SELECT TOP 1 @FK = FK.[name]
	  FROM SYS.[objects] SO
		   INNER JOIN sys.foreign_keys FK
				   ON FK.[parent_object_id] = SO.[object_id]
	 WHERE SO.[name] = 'WebForms'
  END

SET @FK = NULL

SELECT TOP 1 @FK = FK.[name]
  FROM SYS.[objects] SO
       INNER JOIN sys.foreign_keys FK
               ON FK.[parent_object_id] = SO.[object_id]
 WHERE SO.[name] = 'WebFields'
WHILE @FK IS NOT NULL
  BEGIN
    SET @NCOMMAND = N'ALTER TABLE [dbo].[WebFields] DROP CONSTRAINT [' + @FK + N']'

    EXEC sp_executesql @NCOMMAND

    SET @FK = NULL

    SELECT TOP 1 @FK = FK.[name]
	  FROM SYS.[objects] SO
		   INNER JOIN sys.foreign_keys FK
				   ON FK.[parent_object_id] = SO.[object_id]
	 WHERE SO.[name] = 'WebFields'
  END

SET @FK = NULL

SELECT TOP 1 @FK = FK.[name]
  FROM SYS.[objects] SO
       INNER JOIN sys.foreign_keys FK
               ON FK.[parent_object_id] = SO.[object_id]
 WHERE SO.[name] = 'WebAssociatesFields'
WHILE @FK IS NOT NULL
  BEGIN
    SET @NCOMMAND = N'ALTER TABLE [dbo].[WebAssociatesFields] DROP CONSTRAINT [' + @FK + N']'

    EXEC sp_executesql @NCOMMAND

    SET @FK = NULL

    SELECT TOP 1 @FK = FK.[name]
	  FROM SYS.[objects] SO
		   INNER JOIN sys.foreign_keys FK
				   ON FK.[parent_object_id] = SO.[object_id]
	 WHERE SO.[name] = 'WebAssociatesFields'
  END
GO

IF EXISTS
  (SELECT *
      FROM SYS.[objects] SO
    WHERE SO.[name] = 'OpenClosedMatters'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[OpenClosedMatters]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'OpenClosedMattersLedger'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[OpenClosedMattersLedger]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'OpenClosedMatterLedger'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[OpenClosedMatterLedger]
END
GO

-- Function is obsolete. Delete, don't recreate
IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ky_NETOpenClosedMatters'
      AND SO.[type] = 'TF')
BEGIN
  DROP FUNCTION [dbo].[ky_NETOpenClosedMatters]
END
GO

-- Function is obsolete. Delete, don't recreate
IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ky_NETOpenClosedMatterLedger'
      AND SO.[type] = 'TF')
BEGIN
  DROP FUNCTION [dbo].[ky_NETOpenClosedMatterLedger]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'MatterLedger'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[MatterLedger]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'DebtorsLedger'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[DebtorsLedger]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'MatterRecovery'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[MatterRecovery]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'SolicitorsStatsReport'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[SolicitorsStatsReport]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'WIPByMatter'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[WIPByMatter]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'zAutoWriteOffRecords'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[zAutoWriteOffRecords]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'zAuotwriteoff'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[zAuotwriteoff]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'TotalChargeByInovieNo'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[TotalChargeByInovieNo]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'TotalChagenbyTeamInvoiceNo'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[TotalChagenbyTeamInvoiceNo]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'TimeWIPByFE'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[TimeWIPByFE]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'zWIPClosed'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[zWIPClosed]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'TimeRecordedByFe'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[TimeRecordedByFe]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'T'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[T]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'RecoveryRate'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[RecoveryRate]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'zCheckBillTime'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[zCheckBillTime]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'SystemReconciliationView'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[SystemReconciliationView]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'vHandlersStats'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[vHandlersStats]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'vHandlersStatsold'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[vHandlersStatsold]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'FeMatterWIPOLD'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[FeMatterWIPOLD]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'FirmWIP01'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[FirmWIP01]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'TimeEntryView'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[TimeEntryView]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'FeMatterWIP'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[FeMatterWIP]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'MatterBalanceTotal'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[MatterBalanceTotal]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'MatterBalanceZeroCurrentYear'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[MatterBalanceZeroCurrentYear]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'MatterBalanceZero'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[MatterBalanceZero]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'MatterBalances'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[MatterBalances]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'MatterLastBillDate'
      AND SO.[type] = 'V')
BEGIN
  DROP VIEW [dbo].[MatterLastBillDate]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ky_RemoveSpuriousWhitespace2'
      AND SO.[type] = 'FN')
BEGIN
  DROP FUNCTION [dbo].[ky_RemoveSpuriousWhitespace2]
END
GO

/**************************************************************************************
 *
 * ky_RemoveSpuriousWhitespace2
 *
 * Removes newlines, line feeds, non-breaking spaces and multiple spaces from the input
 *   string in order to produce an output format suitable for display in lists.
 *
 **************************************************************************************/
create function
       [dbo].[ky_RemoveSpuriousWhitespace2]
      (@original varchar(MAX),
       @maxlen   int)
returns varchar(5000)
AS
BEGIN
  DECLARE @len int

  SET @original = ISNULL(@original, '')
  IF LEN(@original) > (2 * @maxlen)
    BEGIN
      SET @original = SUBSTRING(@original, 1, (2 * @maxlen))
    END

  SET @original = replace(@original, char(10), ' ')
  SET @original = replace(@original, char(13), ' ')
  SET @original = replace(@original, char(160), ' ')

  SET @original = RTRIM(@original)
  
  SET @len = 0
    WHILE (@len <> len(@original))
      BEGIN
        SET @len = len(@original)
        SET @original = replace(@original, '  ', ' ')
      END

  RETURN substring(@original, 1, @maxlen)
  
END


GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ISSAM4'
      AND SO.[type] = 'FN')
BEGIN
  DROP FUNCTION [dbo].[ISSAM4]
END
GO

CREATE FUNCTION
       [dbo].[ISSAM4]
      ()
RETURNS BIT
AS
BEGIN
  DECLARE @ISSAM4 BIT

  IF EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'Transactions'
        AND SO.[type] = 'U')
    BEGIN 
      SET @ISSAM4 = 1
    END
  ELSE
    BEGIN
      SET @ISSAM4 = 0
    END

  RETURN @ISSAM4
END
GO

DECLARE @EXPRESS BIT

SET @EXPRESS = CASE WHEN PATINDEX('%xpress%', CONVERT(VARCHAR(100), SERVERPROPERTY('edition'))) > 0 THEN 1 ELSE 0 END

IF (@EXPRESS = 0)
  BEGIN
    IF NOT EXISTS
      (select *
         from sys.filegroups FG
        WHERE fg.[name] = 'TEXTDATA')
    BEGIN
      DECLARE @COMMAND VARCHAR(MAX)

      SET @COMMAND = 'ALTER DATABASE ' + DB_NAME() + ' ADD FILEGROUP [TEXTDATA]'

      EXEC (@COMMAND)
    END

    DECLARE @FILE VARCHAR(260)

      SELECT TOP 1 @FILE = DBF.[physical_name]
        FROM sys.database_files DBF
       WHERE DBF.[type_desc] = 'ROWS'
    ORDER BY DBF.[file_id]

    SET @FILE = REVERSE(@FILE)

    IF (CHARINDEX('.', @File, 1) > 0)
      BEGIN
        SET @FILE = SUBSTRING(@FILE, CHARINDEX('.', @File, 1) + 1, LEN(@FILE) - CHARINDEX('.', @File, 1))
      END

    SET @FILE = REVERSE(@FILE) + '_TEXTDATA.ndf'

    IF NOT EXISTS
      (SELECT *
         FROM sys.[database_files] DBF
        WHERE DBF.[physical_name] = @FILE)
    BEGIN
      SET @COMMAND = 'ALTER DATABASE ' + DB_NAME() + '
        ADD FILE
           (NAME = TEXTDATA,
            FILENAME = ''' + @FILE + ''',
            SIZE = 1GB,
            FILEGROWTH = 20%)
         TO FILEGROUP TEXTDATA'
  
      EXEC (@COMMAND)
    END
  END
GO

DECLARE @FixCC BIT

SET @FIXCC = 0

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ContactCategories'
      AND SO.[type] = 'U')
  BEGIN
    IF NOT EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[indexes] SI
                      ON SI.[object_id] = SO.[object_id]
                     AND SI.[name] = 'PK_ContactCategories'
        WHERE SO.[name] = 'ContactCategories'
          AND SO.[type] = 'U')
      BEGIN
        SET @FIXCC = 1
      END

    IF NOT EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'RecordID'
        WHERE SO.[name] = 'ContactCategories'
          AND SO.[type] = 'U')
      BEGIN
        SET @FIXCC = 1
      END

    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CONTACT'
                     AND SC.[max_length] < 8
        WHERE SO.[name] = 'ContactCategories'
          AND SO.[type] = 'U')
      BEGIN
        SET @FIXCC = 1
      END
  END

IF @FixCC = 1
  BEGIN
    SELECT * INTO [dbo].[CONFIX] FROM [dbo].[ContactCategories] 
        
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'DROP TABLE [dbo].[ContactCategories]'

    EXEC (@COMMAND)

    SET @COMMAND = '
    CREATE TABLE 
            [dbo].[ContactCategories]
           ([RECORDID]             [int]            IDENTITY(1,1)     NOT NULL,
            [CONTACT]              [varchar](8)                       NOT NULL,
            [CATEGORYTYPE]         [varchar](6)                       NOT NULL,
            [CATEGORY]             [varchar](10)                      NOT NULL,
            [DATE]                 [datetime]                             NULL,
	          [FIELDVALUE1]          [varchar](60)                          NULL,
	          [FIELDVALUE2]          [varchar](60)                          NULL,
	          [FIELDVALUE3]          [varchar](60)                          NULL,
	          [FIELDVALUE4]          [varchar](60)                          NULL,
	          [FIELDVALUE5]          [varchar](60)                          NULL,
	          [FIELDVALUE6]          [varchar](60)                          NULL,
	          [FIELDVALUE7]          [varchar](60)                          NULL,
	          [FIELDVALUE8]          [varchar](60)                          NULL,
	          [FIELDVALUE9]          [varchar](60)                          NULL,
	          [FIELDVALUE10]         [varchar](60)                          NULL,
            CONSTRAINT [PK_ContactCategories]
                      PRIMARY KEY CLUSTERED 
                      ([RECORDID] ASC)
                    ON [PRIMARY])
        ON [PRIMARY]'                

    EXEC (@COMMAND)

    SET @COMMAND = '
    INSERT
      INTO [dbo].[ContactCategories]
          ([CONTACT],
           [CATEGORYTYPE],
           [CATEGORY],
           [DATE],
	         [FIELDVALUE1],
	         [FIELDVALUE2],
	         [FIELDVALUE3],
	         [FIELDVALUE4],
	         [FIELDVALUE5],
	         [FIELDVALUE6],
	         [FIELDVALUE7],
	         [FIELDVALUE8],
	         [FIELDVALUE9],
	         [FIELDVALUE10])
    SELECT RTRIM([CONTACT]),
           RTRIM([CATEGORYTYPE]),
           RTRIM([CATEGORY]),
           [DATE],
	         RTRIM([FIELDVALUE1]),
	         RTRIM([FIELDVALUE2]),
	         RTRIM([FIELDVALUE3]),
	         RTRIM([FIELDVALUE4]),
	         RTRIM([FIELDVALUE5]),
	         RTRIM([FIELDVALUE6]),
	         RTRIM([FIELDVALUE7]),
	         RTRIM([FIELDVALUE8]),
	         RTRIM([FIELDVALUE9]),
	         RTRIM([FIELDVALUE10])
      FROM [dbo].[CONFIX] COX'

    EXEC (@COMMAND)

    SET @COMMAND = '
    DELETE COC2
      FROM (  SELECT [CONTACT],
                     [CATEGORYTYPE],
                     [CATEGORY]
                FROM [dbo].[ContactCategories] COC
            GROUP BY [CONTACT],
                     [CATEGORYTYPE],
                     [CATEGORY]
              HAVING COUNT(1) > 1) HUH
           CROSS APPLY (SELECT TOP 1 *
                          FROM [dbo].[ContactCategories] COC3
                         WHERE COC3.[CONTACT] = HUH.[CONTACT]
                           AND COC3.[CATEGORYTYPE] = HUH.[CATEGORYTYPE]
                           AND COC3.[CATEGORY] = HUH.[CATEGORY]) SNG
           INNER JOIN [dbo].[ContactCategories] COC2
                   ON COC2.[CONTACT] = HUH.[CONTACT]
                  AND COC2.[CATEGORYTYPE] = HUH.[CATEGORYTYPE]
                  AND COC2.[CATEGORY] = HUH.[CATEGORY]
                  AND COC2.[RecordID] <> SNG.[RecordID]'

    EXEC (@COMMAND)

    SET @COMMAND = '
    CREATE NONCLUSTERED INDEX 
           [COC_CATCON]
        ON [dbo].[ContactCategories]
          ([CATEGORYTYPE] ASC,
           [CATEGORY]     ASC,
           [CONTACT]      ASC)
        ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = '
    CREATE NONCLUSTERED INDEX
           [COC_CONCAT]
        ON [dbo].[ContactCategories]
          ([CONTACT]      ASC,
           [CATEGORYTYPE] ASC,
           [CATEGORY]     ASC)
        ON [PRIMARY]'

    EXEC (@COMMAND)

    IF EXISTS
      (SELECT TOP 1 1 FROM [dbo].[ContactCategories])
      BEGIN
        SET @COMMAND = 'DROP TABLE [dbo].[CONFIX]'

        EXEC (@COMMAND)
      END
    ELSE
      BEGIN
        IF NOT EXISTS
          (SELECT TOP 1 1 FROM [dbo].[CONFIX])
          BEGIN
            SET @COMMAND = 'DROP TABLE [dbo].[CONFIX]'

            EXEC (@COMMAND)
          END
      END


  END
GO

DECLARE @COMMAND VARCHAR(MAX)

IF NOT EXISTS
  (SELECT * 
     FROM SYS.[objects] SO
          INNER JOIN SYS.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                AND SC.[name] = 'HANDLER'
                AND SC.[max_length] = 10
    WHERE SO.[name] = 'DiaryDelegations'
      AND SO.[type] = 'U')
  BEGIN
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
        WHERE SO.[name] = 'FIXDDL'
          AND SO.[type] = 'U')
    BEGIN
      SET @COMMAND = 'DROP TABLE [dbo].[FIXDDL]'

      EXEC (@COMMAND)
    END

    SET @COMMAND = 'SELECT *
  INTO [dbo].[FIXDDL]
  FROM [dbo].[DiaryDelegations]'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE 
      [dbo].[FIXDDL]
  ADD CONSTRAINT 
      [PK_FIXDDL]
      PRIMARY KEY CLUSTERED 
     ([AssignNo] ASC)'

    EXEC (@COMMAND)

    SET @COMMAND = 'DROP TABLE [dbo].[DiaryDelegations]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TABLE 
       [dbo].[DiaryDelegations]
      ([AssignNo]           [int]                  IDENTITY(1,1)               NOT NULL,
       [ACTIONID]           [int]                                              NOT NULL,
       [HANDLER]            [varchar](10)                                      NOT NULL,
       [TEAM]               [varchar](10)                                          NULL,
       [DATE]               [datetime]                                             NULL,
       [TIME]               [varchar](10)                                          NULL,
       [DATER]              [datetime]                                             NULL,
       [TIMER]              [varchar](10)                                          NULL,
       [DUEDATE]            [datetime]                                             NULL,
       [DUETIME]            [varchar](10)                                          NULL,
       [REVIEW]             [char](1)                                              NULL,
       [STATUS]             [smallint]                                             NULL,
       [OWNER]              [char](1)                                              NULL,
       [DELEGATE]           [varchar](10)                                          NULL,
       [DELEGATESTATUS]     [smallint]                                             NULL,
       [ActionType]         [char](1)                                              NULL,
       [FromHandler]        [varchar](10)                                          NULL,
       [ReturnedBy]         [varchar](10)                                          NULL,
       [DelType]            [varchar](15)                                          NULL,
       CONSTRAINT [PK_DiaryDelegations]
                  PRIMARY KEY CLUSTERED 
                 ([AssignNo] ASC)
               ON [PRIMARY])
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'SET IDENTITY_INSERT [dbo].[DiaryDelegations] ON

INSERT
  INTO [dbo].[DiaryDelegations]
      ([AssignNo],
       [ACTIONID],
       [HANDLER],
       [TEAM],
       [DATE],
       [TIME],
       [DATER],
       [TIMER],
       [DUEDATE],
       [DUETIME],
       [REVIEW],
       [STATUS],
       [OWNER],
       [DELEGATE],
       [DELEGATESTATUS],
       [ActionType],
       [FromHandler],
       [ReturnedBy],
       [DelType])
SELECT ISNULL([AssignNo], 0),
       ISNULL([ACTIONID], 0),
       RTRIM(ISNULL([HANDLER], '''')),
       RTRIM([TEAM]),
       [DATE],
       RTRIM([TIME]),
       [DATER],
       RTRIM([TIMER]),
       [DUEDATE],
       RTRIM([DUETIME]),
       [REVIEW],
       [STATUS],
       [OWNER],
       RTRIM([DELEGATE]),
       [DELEGATESTATUS],
       [ActionType],
       RTRIM([FromHandler]),
       RTRIM([ReturnedBy]),
       RTRIM([DelType])
  FROM [dbo].[FIXDDL] DDX
  
SET IDENTITY_INSERT [dbo].[DiaryDelegations] OFF

DECLARE @maxVal INT
SELECT @maxVal = ISNULL(max(AssignNo),0)+1 from [dbo].[DiaryDelegations]
DBCC CHECKIDENT(''DiaryDelegations'', RESEED, @maxVal)'

    EXEC (@COMMAND)

      IF EXISTS
        (SELECT TOP 1 1 FROM [dbo].[DiaryDelegations])
        BEGIN
          SET @COMMAND = 'DROP TABLE [dbo].[FIXDDL]'

          EXEC (@COMMAND)
        END
      ELSE
        BEGIN
          IF NOT EXISTS
            (SELECT TOP 1 1 FROM [dbo].[FIXDDL])
            BEGIN
              SET @COMMAND = 'DROP TABLE [dbo].[FIXDDL]'

              EXEC (@COMMAND)
            END
        END
  END
GO

IF EXISTS
  (SELECT *
     FROM [master].sys.[databases] DBS
    WHERE DBS.[name] = CONVERT(VARCHAR(50), DB_NAME()) + '_DIA')
BEGIN
  DECLARE @COMMAND VARCHAR(MAX)

  SET @COMMAND = 'DROP DATABASE ' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA'

  EXEC (@COMMAND)
END
GO

DECLARE @FixDiary BIT
DECLARE @HasXOL BIT
DECLARE @HasCol INT
DECLARE @sqlcmd NVARCHAR(MAX)
DECLARE @StillHasDiary BIT
DECLARE @COMMAND VARCHAR(MAX)
DECLARE @DB NVARCHAR(100)

SET @FixDiary = 0
SET @HasXOL = 0
SET @HasCol = 0
SET @StillHasDiary = 1
SET @DB = DB_NAME()

DECLARE @EXPRESS VARCHAR(20)

SET @EXPRESS = CASE WHEN PATINDEX('%xpress%', CONVERT(VARCHAR(100), SERVERPROPERTY('edition'))) > 0 THEN 'PRIMARY' ELSE 'TEXTDATA' END

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'diary'
      AND SO.[type] = 'U')
  IF NOT EXISTS
    (select TOP 1 1
       from sys.[objects] SO
            INNER JOIN sys.[sysconstraints] SC
                       INNER JOIN sys.[objects] SOC
                               ON SOC.[object_id] = SC.[constid]
                              AND SOC.[name] = 'DF_diary_FileNum'
                    ON SC.[id] = SO.[object_id]
            INNER JOIN sys.[columns] SCL2
                    ON SCL2.[object_id] = SO.[object_id]
                   AND SCL2.[name] = 'CASECODE'
                   AND SCL2.[system_type_id] = 167
                   AND SCL2.[max_length] = 20
      WHERE SO.[name] = 'diary')
    BEGIN
      SET @FixDiary = 1
    END

IF (@FixDiary = 0)
  BEGIN
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
        WHERE SO.[name] = 'diary'
          AND SO.[type] = 'U')
      IF NOT EXISTS
        (SELECT TOP 1 1
           FROM sys.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'CaseAssociate'
          WHERE SO.[name] = 'diary'
            AND SO.[type] = 'U')
        BEGIN
          SET @FixDiary = 1
        END
  END

IF (@FixDiary = 1)
  BEGIN
    SET @COMMAND = 'IF EXISTS
  (select *
     FROM [master].[sys].[databases] [DB]
    WHERE [DB].[name] = ''' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA'')
BEGIN
  DROP DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA]
END'
    EXEC (@COMMAND)

    DECLARE @Path NVARCHAR(4000)
    DECLARE @FN NVARCHAR(100)

    SET @DB = DB_NAME()

    SELECT @Path = [filename] FROM master..sysdatabases WHERE name = @DB

    IF CHARINDEX('\', @Path) > 0 
      BEGIN
        SET @FN = SUBSTRING(@Path, LEN(@Path) - CharIndex('\', Reverse(@Path)) + 2, CharIndex('\', Reverse(@Path)) - 1)
        SET @Path = SUBSTRING(@Path, 1, LEN(@Path) - CharIndex('\', Reverse(@Path)))
        IF CHARINDEX('.', @FN) > 0 
          BEGIN
            SET @FN = SUBSTRING(@FN, 1, LEN(@FN) - CharIndex('.', Reverse(@FN)))
          END
      END 

    SET @COMMAND = 'CREATE DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA]
 ON  PRIMARY 
( NAME = N''' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA'', FILENAME = N''' + @Path + '\' + @DB + '_DIA.mdf'' , SIZE = 100MB , MAXSIZE = UNLIMITED, FILEGROWTH = 20% )
 LOG ON 
( NAME = N''' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA_log'', FILENAME = N''' + @Path + '\' + @DB + '_DIA_1.ldf'' , SIZE = 100MB , MAXSIZE = UNLIMITED , FILEGROWTH = 20%)'

    EXEC (@COMMAND)

    DECLARE @COLLATION VARCHAR(100)

    select @COLLATION = [DB].[collation_name]
      from [master].[sys].[databases] [DB]
     where [DB].[name] = @DB

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] COLLATE ' + @COLLATION

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET ANSI_NULL_DEFAULT OFF '
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET ANSI_NULLS OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET ANSI_PADDING OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET ANSI_WARNINGS OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET ARITHABORT OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET AUTO_CLOSE OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET AUTO_CREATE_STATISTICS ON'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET AUTO_SHRINK OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET AUTO_UPDATE_STATISTICS ON'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET CURSOR_CLOSE_ON_COMMIT OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET CURSOR_DEFAULT GLOBAL'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET CONCAT_NULL_YIELDS_NULL OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET NUMERIC_ROUNDABORT OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET QUOTED_IDENTIFIER OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET RECURSIVE_TRIGGERS OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET DISABLE_BROKER'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET AUTO_UPDATE_STATISTICS_ASYNC OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET DATE_CORRELATION_OPTIMIZATION OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET TRUSTWORTHY OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET ALLOW_SNAPSHOT_ISOLATION OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET PARAMETERIZATION SIMPLE'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET READ_COMMITTED_SNAPSHOT OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET MULTI_USER'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET PAGE_VERIFY CHECKSUM'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET DB_CHAINING OFF'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA] SET  READ_WRITE'
    
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER DATABASE [' + DB_NAME() + '_DIA] SET RECOVERY SIMPLE'

    EXEC (@COMMAND)

    SET @COMMAND = 'IF EXISTS
  (SELECT *
     FROM [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[SYS].[objects] SO
    WHERE SO.[name] = ''XOLFIX''
      AND SO.[type] = ''U'')
BEGIN
  DROP TABLE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX]
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'SELECT *
  INTO [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX]
  FROM [dbo].[diary]'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE 
      [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX]
  ADD CONSTRAINT 
      [PK_XOLFIX]
      PRIMARY KEY CLUSTERED 
     ([ActionID] ASC)'
    EXEC (@COMMAND)

    SET @HasXOL = 1
  END

IF (@HasXOL = 1)
  BEGIN
    SET @COMMAND = '
IF EXISTS (SELECT * FROM sys.[objects] SO WHERE SO.[name] = ''diary'' AND SO.[type] = ''U'')
  BEGIN
    IF EXISTS
      (SELECT *
         FROM [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[sys].[objects] SO
        WHERE SO.[name] = ''XOLFIX'')
      BEGIN
        IF EXISTS
          (SELECT * FROM [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX])
            BEGIN
              IF EXISTS (SELECT * FROM sys.[foreign_keys] WHERE [name] = ''FK_DiaryDelegations_diary'')
                BEGIN
                  ALTER TABLE [dbo].[DiaryDelegations] DROP CONSTRAINT [FK_DiaryDelegations_diary]
                END

              DROP TABLE [dbo].[diary]
            END
        ELSE
          BEGIN
            IF NOT EXISTS (SELECT * FROM [dbo].[diary])
              BEGIN
                IF EXISTS (SELECT * FROM sys.[foreign_keys] WHERE [name] = ''FK_DiaryDelegations_diary'')
                  BEGIN
                    ALTER TABLE [dbo].[DiaryDelegations] DROP CONSTRAINT [FK_DiaryDelegations_diary]
                  END

                DROP TABLE [dbo].[diary]
              END
          END
      END
  END'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TABLE
       [dbo].[diary]
      ([ACTIONID]            [int]                                                                        NOT NULL,
       [CASECODE]            [varchar](20)                                                                NOT NULL,
       [PRIORITY]            [varchar](1)                                                                     NULL,
       [HIGHLIGHTED]         [varchar](1)                                                                     NULL,
       [PUBLISH]             [varchar](1)                                                                     NULL,
       [DATE]                [datetime]                                                                   NOT NULL,
       [STATUS]              [smallint]                                                                       NULL,
       [ACTIONCODE]          [varchar](15)                                                                    NULL,
       [ACTIONSTATUS]        [varchar](3)                                                                     NULL,
       [ACTIONTYPE]          [varchar](1)                                                                     NULL,
       [PROCESSTYPE]         [varchar](1)                                                                     NULL,
       [FNCODE]              [varchar](10)                                                                    NULL,
       [TEAMCODE]            [varchar](10)                                                                    NULL,
       [TEXT1]               [varchar](max)                                                                   NULL,
       [TEXT2]               [varchar](max)                                                                   NULL,
       [DELEGATEDFNR]        [varchar](10)                                                                    NULL,
       [DELEGATEDDATE]       [datetime]                                                                       NULL,
       [DELEGATEDBACKDATE]   [datetime]                                                                       NULL,
       [DEFERRED]            [varchar](3)                                                                     NULL,
       [DUEDATE]             [datetime]                                                                       NULL,
       [IMAGENO]             [int]                                                                            NULL,
       [DYSTARTTIME]         [varchar](10)                                                                    NULL,
       [DYENDTIME]           [varchar](10)                                                                    NULL,
       [DURATION]            [smallint]                                                                       NULL,
       [ORGINALACTIONID]     [int]          CONSTRAINT [DF_diary_ORGINALACTIONID] DEFAULT 0               NOT NULL,
       [MILESTEONETYPE]      [varchar](12)                                                                    NULL,
       [ATTACHMENTS]         [varchar](1)                                                                     NULL,
       [PROCESSSTATUS]       [smallint]                                                                       NULL,
       [WORKPROCESS]         [smallint]                                                                       NULL,
       [BILLABLE]            [int]                                                                            NULL,
       [BILLDESCRIPTION]     [varchar](150)                                                                   NULL,
       [EMAILADDRESS]        [varchar](150)                                                                   NULL,
       [EMAIL]               [varchar](1)                                                                     NULL,
       [SUBJECT]             [varchar](500)                                                                   NULL,
       [DELEGATIONSTATUS]    [int]          CONSTRAINT [DF_diary_DELEGATIONSTATUS] DEFAULT 0              NOT NULL,
       [DRAFTBILLNO]         [int]                                                                            NULL,
       [CHEQUEREQNO]         [int]                                                                            NULL,
       [TxmSent]             [bit]          CONSTRAINT [DF_diary_TxmSent] DEFAULT 0                       NOT NULL,
       [Location]            [varchar](50)                                                                    NULL,
       [HearingType]         [varchar](50)                                                                    NULL,
       [ForCopy]             [varchar](1)                                                                     NULL,
       [TxmDate]             [datetime]                                                                       NULL,
       [TxmSeqNo]            [int]                                                                            NULL,
       [DisplayText]         [nvarchar](200)                                                                  NULL,
       [Flag]                [tinyint]                                                                        NULL,
       [ADDRESSTO]           [varchar](2000)                                                                  NULL,
       [CCTo]                [varchar](2000)                                                                  NULL,
       [BCCTo]               [varchar](2000)                                                                  NULL,
       [ClientContactID]     [int]                                                                            NULL,
       [ContactCategory]     [int]                                                                            NULL,
       [Campaign]            [int]                                                                            NULL,
       [FileNum]             [int]          CONSTRAINT [DF_diary_FileNum] DEFAULT 0                       NOT NULL,
       [CaseAssociate]       [varchar](6)                                                                     NULL,
       CONSTRAINT [PK_diary]
                  PRIMARY KEY CLUSTERED 
                 ([ACTIONID] ASC)
               ON [PRIMARY])
    ON [PRIMARY]
       TEXTIMAGE_ON [' + @EXPRESS + ']'

    EXEC (@COMMAND)

    SET @COMMAND = 'IF EXISTS
  (SELECT * FROM [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX])
BEGIN
IF NOT EXISTS
  (SELECT * FROM [dbo].[diary])
BEGIN
INSERT
  INTO [dbo].[diary]
      ([ACTIONID],
       [CASECODE],
       [PRIORITY],
       [HIGHLIGHTED],
       [PUBLISH],
       [DATE],
       [STATUS],
       [ACTIONCODE],
       [ACTIONSTATUS],
       [ACTIONTYPE],
       [PROCESSTYPE],
       [FNCODE],
       [TEAMCODE],
       [TEXT1],
       [TEXT2],
       [DELEGATEDFNR],
       [DELEGATEDDATE],
       [DELEGATEDBACKDATE],
       [DEFERRED],
       [DUEDATE],
       [IMAGENO],
       [DYSTARTTIME],
       [DYENDTIME],
       [DURATION],
       [ORGINALACTIONID],
       [MILESTEONETYPE],
       [ATTACHMENTS],
       [PROCESSSTATUS],
       [WORKPROCESS],
       [BILLABLE],
       [BILLDESCRIPTION],
       [EMAILADDRESS],
       [EMAIL],
       [SUBJECT],
       [DELEGATIONSTATUS],
       [DRAFTBILLNO],
       [CHEQUEREQNO],
       [TxmSent],
       [Location],
       [HearingType],
       [ForCopy],
       [TxmDate],
       [TxmSeqNo])
SELECT XOLX.[ACTIONID],
       RTRIM(ISNULL(XOLX.[CASECODE], '''')),
       RTRIM(XOLX.[PRIORITY]),
       RTRIM(XOLX.[HIGHLIGHTED]),
       RTRIM(XOLX.[PUBLISH]),
       ISNULL(XOLX.[DATE], ''19000101''),
       XOLX.[STATUS],
       RTRIM(XOLX.[ACTIONCODE]),
       RTRIM(XOLX.[ACTIONSTATUS]),
       RTRIM(XOLX.[ACTIONTYPE]),
       RTRIM(XOLX.[PROCESSTYPE]),
       RTRIM(XOLX.[FNCODE]),
       RTRIM(XOLX.[TEAMCODE]),
       RTRIM(CONVERT(VARCHAR(MAX), XOLX.[TEXT1])),
       RTRIM(CONVERT(VARCHAR(MAX), XOLX.[TEXT2])),
       RTRIM(XOLX.[DELEGATEDFNR]),
       XOLX.[DELEGATEDDATE],
       XOLX.[DELEGATEDBACKDATE],
       RTRIM(XOLX.[DEFERRED]),
       XOLX.[DUEDATE],
       XOLX.[IMAGENO],
       RTRIM(XOLX.[DYSTARTTIME]),
       RTRIM(XOLX.[DYENDTIME]),
       XOLX.[DURATION],
       ISNULL(XOLX.[ORGINALACTIONID], 0),
       RTRIM(XOLX.[MILESTEONETYPE]),
       RTRIM(XOLX.[ATTACHMENTS]),
       XOLX.[PROCESSSTATUS],
       XOLX.[WORKPROCESS],
       XOLX.[BILLABLE],
       RTRIM(XOLX.[BILLDESCRIPTION]),
       RTRIM(XOLX.[EMAILADDRESS]),
       RTRIM(XOLX.[EMAIL]),
       RTRIM(CONVERT(VARCHAR(150), XOLX.[SUBJECT])),
       ISNULL(XOLX.[DELEGATIONSTATUS], 0),
       XOLX.[DRAFTBILLNO],
       XOLX.[CHEQUEREQNO],
       ISNULL(XOLX.[TxmSent], 0),
       RTRIM(XOLX.[Location]),
       RTRIM(XOLX.[HearingType]),
       RTRIM(XOLX.[ForCopy]),
       XOLX.[TxmDate],
       XOLX.[TxmSeqNo]
  FROM [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX] XOLX
END
END'

    EXEC (@COMMAND)

    --Column is named "ADDRESSTO"
    SET @HasCol = 0
    SET @sqlcmd = N'
       SELECT @HasCol = COUNT(1)
         FROM [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[objects] SO
              INNER JOIN [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = ''ADDRESSTO''
        WHERE SO.[name] = ''XOLFIX''
          AND SO.[type] = ''U'''

    EXECUTE sp_executesql @sqlcmd, N'@HasCol int OUTPUT', @HasCol=@HasCol OUTPUT

    IF (@HasCol > 0)
      BEGIN

        SET @COMMAND = '  UPDATE XOL
     SET XOL.[ADDRESSTO] = RTRIM(CONVERT(VARCHAR(2000), XOLX.[ADDRESSTO]))
    FROM [dbo].[diary] XOL
         INNER JOIN [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX] XOLX
                 ON XOLX.[ActionID] = XOL.[ActionID]'

        EXEC (@COMMAND)
      END

    --Column is named "CCTO"
    SET @HasCol = 0
    SET @sqlcmd = N'
       SELECT @HasCol = COUNT(1)
         FROM [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[objects] SO
              INNER JOIN [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = ''CCTO''
        WHERE SO.[name] = ''XOLFIX''
          AND SO.[type] = ''U'''

    EXECUTE sp_executesql @sqlcmd, N'@HasCol int OUTPUT', @HasCol=@HasCol OUTPUT

    IF (@HasCol > 0)
      BEGIN

        SET @COMMAND = '  UPDATE XOL
     SET XOL.[CCTO] = RTRIM(CONVERT(VARCHAR(2000), XOLX.[CCTO]))
    FROM [dbo].[diary] XOL
         INNER JOIN [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX] XOLX
                 ON XOLX.[ActionID] = XOL.[ActionID]'

        EXEC (@COMMAND)
      END

    --Column is named "BCCTO"
    SET @HasCol = 0
    SET @sqlcmd = N'
       SELECT @HasCol = COUNT(1)
         FROM [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[objects] SO
              INNER JOIN [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = ''BCCTO''
        WHERE SO.[name] = ''XOLFIX''
          AND SO.[type] = ''U'''

    EXECUTE sp_executesql @sqlcmd, N'@HasCol int OUTPUT', @HasCol=@HasCol OUTPUT

    IF (@HasCol > 0)
      BEGIN

        SET @COMMAND = '  UPDATE XOL
     SET XOL.[BCCTO] = RTRIM(CONVERT(VARCHAR(2000), XOLX.[BCCTO]))
    FROM [dbo].[diary] XOL
         INNER JOIN [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX] XOLX
                 ON XOLX.[ActionID] = XOL.[ActionID]'

        EXEC (@COMMAND)
      END

    ----Column is named "DisplayText"
    --IF EXISTS
    --  (SELECT *
    --     FROM SYS.[objects] SO
    --          INNER JOIN SYS.[columns] SC
    --                  ON SC.[object_id] = SO.[object_id]
    --                 AND SC.[name] = 'DisplayText'
    --    WHERE SO.[name] = 'XOLFIX'
    --      AND SO.[type] = 'U')
    --  BEGIN

    --    SET @COMMAND = '  UPDATE XOL
    -- SET XOL.[DisplayText] = [dbo].[ky_RemoveSpuriousWhitespace2](XOL.[TEXT1], 200)
    --FROM [dbo].[diary] XOL'

    --    EXEC (@COMMAND)
    --  END

    --Column is named "Flag"
    SET @HasCol = 0
    SET @sqlcmd = N'
       SELECT @HasCol = COUNT(1)
         FROM [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[objects] SO
              INNER JOIN [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = ''Flag''
        WHERE SO.[name] = ''XOLFIX''
          AND SO.[type] = ''U'''

    EXECUTE sp_executesql @sqlcmd, N'@HasCol int OUTPUT', @HasCol=@HasCol OUTPUT

    IF (@HasCol > 0)
      BEGIN

        SET @COMMAND = '  UPDATE XOL
     SET XOL.[Flag] = XOLX.[Flag]
    FROM [dbo].[diary] XOL
         INNER JOIN [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX] XOLX
                 ON XOLX.[ActionID] = XOL.[ActionID]'

        EXEC (@COMMAND)
      END

    --Column is named "ClientContactID"
    SET @HasCol = 0
    SET @sqlcmd = N'
       SELECT @HasCol = COUNT(1)
         FROM [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[objects] SO
              INNER JOIN [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = ''ClientContactID''
        WHERE SO.[name] = ''XOLFIX''
          AND SO.[type] = ''U'''

    EXECUTE sp_executesql @sqlcmd, N'@HasCol int OUTPUT', @HasCol=@HasCol OUTPUT

    IF (@HasCol > 0)
      BEGIN

        SET @COMMAND = '  UPDATE XOL
     SET XOL.[ClientContactID] = XOLX.[ClientContactID]
    FROM [dbo].[diary] XOL
         INNER JOIN [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX] XOLX
                 ON XOLX.[ActionID] = XOL.[ActionID]'

        EXEC (@COMMAND)
      END

    --Column is named "ContactCategory"
    SET @HasCol = 0
    SET @sqlcmd = N'
       SELECT @HasCol = COUNT(1)
         FROM [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[objects] SO
              INNER JOIN [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = ''ContactCategory''
        WHERE SO.[name] = ''XOLFIX''
          AND SO.[type] = ''U'''

    EXECUTE sp_executesql @sqlcmd, N'@HasCol int OUTPUT', @HasCol=@HasCol OUTPUT

    IF (@HasCol > 0)
      BEGIN

        SET @COMMAND = '  UPDATE XOL
     SET XOL.[ContactCategory] = XOLX.[ContactCategory]
    FROM [dbo].[diary] XOL
         INNER JOIN [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX] XOLX
                 ON XOLX.[ActionID] = XOL.[ActionID]'

        EXEC (@COMMAND)
      END

    --Column is named "Campaign"
    SET @HasCol = 0
    SET @sqlcmd = N'
       SELECT @HasCol = COUNT(1)
         FROM [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[objects] SO
              INNER JOIN [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = ''Campaign''
        WHERE SO.[name] = ''XOLFIX''
          AND SO.[type] = ''U'''

    EXECUTE sp_executesql @sqlcmd, N'@HasCol int OUTPUT', @HasCol=@HasCol OUTPUT

    IF (@HasCol > 0)
      BEGIN

        SET @COMMAND = '  UPDATE XOL
     SET XOL.[Campaign] = XOLX.[Campaign]
    FROM [dbo].[diary] XOL
         INNER JOIN [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX] XOLX
                 ON XOLX.[ActionID] = XOL.[ActionID]'

        EXEC (@COMMAND)
      END

    --Column is named "FileNum"
    SET @HasCol = 0
    SET @sqlcmd = N'
       SELECT @HasCol = COUNT(1)
         FROM [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[objects] SO
              INNER JOIN [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = ''FileNum''
        WHERE SO.[name] = ''XOLFIX''
          AND SO.[type] = ''U'''

    EXECUTE sp_executesql @sqlcmd, N'@HasCol int OUTPUT', @HasCol=@HasCol OUTPUT

    IF (@HasCol > 0)
      BEGIN

        SET @COMMAND = '  UPDATE XOL
     SET XOL.[FileNum] = ISNULL(XOLX.[FileNum], 0)
    FROM [dbo].[diary] XOL
         INNER JOIN [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX] XOLX
                 ON XOLX.[ActionID] = XOL.[ActionID]'

        EXEC (@COMMAND)
      END

    --Column is named "CaseAssociate"
    SET @HasCol = 0
    SET @sqlcmd = N'
       SELECT @HasCol = COUNT(1)
         FROM [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[objects] SO
              INNER JOIN [' + CONVERT(NVARCHAR(50), DB_NAME()) + '_DIA].SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = ''CaseAssociate''
        WHERE SO.[name] = ''XOLFIX''
          AND SO.[type] = ''U'''

    EXECUTE sp_executesql @sqlcmd, N'@HasCol int OUTPUT', @HasCol=@HasCol OUTPUT

    IF (@HasCol > 0)
      BEGIN

        SET @COMMAND = '  UPDATE XOL
     SET XOL.[CaseAssociate] = XOLX.[CaseAssociate]
    FROM [dbo].[diary] XOL
         INNER JOIN [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA].[dbo].[XOLFIX] XOLX
                 ON XOLX.[ActionID] = XOL.[ActionID]'

        EXEC (@COMMAND)
      END

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [IDX_diaryCase]
    ON [dbo].[diary]
      ([CASECODE] ASC,
       [DATE]     ASC)
       INCLUDE ([PUBLISH],
                [STATUS],
                [HIGHLIGHTED],
                [ACTIONCODE],
                [ACTIONID],
                [DYSTARTTIME],
                [PROCESSSTATUS])
             ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [IDX_DraftBillNo]
    ON [dbo].[diary]
      ([DRAFTBILLNO] ASC)
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [IDX_Action]
    ON [dbo].[diary]
      ([ACTIONCODE] ASC,
       [CASECODE] ASC,
       [DATE] ASC,
       [ACTIONID] ASC)
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [IDX_EmailDates]
    ON [dbo].[diary]
      ([EMAIL] ASC)
       INCLUDE ([TxmDate],
                [DATE])
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [IDX_FeeEarner]
    ON [dbo].[diary]
      ([FNCODE] ASC,
       [DATE] ASC,
       [ACTIONID] ASC)
       INCLUDE ([PROCESSSTATUS],
                [STATUS],
                [CASECODE])
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [IDX_OrginalId]
    ON [dbo].[diary]
      ([ORGINALACTIONID] ASC,
       [ACTIONID] ASC)
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [IDX_Team]
    ON [dbo].[diary]
      ([TEAMCODE] ASC,
       [STATUS] ASC,
       [DATE] DESC,
       [ACTIONID] DESC)
       INCLUDE ([CASECODE])
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [IDX_TypeCase]
    ON [dbo].[diary]
      ([ACTIONTYPE] ASC,
       [DATE] DESC,
       [ACTIONID] DESC)
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'DELETE DEL
  FROM [dbo].[DiaryDelegations] DEL
       LEFT OUTER JOIN [dbo].[diary] DIA
                    ON DIA.[ActionID] = DEL.[ActionID]
 WHERE DIA.[ActionID] IS NULL
    OR DEL.[ActionID] = 0'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER
TABLE [dbo].[DiaryDelegations]
      WITH CHECK
  ADD CONSTRAINT [FK_DiaryDelegations_diary] 
                 FOREIGN KEY ([ACTIONID])
                  REFERENCES  [dbo].[diary] 
                             ([ACTIONID])
   ON UPDATE CASCADE
   ON DELETE CASCADE'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE [dbo].[DiaryDelegations] CHECK CONSTRAINT [FK_DiaryDelegations_diary]'

    EXEC (@COMMAND)

  END


GO

IF EXISTS
  (SELECT *
     FROM [master].sys.[databases] DBS
    WHERE DBS.[name] = CONVERT(VARCHAR(50), DB_NAME()) + '_DIA')
BEGIN
  DECLARE @COMMAND VARCHAR(MAX)

  SET @COMMAND = 'DROP DATABASE [' + CONVERT(VARCHAR(50), DB_NAME()) + '_DIA]'

  EXEC (@COMMAND)
END
GO

IF EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[diary] DIA
    WHERE DIA.[DisplayText] IS NULL)
BEGIN
  UPDATE DIA
     SET DIA.[DisplayText] = CASE WHEN DIA.[DisplayText] IS NULL 
                                       THEN CONVERT(NVARCHAR(200), [dbo].[ky_RemoveSpuriousWhitespace2](DIA.[TEXT1], 200))
                                  ELSE DIA.[DisplayText] END
    FROM [dbo].[diary] DIA
END
GO

IF NOT EXISTS
  (SELECT *
     FROM sys.[foreign_keys] FK
    WHERE FK.[name] = 'FK_DiaryDelegations_diary')
  BEGIN
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'DELETE DEL
  FROM [dbo].[DiaryDelegations] DEL
       LEFT OUTER JOIN [dbo].[diary] DIA
                    ON DIA.[ActionID] = DEL.[ActionID]
 WHERE DIA.[ActionID] IS NULL
    OR DEL.[ActionID] = 0'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER
TABLE [dbo].[DiaryDelegations]
      WITH CHECK
  ADD CONSTRAINT [FK_DiaryDelegations_diary] 
                 FOREIGN KEY ([ACTIONID])
                  REFERENCES  [dbo].[diary] 
                             ([ACTIONID])
   ON UPDATE CASCADE
   ON DELETE CASCADE'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE [dbo].[DiaryDelegations] CHECK CONSTRAINT [FK_DiaryDelegations_diary]'

    EXEC (@COMMAND)
  END

DECLARE @CODELEN VARCHAR(2)

SELECT @CODELEN = CONVERT(VARCHAR(2), SC.[max_length])
  FROM SYS.[objects] SO
       INNER JOIN SYS.[columns] SC
               ON SC.[object_id] = SO.[object_id]
              AND SC.[name] = 'PCODE'
 WHERE SO.[name] = 'matters'
   AND SO.[type] = 'U'

IF (@CODELEN <> '20')
  BEGIN
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
    BEGIN
      SET @COMMAND = 'DROP TABLE [dbo].[FIXMAT]'

      EXEC (@COMMAND)
    END

    SET @COMMAND = 'SELECT *
  INTO [dbo].[FIXMAT]
  FROM [dbo].[matters]'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE 
      [dbo].[FIXMAT]
  ADD CONSTRAINT 
      [PK_FIXMAT]
      PRIMARY KEY CLUSTERED 
     ([Code] ASC)'

    EXEC (@COMMAND)

    SET @COMMAND = 'DROP TABLE [dbo].[matters]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TABLE 
       [dbo].[matters]
      ([Code]                         [varchar](' + @CODELEN + ')                                                                   NOT NULL,
       [ClientCode]                   [varchar](8)                                                                    NOT NULL,
       [Matter]                       [varchar](8)                                                                    NOT NULL,
       [Description]                  [varchar](200)  CONSTRAINT [DF_matters_Description] DEFAULT ''''                  NOT NULL,
       [FECode]                       [varchar](10)                                                                   NOT NULL,
       [Partner]                      [varchar](10)                                                                       NULL,
       [Secretary]                    [varchar](10)                                                                       NULL,
       [Dept]                         [varchar](5)                                                                    NOT NULL,
       [Started]                      [datetime]                                                                      NOT NULL,
       [WType]                        [varchar](5)                                                                    NOT NULL,
       [Branch]                       [varchar](3)                                                                        NULL,
       [EstFee]                       [decimal](17, 2) CONSTRAINT [DF_matters_EstFee] DEFAULT 0                       NOT NULL,
       [OutlayBud]                    [decimal](17, 2) CONSTRAINT [DF_matters_OutlayBud] DEFAULT 0                    NOT NULL,
       [ExpBillD]                     [datetime]                                                                          NULL,
       [ExpPayD]                      [datetime]                                                                          NULL,
       [S13]                          [char](1)                                                                           NULL,
       [Comment]                      [varchar](3000)                                                                     NULL,
       [DebtBal]                      [decimal](17, 2) CONSTRAINT [DF_matters_DebtBal] DEFAULT 0                      NOT NULL,
       [OutlayBal]                    [decimal](17, 2) CONSTRAINT [DF_matters_OutlayBal] DEFAULT 0                    NOT NULL,
       [ClientBal]                    [decimal](17, 2) CONSTRAINT [DF_matters_ClientBal] DEFAULT 0                    NOT NULL,
       [ClientCurBal]                 [decimal](17, 2) CONSTRAINT [DF_matters_ClientCurBal] DEFAULT 0                 NOT NULL,
       [ClientDepBal]                 [decimal](17, 2) CONSTRAINT [DF_matters_ClientDepBal] DEFAULT 0                 NOT NULL,
       [DebtBalFwd]                   [decimal](17, 2) CONSTRAINT [DF_matters_DebtBalFwd] DEFAULT 0                   NOT NULL,
       [OutlayBalFwd]                 [decimal](17, 2) CONSTRAINT [DF_matters_OutlayBalFwd] DEFAULT 0                 NOT NULL,
       [ClientBalFwd]                 [decimal](17, 2) CONSTRAINT [DF_matters_ClientBalFwd] DEFAULT 0                 NOT NULL,
       [ClientCurBalFwd]              [decimal](17, 2) CONSTRAINT [DF_matters_ClientCurBalFwd] DEFAULT 0              NOT NULL,
       [ClientDepBalFwd]              [decimal](17, 2) CONSTRAINT [DF_matters_ClientDepBalFwd] DEFAULT 0              NOT NULL,
       [PendingBal]                   [decimal](17, 2) CONSTRAINT [DF_matters_PendingBal] DEFAULT 0                   NOT NULL,
       [ClientMin]                    [decimal](17, 2) CONSTRAINT [DF_matters_ClientMin] DEFAULT 0                    NOT NULL,
       [FileNum]                      [int]                                                                               NULL,
       [ThirdPart]                    [varchar](6)                                                                        NULL,
       [ThPartSol]                    [varchar](6)                                                                        NULL,
       [Value]                        [decimal](17, 2) CONSTRAINT [DF_matters_Value] DEFAULT 0                        NOT NULL,
       [Undertaking]                  [char](1)                                                                           NULL,
       [LastAct]                      [datetime]                                                                          NULL,
       [LastActType]                  [varchar](10)                                                                       NULL,
       [LastActWho]                   [varchar](10)                                                                       NULL,
       [StatuteLimits]                [datetime]                                                                          NULL,
       [Status]                       [varchar](6)                                                                        NULL,
       [Section68]                    [char](1)                                                                           NULL,
       [FNL_Date]                     [datetime]                                                                          NULL,
       [FNL_Name]                     [varchar](50)                                                                       NULL,
       [FNL_Address]                  [varchar](120)                                                                      NULL,
       [FNL_Fees]                     [decimal](15, 2) CONSTRAINT [DF_matters_FNL_Fees] DEFAULT 0                     NOT NULL,
       [FNL_Outlay]                   [decimal](15, 2) CONSTRAINT [DF_matters_FNL_Outlay] DEFAULT 0                   NOT NULL,
       [FNL_VAT]                      [decimal](15, 2) CONSTRAINT [DF_matters_FNL_VAT] DEFAULT 0                      NOT NULL,
       [FNL_Total]                    [decimal](15, 2) CONSTRAINT [DF_matters_FNL_Total] DEFAULT 0                    NOT NULL,
       [OldRef]                       [varchar](12)                                                                       NULL,
       [PCODE]                        [varchar](20)                                                                       NULL,
       [PFECODE]                      [varchar](10)                                                                       NULL,
       [User1]                        [varchar](20)                                                                       NULL,
       [User2]                        [varchar](20)                                                                       NULL,
       [User3]                        [varchar](20)                                                                       NULL,
       [DepositName]                  [varchar](40)                                                                       NULL,
       [DepositType]                  [char](4)                                                                           NULL,
       [TimeBal]                      [decimal](13, 2) CONSTRAINT [DF_matters_TimeBal] DEFAULT 0                      NOT NULL,
       [ChargeBal]                    [decimal](13, 2) CONSTRAINT [DF_matters_ChargeBal] DEFAULT 0                    NOT NULL,
       [YourRef]                      [varchar](100)                                                                      NULL,
       [CurDebtBal]                   [decimal](17, 2) CONSTRAINT [DF_matters_CurDebtBal] DEFAULT 0                   NOT NULL,
       [CurOutlayBal]                 [decimal](17, 2) CONSTRAINT [DF_matters_CurOutlayBal] DEFAULT 0                 NOT NULL,
       [CurClientBal]                 [decimal](17, 2) CONSTRAINT [DF_matters_CurClientBal] DEFAULT 0                 NOT NULL,
       [CurClientCBal]                [decimal](17, 2) CONSTRAINT [DF_matters_CurClientCBal] DEFAULT 0                NOT NULL,
       [CurClientDBal]                [decimal](17, 2) CONSTRAINT [DF_matters_CurClientDBal] DEFAULT 0                NOT NULL,
       [CurDebtBalFwd]                [decimal](17, 2) CONSTRAINT [DF_matters_CurDebtBalFwd] DEFAULT 0                NOT NULL,
       [CurOutlayBalFwd]              [decimal](17, 2) CONSTRAINT [DF_matters_CurOutlayBalFwd] DEFAULT 0              NOT NULL,
       [CurClientBalFwd]              [decimal](17, 2) CONSTRAINT [DF_matters_CurClientBalFwd] DEFAULT 0              NOT NULL,
       [CurClientCBalFwd]             [decimal](17, 2) CONSTRAINT [DF_matters_CurClientCBalFwd] DEFAULT 0             NOT NULL,
       [CurClientDBalFwd]             [decimal](17, 2) CONSTRAINT [DF_matters_CurClientDBalFwd] DEFAULT 0             NOT NULL,
       [CurPendingBal]                [decimal](17, 2) CONSTRAINT [DF_matters_CurPendingBal] DEFAULT 0                NOT NULL,
       [Unallocated]                  [decimal](13, 2) CONSTRAINT [DF_matters_Unallocated] DEFAULT 0                  NOT NULL,
       [Statements]                   [char](1)                                                                           NULL,
       [ChargeLevel]                  [int]                                                                               NULL,
       [FileColour]                   [char](3)                                                                           NULL,
       [OpenInvoiceNo]                [int]                                                                               NULL,
       [Password]                     [varchar](20)                                                                       NULL,
       [CompBillOnOff]                [char](1)                                                                           NULL,
       [CompFrequency]                [char](1)                                                                           NULL,
       [CompOutlayLimit]              [decimal](13, 2) CONSTRAINT [DF_matters_CompOutlayLimit] DEFAULT (0)            NOT NULL,
       [CompFeesLimit]                [decimal](13, 2) CONSTRAINT [DF_matters_CompFeesLimit] DEFAULT (0)              NOT NULL,
       [CompTotalLimit]               [decimal](13, 2) CONSTRAINT [DF_matters_CompTotalLimit] DEFAULT (0)             NOT NULL,
       [CompBillingMatter]            [varchar](20)                                                                       NULL,
       [CompBilling]                  [char](1)                                                                           NULL,
       [ClientName]                   [varchar](80)                                                                       NULL,
       [ClientAddress]                [varchar](150)                                                                      NULL,
       [ClientSalutation]             [varchar](40)                                                                       NULL,
       [ChargeArrangement]            [char](3)                                                                           NULL,
       [Importance]                   [smallint]                                                                          NULL,
       [OriginalDebt]                 [decimal](18, 2) CONSTRAINT [DF_matters_OriginalDebt] DEFAULT (0)               NOT NULL,
       [DebtCollected]                [decimal](18, 2) CONSTRAINT [DF_matters_DebtCollected] DEFAULT (0)              NOT NULL,
       [RecoverableCosts]             [decimal](18, 2) CONSTRAINT [DF_matters_RecoverableCosts] DEFAULT (0)           NOT NULL,
       [DebtInterest]                 [decimal](18, 2) CONSTRAINT [DF_matters_DebtInterest] DEFAULT (0)               NOT NULL,
       [BillingMethod]                [char](1)                                                                           NULL,
       [CollectingBalance]            [decimal](18, 2) CONSTRAINT [DF_matters_CollectingBalance] DEFAULT (0)          NOT NULL,
       [Publish]                      [char](1)                                                                           NULL,
       [Permissions]                  [int]            CONSTRAINT [DF_matters_Permissions] DEFAULT (0)                NOT NULL,
       [ChargeOutRateInd]             [char](1)                                                                           NULL,
       --Old SAM3
       [OUTFileNo]                    [int]                                                                               NULL,
       [OrgClosedDate]                [datetime]                                                                          NULL,
       [ReOpenedDate]                 [datetime]                                                                          NULL,
       --New SAM3
       [FixedFee]                     [char](1)        CONSTRAINT [DF_matters_FixedFee] DEFAULT (''N'')                 NOT NULL,
       [ShowCommentInAlarm]           [char](1)        CONSTRAINT [DF_matters_ShowCommentInAlarm] DEFAULT (''N'')       NOT NULL,
       [OtherRef]                     [varchar](10)                                                                       NULL,
       --New SAM3 and SAM4
       [Location]                     [varchar](20)                                                                       NULL,
       [DestroyDate]                  [datetime]                                                                          NULL,
       [Closed]                       [char](1)        CONSTRAINT [CV_matters_Closed] CHECK([Closed] = ''N'' OR [Closed] = ''Y'')
                                                       CONSTRAINT [DF_matters_Closed] DEFAULT ''N''                     NOT NULL,
       --Conflict
       [ClosingDate]                  [datetime]                                                                          NULL,
       [CloseDate]                    [datetime]                                                                          NULL,
       --SAM4
       [DepositAC1]                   [varchar](10)                                                                       NULL,
       [DepositAC2]                   [varchar](10)                                                                       NULL,
       [DepositAC3]                   [varchar](10)                                                                       NULL,
       [ArchiveDate]                  [datetime]                                                                          NULL,
       [ArchiveLocation]              [varchar](50)                                                                       NULL,
       [SetupYear]                    [int]                                                                               NULL,
       [SetupPeriod]                  [int]                                                                               NULL,
       [OldNew]                       [char](1)                                                                           NULL,
       [ClientBankAc]                 [varchar](10)                                                                       NULL,
       [OfficeBankAc]                 [varchar](10)                                                                       NULL,
       [FileManagerFileNumber]        [int]                                                                               NULL,
       [ItemCode]                     [varchar](20)                                                                       NULL,
       [BoxNumber]                    [varchar](20)                                                                       NULL,
       [BillingFE]                    [varchar](10)                                                                       NULL,
       [EstFeeIndicator]              [varchar](1)                                                                        NULL,
       CONSTRAINT [PK_matters]
                  PRIMARY KEY CLUSTERED 
                 ([Code] ASC)
               ON [PRIMARY]) ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRmattersInsert]
    ON [dbo].[matters]
       AFTER INSERT
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE MAT
         SET MAT.[CloseDate] = CASE WHEN MAT.[CloseDate] IS NULL
                                         THEN MAT.[ClosingDate]
                                    ELSE MAT.[CloseDate] END,
             MAT.[ClosingDate] = CASE WHEN MAT.[CloseDate] IS NULL
                                           THEN MAT.[ClosingDate]
                                      ELSE MAT.[CloseDate] END
        FROM inserted INS
             INNER JOIN [dbo].[matters] MAT
                     ON MAT.[Code] = INS.[Code]
       WHERE ISNULL(INS.[CloseDate], CONVERT(DATETIME, ''19000101'')) <> ISNULL(INS.[ClosingDate], CONVERT(DATETIME, ''19000101''))

    END
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRmattersUpdate]
    ON [dbo].[matters]
       AFTER Update
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE MAT
         SET MAT.[CloseDate] = CASE WHEN ISNULL(INS.[ClosingDate], CONVERT(DATETIME, ''19000101'')) <> ISNULL(DEL.[ClosingDate], CONVERT(DATETIME, ''19000101'')) 
                                         THEN INS.[ClosingDate]
                                    ELSE INS.[CloseDate] END,
             MAT.[ClosingDate] = CASE WHEN ISNULL(INS.[CloseDate], CONVERT(DATETIME, ''19000101'')) <> ISNULL(DEL.[CloseDate], CONVERT(DATETIME, ''19000101'')) 
                                           THEN INS.[CloseDate]
                                      ELSE INS.[ClosingDate] END
        FROM inserted INS
             INNER JOIN deleted DEL
                     ON DEL.[Code] = INS.[Code]
             INNER JOIN [dbo].[matters] MAT
                     ON MAT.[Code] = INS.[Code]
       WHERE ISNULL(INS.[CloseDate], CONVERT(DATETIME, ''19000101'')) <> ISNULL(DEL.[CloseDate], CONVERT(DATETIME, ''19000101''))
          OR ISNULL(INS.[ClosingDate], CONVERT(DATETIME, ''19000101'')) <> ISNULL(DEL.[ClosingDate], CONVERT(DATETIME, ''19000101''))
    END
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'INSERT
  INTO [dbo].[matters]
      ([Code],
       [ClientCode],
       [Matter],
       [Description],
       [FECode],
       [Partner],
       [Secretary],
       [Dept],
       [Started],
       [WType],
       [Branch],
       [EstFee],
       [OutlayBud],
       [ExpBillD],
       [ExpPayD],
       [S13],
       [Comment],
       [DebtBal],
       [OutlayBal],
       [ClientBal],
       [ClientCurBal],
       [ClientDepBal],
       [DebtBalFwd],
       [OutlayBalFwd],
       [ClientBalFwd],
       [ClientCurBalFwd],
       [ClientDepBalFwd],
       [PendingBal],
       [ClientMin],
       [FileNum],
       [ThirdPart],
       [ThPartSol],
       [Value],
       [Undertaking],
       [LastAct],
       [LastActType],
       [LastActWho],
       [StatuteLimits],
       [Status],
       [Section68],
       [FNL_Date],
       [FNL_Name],
       [FNL_Address],
       [FNL_Fees],
       [FNL_Outlay],
       [FNL_VAT],
       [FNL_Total],
       [OldRef],
       [PCODE],
       [PFECODE],
       [User1],
       [User2],
       [User3],
       [DepositName],
       [DepositType],
       [TimeBal],
       [ChargeBal],
       [YourRef],
       [CurDebtBal],
       [CurOutlayBal],
       [CurClientBal],
       [CurClientCBal],
       [CurClientDBal],
       [CurDebtBalFwd],
       [CurOutlayBalFwd],
       [CurClientBalFwd],
       [CurClientCBalFwd],
       [CurClientDBalFwd],
       [CurPendingBal],
       [Unallocated],
       [Statements],
       [ChargeLevel],
       [FileColour],
       [OpenInvoiceNo],
       [Password],
       [CompBillOnOff],
       [CompFrequency],
       [CompOutlayLimit],
       [CompFeesLimit],
       [CompTotalLimit],
       [CompBillingMatter],
       [CompBilling],
       [ClientName],
       [ClientAddress],
       [ClientSalutation],
       [ChargeArrangement],
       [Importance],
       [OriginalDebt],
       [DebtCollected],
       [RecoverableCosts],
       [DebtInterest],
       [BillingMethod],
       [CollectingBalance],
       [Publish],
       [Permissions],
       [ChargeOutRateInd])
SELECT RTRIM(ISNULL(MTX.[Code], '''')),
       RTRIM(ISNULL(MTX.[ClientCode], '''')),
       RTRIM(ISNULL(MTX.[Matter], '''')),
       RTRIM(ISNULL(MTX.[Description], '''')),
       RTRIM(ISNULL(MTX.[FECode], '''')),
       RTRIM(MTX.[Partner]),
       RTRIM(MTX.[Secretary]),
       RTRIM(ISNULL(MTX.[Dept], '''')),
       ISNULL([Started], ''19000101''),
       RTRIM(ISNULL(MTX.[WType], '''')),
       RTRIM(MTX.[Branch]),
       ISNULL(MTX.[EstFee], 0),
       ISNULL(MTX.[OutlayBud], 0),
       MTX.[ExpBillD],
       MTX.[ExpPayD],
       MTX.[S13],
       RTRIM(MTX.[Comment]),
       ISNULL(MTX.[DebtBal], 0),
       ISNULL(MTX.[OutlayBal], 0),
       ISNULL(MTX.[ClientBal], 0),
       ISNULL(MTX.[ClientCurBal], 0),
       ISNULL(MTX.[ClientDepBal], 0),
       ISNULL(MTX.[DebtBalFwd], 0),
       ISNULL(MTX.[OutlayBalFwd], 0),
       ISNULL(MTX.[ClientBalFwd], 0),
       ISNULL(MTX.[ClientCurBalFwd], 0),
       ISNULL(MTX.[ClientDepBalFwd], 0),
       ISNULL(MTX.[PendingBal], 0),
       ISNULL(MTX.[ClientMin], 0),
       MTX.[FileNum],
       RTRIM(MTX.[ThirdPart]),
       RTRIM(MTX.[ThPartSol]),
       ISNULL(MTX.[Value], 0),
       MTX.[Undertaking],
       MTX.[LastAct],
       RTRIM(MTX.[LastActType]),
       RTRIM(MTX.[LastActWho]),
       MTX.[StatuteLimits],
       RTRIM(MTX.[Status]),
       MTX.[Section68],
       MTX.[FNL_Date],
       RTRIM(MTX.[FNL_Name]),
       RTRIM(MTX.[FNL_Address]),
       ISNULL(MTX.[FNL_Fees], 0),
       ISNULL(MTX.[FNL_Outlay], 0),
       ISNULL(MTX.[FNL_VAT], 0),
       ISNULL(MTX.[FNL_Total], 0),
       RTRIM(MTX.[OldRef]),
       RTRIM(MTX.[PCODE]),
       RTRIM(MTX.[PFECODE]),
       RTRIM(MTX.[User1]),
       RTRIM(MTX.[User2]),
       RTRIM(MTX.[User3]),
       RTRIM(MTX.[DepositName]),
       MTX.[DepositType],
       ISNULL(MTX.[TimeBal], 0),
       ISNULL(MTX.[ChargeBal], 0),
       RTRIM(MTX.[YourRef]),
       ISNULL(MTX.[CurDebtBal], 0),
       ISNULL(MTX.[CurOutlayBal], 0),
       ISNULL(MTX.[CurClientBal], 0),
       ISNULL(MTX.[CurClientCBal], 0),
       ISNULL(MTX.[CurClientDBal], 0),
       ISNULL(MTX.[CurDebtBalFwd], 0),
       ISNULL(MTX.[CurOutlayBalFwd], 0),
       ISNULL(MTX.[CurClientBalFwd], 0),
       ISNULL(MTX.[CurClientCBalFwd], 0),
       ISNULL(MTX.[CurClientDBalFwd], 0),
       ISNULL(MTX.[CurPendingBal], 0),
       ISNULL(MTX.[Unallocated], 0),
       MTX.[Statements],
       MTX.[ChargeLevel],
       MTX.[FileColour],
       MTX.[OpenInvoiceNo],
       RTRIM(MTX.[Password]),
       MTX.[CompBillOnOff],
       MTX.[CompFrequency],
       ISNULL(MTX.[CompOutlayLimit], 0),
       ISNULL(MTX.[CompFeesLimit], 0),
       ISNULL(MTX.[CompTotalLimit], 0),
       RTRIM(MTX.[CompBillingMatter]),
       MTX.[CompBilling],
       RTRIM(MTX.[ClientName]),
       RTRIM(MTX.[ClientAddress]),
       RTRIM(MTX.[ClientSalutation]),
       MTX.[ChargeArrangement],
       MTX.[Importance],
       ISNULL(MTX.[OriginalDebt], 0),
       ISNULL(MTX.[DebtCollected], 0),
       ISNULL(MTX.[RecoverableCosts], 0),
       ISNULL(MTX.[DebtInterest], 0),
       MTX.[BillingMethod],
       ISNULL(MTX.[CollectingBalance], 0),
       MTX.[Publish],
       ISNULL(MTX.[Permissions], 0),
       MTX.[ChargeOutRateInd]
  FROM [dbo].[FIXMAT] MTX'

    EXEC (@COMMAND)

    --SAM3 - Column is named "OUTFileNo"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'OUTFileNo'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[OUTFileNo] = MTX.[OUTFileNo]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "OrgClosedDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'OrgClosedDate'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[OrgClosedDate] = MTX.[OrgClosedDate]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "ReOpenedDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ReOpenedDate'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[ReOpenedDate] = MTX.[ReOpenedDate]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --New SAM3 - Column is named "FixedFee"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'FixedFee'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[FixedFee] = ISNULL(MTX.[FixedFee], ''N'')
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --New SAM3 - Column is named "ShowCommentInAlarm"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ShowCommentInAlarm'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[ShowCommentInAlarm] = ISNULL(MTX.[ShowCommentInAlarm], ''N'')
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --New SAM3 - Column is named "OtherRef"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'OtherRef'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[OtherRef] = MTX.[OtherRef]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --New SAM3 and SAM4 - Column is named "Location"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Location'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[Location] = MTX.[Location]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --New SAM3 and SAM4 - Column is named "DestroyDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'DestroyDate'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[DestroyDate] = MTX.[DestroyDate]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --New SAM3 and SAM4 - Column is named "Closed"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Closed'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[Closed] = CASE WHEN ISNULL(MTX.[Closed], ''N'') = ''Y'' THEN ''Y'' ELSE ''N'' END
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Conflict - Name is CloseDate
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CloseDate'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[CloseDate] = MTX.[CloseDate]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Conflict - Name is ClosingDate
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ClosingDate'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[ClosingDate] = MTX.[ClosingDate]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END


    --SAM4 - Name is DepositAC1
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'DepositAC1'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[DepositAC1] = MTX.[DepositAC1]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is DepositAC2
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'DepositAC2'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[DepositAC2] = MTX.[DepositAC2]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is DepositAC3
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'DepositAC3'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[DepositAC3] = MTX.[DepositAC3]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is ArchiveDate
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ArchiveDate'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[ArchiveDate] = MTX.[ArchiveDate]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is ArchiveLocation
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ArchiveLocation'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[ArchiveLocation] = MTX.[ArchiveLocation]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is SetupYear
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'SetupYear'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[SetupYear] = MTX.[SetupYear]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is SetupPeriod
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'SetupPeriod'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[SetupPeriod] = MTX.[SetupPeriod]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is OldNew
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'OldNew'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[OldNew] = MTX.[OldNew]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is ClientBankAc
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ClientBankAc'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[ClientBankAc] = MTX.[ClientBankAc]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is OfficeBankAc
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'OfficeBankAc'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[OfficeBankAc] = MTX.[OfficeBankAc]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is FileManagerFileNumber
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'FileManagerFileNumber'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[FileManagerFileNumber] = MTX.[FileManagerFileNumber]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is ItemCode
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ItemCode'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[ItemCode] = MTX.[ItemCode]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is BoxNumber
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BoxNumber'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[BoxNumber] = MTX.[BoxNumber]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is BillingFE
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BillingFE'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[BillingFE] = MTX.[BillingFE]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Name is EstFeeIndicator
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'EstFeeIndicator'
        WHERE SO.[name] = 'FIXMAT'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE MAT
     SET MAT.[EstFeeIndicator] = MTX.[EstFeeIndicator]
    FROM [dbo].[matters] MAT
         INNER JOIN [dbo].[FIXMAT] MTX
                 ON MTX.[CODE] = MAT.[CODE]'

        EXEC (@COMMAND)
      END

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [CompBillingMatters]
      ON [dbo].[matters]
        ([CompBillingMatter] ASC,
         [Code] ASC)
         INCLUDE([Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyBranch]
      ON [dbo].[matters]
        ([Branch] ASC,
         [Code] ASC)
         INCLUDE([Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyClientMatter]
      ON [dbo].[matters]
        ([ClientCode] ASC,
         [Code] ASC)
         INCLUDE([Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyDept]
      ON [dbo].[matters]
        ([Dept] ASC,
         [Code] ASC)
         INCLUDE([Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyFee]
      ON [dbo].[matters]
        ([FECode] ASC,
         [Code] ASC)
         INCLUDE([Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyFePCode]
      ON [dbo].[matters]
        ([PFECode] ASC,
         [Code] ASC)
         INCLUDE([Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyFileColor]
      ON [dbo].[matters]
        ([FileColour] ASC,
         [Code] ASC)
         INCLUDE([Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyFileNumber]
      ON [dbo].[matters]
        ([FileNum] ASC,
         [Code] ASC)
         INCLUDE([Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyMatterInprogress]
      ON [dbo].[matters]
        ([PCODE] ASC)
         INCLUDE([Code],
                 [Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyOldMatter]
      ON [dbo].[matters]
        ([OldRef] ASC)
         INCLUDE([Code],
                 [Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyUser1]
      ON [dbo].[matters]
        ([User1] ASC)
         INCLUDE([Code],
                 [Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyUser2]
      ON [dbo].[matters]
        ([User2] ASC)
         INCLUDE([Code],
                 [Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyUser3]
      ON [dbo].[matters]
        ([User3] ASC)
         INCLUDE([Code],
                 [Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyWorkType]
      ON [dbo].[matters]
        ([WType] ASC,
         [Code] ASC)
         INCLUDE([Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KYNET_index_Matters_On_Code_Permissions_ClientCode]
      ON [dbo].[matters]
        ([Code] ASC,
         [Permissions] ASC,
         [ClientCode] ASC)
         INCLUDE([Description],
                 [Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyCode]
      ON [dbo].[matters]
        ([Code] ASC)
         INCLUDE([Description],
                 [Closed],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyClosed]
      ON [dbo].[matters]
        ([Closed] ASC,
         [Code] ASC)
         INCLUDE([Description],
                 [CloseDate])
      ON [PRIMARY]'

      EXEC (@COMMAND)

      IF EXISTS
        (SELECT TOP 1 1 FROM [dbo].[matters])
        BEGIN
          SET @COMMAND = 'DROP TABLE [dbo].[FIXMAT]'

          EXEC (@COMMAND)
        END
      ELSE
        BEGIN
          IF NOT EXISTS
            (SELECT TOP 1 1 FROM [dbo].[FIXMAT])
            BEGIN
              SET @COMMAND = 'DROP TABLE [dbo].[FIXMAT]'

              EXEC (@COMMAND)
            END
        END
  END
GO

--Before doing anything, fix the Undertakings table so we can be certain that the DISCHARGEDATE is a DATETIME and STATUS is an INT
IF EXISTS
  (select SC.*
     from SYS.[objects] SO
          INNER JOIN SYS.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                 AND SC.[name] = 'DISCHARGEDATE'
                 AND SC.[system_type_id] <> 61
    where SO.[name] = 'Undertakings'
      and SO.[type] = 'U')
  BEGIN
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'ALTER TABLE [dbo].[Undertakings] ADD [DCD] DATETIME NULL'

    EXEC (@COMMAND)

    SET @COMMAND = 'UPDATE [dbo].[Undertakings] 
   SET [DCD] = CASE WHEN ISNULL([DISCHARGEDATE], 0) = 0 THEN NULL ELSE DATEADD(DD, [DISCHARGEDATE], CONVERT(DATETIME, ''18001228'')) END,
       [DISCHARGEDATE] = NULL'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE [dbo].[Undertakings] ALTER COLUMN [DISCHARGEDATE] DATETIME NULL'

    EXEC (@COMMAND)

    SET @COMMAND = 'UPDATE [dbo].[Undertakings] SET [DISCHARGEDATE] = [DCD], [DCD] = NULL'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE [dbo].[Undertakings] DROP COLUMN [DCD]'

    EXEC (@COMMAND)

  END
GO

IF EXISTS
  (select SC.*
     from SYS.[objects] SO
          INNER JOIN SYS.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                 AND SC.[name] = 'STATUS'
                 AND SC.[system_type_id] = 56
    where SO.[name] = 'Undertakings'
      and SO.[type] = 'U')
  BEGIN
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'IF EXISTS
  (SELECT *
     FROM [dbo].[Undertakings] UND
          LEFT OUTER JOIN [dbo].[UndertakingStatus] UNS
                       ON UNS.[RECORDID] = UND.[Status]
    WHERE ISNULL(UND.[Status], 0) <> 0
      AND UNS.[RECORDID] IS NULL)
  BEGIN
    SET IDENTITY_INSERT [dbo].[UndertakingStatus] ON
    
    INSERT
      INTO [dbo].[UndertakingStatus]
          ([RECORDID],
           [STATUSDESC])
    SELECT DISTINCT 
           UND.[Status],
           ''Unknown Status:'' + CONVERT(VARCHAR(10), UND.[Status])
      FROM [dbo].[Undertakings] UND
           LEFT OUTER JOIN [dbo].[UndertakingStatus] UNS
                        ON UNS.[RECORDID] = UND.[Status]
     WHERE ISNULL(UND.[Status], 0) <> 0
       AND UNS.[RECORDID] IS NULL
   
    SET IDENTITY_INSERT [dbo].[UndertakingStatus] OFF
    
    DECLARE @maxVal INT
    SELECT @maxVal = ISNULL(max(RECORDID),0)+1 from [dbo].[UndertakingStatus]
    DBCC CHECKIDENT(''UndertakingStatus'', RESEED, @maxVal)
  END'

    EXEC (@COMMAND)

  END
GO

IF EXISTS
  (select SC.*
     from SYS.[objects] SO
          INNER JOIN SYS.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                 AND SC.[name] = 'STATUS'
                 AND SC.[system_type_id] <> 56
    where SO.[name] = 'Undertakings'
      and SO.[type] = 'U')
  BEGIN
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'ALTER TABLE [dbo].[Undertakings] ADD [DCS] INT NULL'

    EXEC (@COMMAND)

    SET @COMMAND = 'UPDATE UND
   SET UND.[DCS] = UNS.[RecordID],
       UND.[Status] = NULL
  FROM [dbo].[Undertakings] UND
       LEFT OUTER JOIN [dbo].[UndertakingStatus] UNS
                    ON UNS.[StatusDesc] = UND.[Status]'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE [dbo].[Undertakings] ALTER COLUMN [STATUS] INT NULL'

    EXEC (@COMMAND)

    SET @COMMAND = 'UPDATE [dbo].[Undertakings] SET [STATUS] = [DCS], [DCS] = NULL'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE [dbo].[Undertakings] DROP COLUMN [DCS]'

    EXEC (@COMMAND)
  END
GO

IF EXISTS
  (SELECT *
      FROM SYS.[objects] SO
          INNER JOIN SYS.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                  AND SC.[name] = 'DECMIAL'
                  AND SC.[is_nullable] = 1
    WHERE SO.[name] = 'SystemUserDefinedFields'
      AND SO.[type] = 'U')
  BEGIN
    SELECT * INTO [dbo].[SUDFFIX] FROM [dbo].[SystemUserDefinedFields] 
        
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'DROP TABLE [dbo].[SystemUserDefinedFields]'

    EXEC (@COMMAND)
                
    SET @COMMAND = 'CREATE TABLE
       [dbo].[SystemUserDefinedFields]
      ([FILEPREFIX]               [varchar](5)                                                                  NOT NULL,
       [FIELDNAME]                [varchar](30)                                                                 NOT NULL,
       [TYPE]                     [varchar](11)    CONSTRAINT [DF_SystemUserDefinedFields_TYPE] DEFAULT ''''      NOT NULL,
       [PROMPT]                   [varchar](80)    CONSTRAINT [DF_SystemUserDefinedFields_PROMPT] DEFAULT ''''    NOT NULL,
       [LENGTH]                   [decimal](5, 0)  CONSTRAINT [DF_SystemUserDefinedFields_LENGTH] DEFAULT 0     NOT NULL,
       [DECMIAL]                  [decimal](3, 0)  CONSTRAINT [DF_SystemUserDefinedFields_DECMIAL] DEFAULT 0    NOT NULL,
       [FORMAT]                   [varchar](10)    CONSTRAINT [DF_SystemUserDefinedFields_FORMAT] DEFAULT ''''    NOT NULL,
       [INITIALVALUE]             [varchar](255)   CONSTRAINT [DF_SystemUserDefinedFields_INI] DEFAULT ''''       NOT NULL,
       [CALCINITIALVALUE]         [char](1)        CONSTRAINT [DF_SystemUserDefinedFields_CINI] DEFAULT ''N''     NOT NULL,
       [OVERRIDEINITIALVALUE]     [char](1)        CONSTRAINT [DF_SystemUserDefinedFields_OINI] DEFAULT ''N''     NOT NULL,
       [REQUIRED]                 [char](1)        CONSTRAINT [DF_SystemUserDefinedFields_REQD] DEFAULT ''N''     NOT NULL,
       [VALIDATION]               [char](1)        CONSTRAINT [DF_SystemUserDefinedFields_VALD] DEFAULT ''N''     NOT NULL,
       [LOW]                      [decimal](9, 2)  CONSTRAINT [DF_SystemUserDefinedFields_LOW] DEFAULT 0        NOT NULL,
       [HIGH]                     [decimal](9, 2)  CONSTRAINT [DF_SystemUserDefinedFields_HIGH] DEFAULT 0       NOT NULL,
       [SYSTEMFIELD]              [char](1)        CONSTRAINT [DF_SystemUserDefinedFields_SYS] DEFAULT ''N''      NOT NULL,
       [TOP]                      [decimal](5, 0)  CONSTRAINT [DF_SystemUserDefinedFields_TOP] DEFAULT 0        NOT NULL,
       [LEFT]                     [decimal](5, 2)  CONSTRAINT [DF_SystemUserDefinedFields_LEFT] DEFAULT 0       NOT NULL,
       [HEIGHT]                   [decimal](5, 0)  CONSTRAINT [DF_SystemUserDefinedFields_HEIGHT] DEFAULT 0     NOT NULL,
       [WIDTH]                    [decimal](5, 2)  CONSTRAINT [DF_SystemUserDefinedFields_WIDTH] DEFAULT 0      NOT NULL,
       [FONT]                     [varchar](20)    CONSTRAINT [DF_SystemUserDefinedFields_FONT] DEFAULT ''''      NOT NULL,
       [VISIBLE]                  [char](1)        CONSTRAINT [DF_SystemUserDefinedFields_VISIBLE] DEFAULT ''Y''  NOT NULL,
       [ENABLED]                  [char](1)        CONSTRAINT [DF_SystemUserDefinedFields_ENABLED] DEFAULT ''Y''  NOT NULL,
       [READONLY]                 [char](1)        CONSTRAINT [DF_SystemUserDefinedFields_READONLY] DEFAULT ''N'' NOT NULL,
       [MULTILINE]                [char](1)        CONSTRAINT [DF_SystemUserDefinedFields_MULTILIN] DEFAULT ''N'' NOT NULL,
       [ACTUALNAME]               [varchar](200)   CONSTRAINT [DF_SystemUserDefinedFields_ACTUAL] DEFAULT ''''    NOT NULL,
       [COMMON]                   [tinyint]        CONSTRAINT [DF_SystemUserDefinedFields_COMMON] DEFAULT 0     NOT NULL,
       [UDFCategory]              [int]                                                                             NULL,
       [ISLOCK]                   [tinyint]        CONSTRAINT [DF_SystemUserDefinedFields_ISLOCK] DEFAULT 0     NOT NULL,
       CONSTRAINT [PK_SystemUserDefinedFields]
                  PRIMARY KEY CLUSTERED 
                 ([FILEPREFIX] ASC,
                  [FIELDNAME]  ASC)
               ON [PRIMARY])
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = '    INSERT
      INTO [dbo].[SystemUserDefinedFields]
          ([FILEPREFIX],
           [FIELDNAME],
           [TYPE],
           [PROMPT],
           [LENGTH],
           [DECMIAL],
           [FORMAT],
           [INITIALVALUE],
           [CALCINITIALVALUE],
           [OVERRIDEINITIALVALUE],
           [REQUIRED],
           [VALIDATION],
           [LOW],
           [HIGH],
           [SYSTEMFIELD],
           [TOP],
           [LEFT],
           [HEIGHT],
           [WIDTH],
           [FONT],
           [VISIBLE],
           [ENABLED],
           [READONLY],
           [MULTILINE],
           [ACTUALNAME],
           [COMMON])
    SELECT RTRIM(ISNULL(SUF.[FILEPREFIX], '''')),
           RTRIM(ISNULL(SUF.[FIELDNAME], '''')),
           RTRIM(ISNULL(SUF.[TYPE], '''')),
           RTRIM(ISNULL(SUF.[PROMPT], '''')),
           ISNULL(SUF.[LENGTH], 0),
           ISNULL(SUF.[DECMIAL], 0),
           RTRIM(ISNULL(SUF.[FORMAT], '''')),
           RTRIM(ISNULL(SUF.[INITIALVALUE], '''')),
           RTRIM(ISNULL(SUF.[CALCINITIALVALUE], ''N'')),
           RTRIM(ISNULL(SUF.[OVERRIDEINITIALVALUE], ''N'')),
           RTRIM(ISNULL(SUF.[REQUIRED], ''N'')),
           RTRIM(ISNULL(SUF.[VALIDATION], ''N'')),
           ISNULL(SUF.[LOW], 0),
           ISNULL(SUF.[HIGH], 0),
           RTRIM(ISNULL(SUF.[SYSTEMFIELD], ''N'')),
           ISNULL(SUF.[TOP], 0),
           ISNULL(SUF.[LEFT], 0),
           ISNULL(SUF.[HEIGHT], 0),
           ISNULL(SUF.[WIDTH], 0),
           RTRIM(ISNULL(SUF.[FONT], '''')),
           RTRIM(ISNULL(SUF.[VISIBLE], ''Y'')),
           RTRIM(ISNULL(SUF.[ENABLED], ''Y'')),
           RTRIM(ISNULL(SUF.[READONLY], ''N'')),
           RTRIM(ISNULL(SUF.[MULTILINE], ''N'')),
           RTRIM(ISNULL(SUF.[ACTUALNAME], '''')),
           ISNULL(SUF.[COMMON], 0)
      FROM [dbo].[SUDFFIX] SUF'

    EXEC (@COMMAND)

    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN sys.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'UDFCategory'
        WHERE SO.[name] = 'SUDFFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = 'UPDATE SUF
           SET SUF.[UDFCategory] = SUFX.[UDFCategory]
          FROM [dbo].[SystemUserDefinedFields] SUF
               INNER JOIN [dbo].[SUDFFIX] SUFX
                       ON SUFX.[FILEPREFIX] = SUF.[FILEPREFIX]
                      AND SUFX.[FIELDNAME] = SUF.[FIELDNAME]'
        
        EXEC (@COMMAND)
      END

    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN sys.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ISLOCK'
        WHERE SO.[name] = 'SUDFFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = 'UPDATE SUF
           SET SUF.[ISLOCK] = ISNULL(SUFX.[ISLOCK], 0)
          FROM [dbo].[SystemUserDefinedFields] SUF
               INNER JOIN [dbo].[SUDFFIX] SUFX
                       ON SUFX.[FILEPREFIX] = SUF.[FILEPREFIX]
                      AND SUFX.[FIELDNAME] = SUF.[FIELDNAME]'
        
        EXEC (@COMMAND)
      END

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX 
       [KeyActual]
    ON [dbo].[SystemUserDefinedFields]
      ([ACTUALNAME] ASC)
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX 
       [KeyFieldName]
    ON [dbo].[SystemUserDefinedFields]
      ([FIELDNAME] ASC)
    ON [PRIMARY]'

    EXEC (@COMMAND)

    IF EXISTS
      (SELECT TOP 1 1 FROM [dbo].[SystemUserDefinedFields])
      BEGIN
        SET @COMMAND = 'DROP TABLE [dbo].[SUDFFIX]'

        EXEC (@COMMAND)
      END
    ELSE
      BEGIN
        IF NOT EXISTS
          (SELECT TOP 1 1 FROM [dbo].[SUDFFIX])
          BEGIN
            SET @COMMAND = 'DROP TABLE [dbo].[SUDFFIX]'

            EXEC (@COMMAND)
          END
      END

  END
GO

IF EXISTS
  (SELECT SC.*
     FROM SYS.[objects] SO
          INNER JOIN SYS.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                 AND SC.[name] = 'DATEAPPOINTED'
                 AND SC.[system_type_id] <> 61
    WHERE SO.[name] = 'Officers'
      AND SO.[type] = 'U')
BEGIN
  ALTER TABLE [dbo].[Officers] ALTER COLUMN [DATEAPPOINTED] DATETIME NULL
END
GO

IF EXISTS
  (SELECT SC.*
     FROM SYS.[objects] SO
          INNER JOIN SYS.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                 AND SC.[name] = 'DATERESIGNED'
                 AND SC.[system_type_id] <> 61
    WHERE SO.[name] = 'Officers'
      AND SO.[type] = 'U')
BEGIN
  ALTER TABLE [dbo].[Officers] ALTER COLUMN [DATERESIGNED] DATETIME NULL
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'Officers'
      AND SO.[type] = 'U')
BEGIN
  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
            INNER JOIN SYS.[indexes] SI
                    ON SI.[object_id] = SO.[object_id]
                   AND SI.[name] = 'PK_Officers'
      WHERE SO.[name] = 'Officers'
        AND SO.[type] = 'U')
    BEGIN
      SELECT * INTO [dbo].[OFCFIX] FROM [dbo].[Officers] 
        
      DECLARE @COMMAND VARCHAR(MAX)

      SET @COMMAND = 'DROP TABLE [dbo].[Officers]'

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE TABLE 
       [dbo].[Officers]
      ([CONTACTCODE]          [varchar](8)                       NOT NULL,
	     [CONTACTOFFICER]       [varchar](8)                           NULL,
	     [NAME]                 [varchar](30)                          NULL,
	     [COSECRETARY]          [char](1)                              NULL,
	     [DATEAPPOINTED]        [datetime]                             NULL,
	     [DATERESIGNED]         [datetime]                             NULL,
	     [RECORDID]             [int]            IDENTITY(1,1)     NOT NULL,
       CONSTRAINT [PK_Officers]
                  PRIMARY KEY CLUSTERED 
                 ([RECORDID] ASC)
               ON [PRIMARY])
    ON [PRIMARY]'                

      EXEC (@COMMAND)

      SET @COMMAND = '  SET IDENTITY_INSERT [dbo].[Officers] ON

  INSERT
    INTO [dbo].[Officers]
        ([CONTACTCODE],
         [CONTACTOFFICER],
         [NAME],
         [COSECRETARY],
         [DATEAPPOINTED],
         [DATERESIGNED],
         [RECORDID])
  SELECT RTRIM(ISNULL(OFX.[CONTACTCODE], '''')),
         RTRIM(OFX.[CONTACTOFFICER]),
         RTRIM(OFX.[NAME]),
         OFX.[COSECRETARY],
         OFX.[DATEAPPOINTED],
         OFX.[DATERESIGNED],
         OFX.[RECORDID]
    FROM [dbo].[OFCFIX] OFX
    
  SET IDENTITY_INSERT [dbo].[Officers] OFF

  DECLARE @maxVal INT
  SELECT @maxVal = ISNULL(max(RECORDID),0)+1 from [dbo].[Officers]
  DBCC CHECKIDENT(''Officers'', RESEED, @maxVal)'

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE NONCLUSTERED INDEX 
       [KeyContactCode]
    ON [dbo].[Officers]
      ([CONTACTCODE] ASC,
	     [RECORDID]    ASC)
    ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [KeyOfficer]
    ON [dbo].[Officers]
      ([CONTACTOFFICER] ASC)
    ON [PRIMARY]'

      EXEC (@COMMAND)

    IF EXISTS
      (SELECT TOP 1 1 FROM [dbo].[Officers])
      BEGIN
        SET @COMMAND = 'DROP TABLE [dbo].[OFCFIX]'

        EXEC (@COMMAND)
      END
    ELSE
      BEGIN
        IF NOT EXISTS
          (SELECT TOP 1 1 FROM [dbo].[OFCFIX])
          BEGIN
            SET @COMMAND = 'DROP TABLE [dbo].[OFCFIX]'

            EXEC (@COMMAND)
          END
      END


    END
END
GO

UPDATE [dbo].[TimeDayBook] SET [TIMEORCHARGE] = 'T' WHERE RTRIM(ISNULL([TIMEORCHARGE], '')) NOT IN ('T', 'B', 'C')
GO

IF EXISTS
  (SELECT *
     FROM [dbo].[TimeDayBook] TDB
    WHERE TDB.[MATTER] IS NULL)
BEGIN
  DELETE TDB FROM [dbo].[TimeDayBook] TDB WHERE TDB.[MATTER] IS NULL
END
GO

UPDATE [dbo].[TimeDayBook]
   SET [REC_IRR] = 'C'
 WHERE [REC_IRR] IN ('R', 'T')
GO

UPDATE [dbo].[TimeDayBook]
   SET [REC_IRR] = 'N'
 WHERE [REC_IRR] = 'I'
GO

UPDATE [dbo].[TimeDayBook]
   SET [REC_IRR] = ''
 WHERE [REC_IRR] = ' '
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'TimeDayBook'
      AND SO.[type] = 'U')
IF NOT EXISTS
  (SELECT *
     FROM SYS.[objects] SO
          INNER JOIN SYS.[columns] SCC
                  ON SCC.[object_id] = SO.[object_id]
                 AND SCC.[name] = 'Charge'
          INNER JOIN SYS.[columns] SCCd
                  ON SCCd.[object_id] = SO.[object_id]
                 AND SCCd.[name] = 'Charged'
    WHERE SO.[name] = 'TimeDayBook'
      AND SO.[type] = 'U')
  BEGIN
    -- the FIXED TimeDayBook table will contain both a "CHARGE" and a "CHARGED" Column.
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = ''TDBFIX''
      AND SO.[type] = ''U'')
BEGIN
  DROP TABLE [dbo].[TDBFIX]
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'SELECT *
  INTO [dbo].[TDBFIX]
  FROM [dbo].[TimeDayBook]'

    EXEC (@COMMAND)

    SET @COMMAND = 'IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = ''TimeDayBook''
      AND SO.[type] = ''U'')
BEGIN
  DROP TABLE [dbo].[TimeDayBook]
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TABLE
       [dbo].[TimeDayBook]
      ([RecordID]                        INT             IDENTITY(1, 1)                                                                       NOT NULL,
       [Matter]                          VARCHAR(20)                                                                                          NOT NULL,
       [FeeEarn]                         VARCHAR(10)                                                                                          NOT NULL,
       [Date]                            DATETIME                                                                                             NOT NULL,
       [Time]                            INT             CONSTRAINT [DF_TimeDayBook_Time] DEFAULT 0                                           NOT NULL,
       [Rate]                            DECIMAL(10, 2)  CONSTRAINT [DF_TimeDayBook_Rate] DEFAULT 0                                           NOT NULL,
       [Charge]                          DECIMAL(10, 2)  CONSTRAINT [DF_TimeDayBook_Charge] DEFAULT 0                                         NOT NULL,
       [Charged]                         DECIMAL(10, 2)  CONSTRAINT [DF_TimeDayBook_Charged] DEFAULT 0                                        NOT NULL,
       [Units]                           DECIMAL(11, 2)  CONSTRAINT [DF_TimeDayBook_Units] DEFAULT 0                                          NOT NULL,
       [Task]                            VARCHAR(6)      CONSTRAINT [DF_TimeDayBook_Task] DEFAULT ''''                                          NOT NULL,
       [TimeOrCharge]                    VARCHAR(1)      CONSTRAINT [CS_TimeDayBook_TOC] CHECK ([TimeOrCharge] IN (''B'', ''C'', ''T''))            NOT NULL,
       [StartTime]                       INT             CONSTRAINT [DF_TimeDayBook_StartTime] DEFAULT 0                                      NOT NULL,
       [Comment]                         VARCHAR(1000)                                                                                            NULL,
       [NCCCode]                         VARCHAR(10)                                                                                              NULL,
       [Docket]                          INT             CONSTRAINT [DF_TimeDayBook_Docket] DEFAULT 0                                         NOT NULL,
       [Team]                            VARCHAR(10)                                                                                              NULL,
       [TrackRef]                        INT             CONSTRAINT [DF_TimeDayBook_TrackRef] DEFAULT 0                                       NOT NULL,
       [Rec_Irr]                         VARCHAR(1)      CONSTRAINT [CS_TimeDayBook_RECIRR] CHECK ([Rec_Irr] IN ('''', ''C'', ''N'', ''T'', ''Y''))     NOT NULL,
       [Period]                          INT                                                                                                      NULL,
       [Year]                            INT                                                                                                      NULL,
       [ActionID]                        INT                                                                                                      NULL,
       [StageCode]                       VARCHAR(3)                                                                                               NULL,
       [Leave]                           VARCHAR(1)                                                                                               NULL,
       [Post]                            CHAR(1)                                                                                                  NULL,
       [StopwatchStartTime]              DATETIME                                                                                                 NULL,
       [StopwatchStatus]                 INT                                                                                                      NULL,
       [MatterLevel]                     CHAR(1)                                                                                                  NULL,
       [FEERate]                         DECIMAL(10, 2)                                                                                           NULL,
       [ChargedMins]                     INT                                                                                                      NULL,
       [FEECost]                         DECIMAL(12, 2)                                                                                           NULL,
       [TaskLevel]                       CHAR(1)                                                                                                  NULL,
       [EntryDate]                       DATETIME                                                                                                 NULL,
       [ModifyDate]                      DATETIME                                                                                                 NULL,
       CONSTRAINT [PK_TimeDayBook] 
                  PRIMARY KEY CLUSTERED 
                 ([RECORDID] ASC))'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRTimeDayBookInsert]
    ON [dbo].[TimeDayBook]
       AFTER INSERT
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      DECLARE @CHARGE DECIMAL(10, 2)

      UPDATE TDB
         SET TDB.[Charge] = CASE WHEN ISNULL(TDB.[Charge], 0) <> 0
                                      THEN ISNULL(TDB.[Charge], 0)
                                 ELSE ISNULL(TDB.[Charged], 0) END,
             TDB.[Charged] = CASE WHEN ISNULL(TDB.[Charge], 0) <> 0
                                      THEN ISNULL(TDB.[Charge], 0)
                                 ELSE ISNULL(TDB.[Charged], 0) END
        FROM inserted INS
             INNER JOIN [dbo].[TimeDayBook] TDB
                     ON TDB.[RecordID] = INS.[RecordID]
       WHERE ISNULL(INS.[Charge], 0) <> ISNULL(INS.[Charged], 0)

    END
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRTimeDayBookUpdate]
    ON [dbo].[TimeDayBook]
       AFTER Update
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE TDB
         SET TDB.[Charge] = CASE WHEN ISNULL(INS.[Charged], 0) <> ISNULL(DEL.[Charged], 0) 
                                      THEN ISNULL(INS.[Charged], 0)
                                 ELSE ISNULL(INS.[Charge], 0) END,
             TDB.[Charged] = CASE WHEN ISNULL(INS.[Charge], 0) <> ISNULL(DEL.[Charge], 0) 
                                      THEN ISNULL(INS.[Charge], 0)
                                  ELSE ISNULL(INS.[Charged], 0) END
        FROM inserted INS
             INNER JOIN deleted DEL
                     ON DEL.[RecordID] = INS.[RecordID]
             INNER JOIN [dbo].[TimeDayBook] TDB
                     ON TDB.[RecordID] = INS.[RecordID]
       WHERE ISNULL(INS.[Charge], 0) <> ISNULL(DEL.[Charge], 0)
          OR ISNULL(INS.[Charged], 0) <> ISNULL(DEL.[Charged], 0)
    END
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'SET IDENTITY_INSERT [dbo].[TimeDayBook] ON

INSERT
  INTO [dbo].[TimeDayBook]
      ([RecordID],
       [Matter],
       [FeeEarn],
       [Date],
       [Time],
       [Rate],
       [Task],
       [TimeOrCharge],
       [StartTime],
       [Comment],
       [NCCCode],
       [Docket],
       [Team],
       [TrackRef],
       [Rec_Irr],
       [Period],
       [Year],
       [ActionID],
       [StageCode],
       [Leave],
       [Post],
       [StopwatchStartTime],
       [StopwatchStatus])
SELECT TDBX.[RecordID],
       RTRIM(ISNULL(TDBX.[Matter], '''')),
       RTRIM(ISNULL(TDBX.[FeeEarn], '''')),
       ISNULL(TDBX.[Date], ISNULL(MAT.[Started], ''19000101'')),
       ISNULL(TDBX.[Time], 0),
       ISNULL(TDBX.[Rate], 0),
       RTRIM(ISNULL(TDBX.[Task], '''')),
       RTRIM(ISNULL(TDBX.[TimeOrCharge], ''T'')),
       ISNULL(TDBX.[StartTime], 0),
       RTRIM(TDBX.[Comment]),
       TDBX.[NCCCode],
       CASE WHEN ISNULL(TDBX.[Docket], '''') = '''' THEN 0 ELSE CONVERT(INT, TDBX.[Docket]) END,
       TDBX.[Team],
       ISNULL(TDBX.[TrackRef], 0),
       RTRIM(ISNULL(TDBX.[Rec_Irr], '''')),
       TDBX.[Period],
       TDBX.[Year],
       TDBX.[ActionID],
       TDBX.[StageCode],
       TDBX.[Leave],
       TDBX.[Post],
       TDBX.[StopwatchStartTime],
       TDBX.[StopwatchStatus]
  FROM [dbo].[TDBFIX] TDBX
       LEFT OUTER JOIN [dbo].[matters] MAT 
                    ON MAT.[Code] = TDBX.[Matter]

SET IDENTITY_INSERT [dbo].[TimeDayBook] OFF

DECLARE @maxVal INT
SELECT @maxVal = ISNULL(max(RECORDID),0)+1 from [dbo].[TimeDayBook]
DBCC CHECKIDENT(''TimeDayBook'', RESEED, @maxVal)'

    EXEC (@COMMAND)

    --SAM3 - Column is named "CHARGE"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CHARGE'
        WHERE SO.[name] = 'TDBFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TDB
     SET TDB.[Charge] = ISNULL(TDBX.[Charge], 0)
    FROM [dbo].[TimeDayBook] TDB
         INNER JOIN [dbo].[TDBFIX] TDBX
                 ON TDBX.[RecordId] = TDB.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "CHARGED"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CHARGED'
        WHERE SO.[name] = 'TDBFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TDB
     SET TDB.[Charge] = ISNULL(TDBX.[Charged], 0)
    FROM [dbo].[TimeDayBook] TDB
         INNER JOIN [dbo].[TDBFIX] TDBX
                 ON TDBX.[RecordId] = TDB.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM3 - DOES contain a Leave column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Leave'
        WHERE SO.[name] = 'TDBFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TDB
     SET TDB.[Leave] = TDBX.[Leave]
    FROM [dbo].[TimeDayBook] TDB
         INNER JOIN [dbo].[TDBFIX] TDBX
                 ON TDBX.[RecordId] = TDB.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a Units column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Units'
        WHERE SO.[name] = 'TDBFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TDB
     SET TDB.[Units] = ISNULL(TDBX.[Units], 0)
    FROM [dbo].[TimeDayBook] TDB
         INNER JOIN [dbo].[TDBFIX] TDBX
                 ON TDBX.[RecordId] = TDB.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a MatterLevel column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'MatterLevel'
        WHERE SO.[name] = 'TDBFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TDB
     SET TDB.[MatterLevel] = TDBX.[MatterLevel]
    FROM [dbo].[TimeDayBook] TDB
         INNER JOIN [dbo].[TDBFIX] TDBX
                 ON TDBX.[RecordId] = TDB.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a FEERate column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'FEERate'
        WHERE SO.[name] = 'TDBFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TDB
     SET TDB.[FEERate] = TDBX.[FEERate]
    FROM [dbo].[TimeDayBook] TDB
         INNER JOIN [dbo].[TDBFIX] TDBX
                 ON TDBX.[RecordId] = TDB.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a ChargedMins column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ChargedMins'
        WHERE SO.[name] = 'TDBFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TDB
     SET TDB.[ChargedMins] = TDBX.[ChargedMins]
    FROM [dbo].[TimeDayBook] TDB
         INNER JOIN [dbo].[TDBFIX] TDBX
                 ON TDBX.[RecordId] = TDB.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a FEECost column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'FEECost'
        WHERE SO.[name] = 'TDBFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TDB
     SET TDB.[FEECost] = TDBX.[FEECost]
    FROM [dbo].[TimeDayBook] TDB
         INNER JOIN [dbo].[TDBFIX] TDBX
                 ON TDBX.[RecordId] = TDB.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a TaskLevel column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'TaskLevel'
        WHERE SO.[name] = 'TDBFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TDB
     SET TDB.[TaskLevel] = TDBX.[TaskLevel]
    FROM [dbo].[TimeDayBook] TDB
         INNER JOIN [dbo].[TDBFIX] TDBX
                 ON TDBX.[RecordId] = TDB.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a EntryDate column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'EntryDate'
        WHERE SO.[name] = 'TDBFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TDB
     SET TDB.[EntryDate] = TDBX.[EntryDate]
    FROM [dbo].[TimeDayBook] TDB
         INNER JOIN [dbo].[TDBFIX] TDBX
                 ON TDBX.[RecordId] = TDB.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a ModifyDate column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ModifyDate'
        WHERE SO.[name] = 'TDBFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TDB
     SET TDB.[ModifyDate] = TDBX.[ModifyDate]
    FROM [dbo].[TimeDayBook] TDB
         INNER JOIN [dbo].[TDBFIX] TDBX
                 ON TDBX.[RecordId] = TDB.[RecordID]'

        EXEC (@COMMAND)
      END

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyFeeEarn] 
      ON [dbo].[TimeDayBook]
        ([FEEEARN]   ASC,
         [DATE]      ASC,
         [RECORDID]  ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeeMatter] 
      ON [dbo].[TimeDayBook]
        ([MATTER]    ASC,
         [DATE]      ASC,
         [RECORDID]  ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX
         [KeyTask]
      ON [dbo].[TimeDayBook]
        ([Task]     ASC,
         [RECORDID] ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX
         [KeyTeam]
      ON [dbo].[TimeDayBook]
        ([TEAM]      ASC,
         [MATTER]    ASC,
         [DATE]      ASC,
         [RECORDID]  ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX
         [KeyTrackRef]
      ON [dbo].[TimeDayBook]
        ([TRACKREF]   ASC,
         [DATE]       ASC,
         [RECORDID]  ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

    IF EXISTS
      (SELECT TOP 1 1 FROM [dbo].[TimeDayBook])
      BEGIN
        SET @COMMAND = 'DROP TABLE [dbo].[TDBFIX]'

        EXEC (@COMMAND)
      END
    ELSE
      BEGIN
        IF NOT EXISTS
          (SELECT TOP 1 1 FROM [dbo].[TDBFIX])
          BEGIN
            SET @COMMAND = 'DROP TABLE [dbo].[TDBFIX]'

            EXEC (@COMMAND)
          END
      END


  END
GO

IF NOT EXISTS
  (SELECT *
    FROM SYS.[objects] SO
         INNER JOIN SYS.[sysconstraints] SC
                    INNER JOIN sys.[objects] CO
                            ON CO.[object_id] = SC.[constid]
                           AND CO.[name] = 'DF_TimeDayBook_RECIRR'
                 ON SC.[id] = SO.[object_id]
   WHERE SO.[name] = 'TimeDayBook'
     AND SO.[type] = 'U')
  BEGIN
    ALTER TABLE [dbo].[TimeDayBook] ADD CONSTRAINT [DF_TimeDayBook_RECIRR] DEFAULT 'C' FOR [REC_IRR]
  END
GO

IF EXISTS
  (SELECT *
     FROM [dbo].[TimeEntry] TIE
    WHERE TIE.[MATTER] IS NULL)
BEGIN
  DELETE TIE FROM [dbo].[TimeEntry] TIE WHERE TIE.[MATTER] IS NULL
END
GO

UPDATE [dbo].[TimeEntry]
   SET [REC_IRR] = 'C'
 WHERE [REC_IRR] IN ('R', 'T')
GO

UPDATE [dbo].[TimeEntry]
   SET [REC_IRR] = 'N'
 WHERE [REC_IRR] = 'I'
GO

UPDATE [dbo].[TimeEntry]
   SET [REC_IRR] = ''
 WHERE [REC_IRR] = ' '
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'TimeEntry'
      AND SO.[type] = 'U')
IF NOT EXISTS
  (SELECT *
     FROM SYS.[objects] SO
          INNER JOIN SYS.[columns] SCC
                  ON SCC.[object_id] = SO.[object_id]
                 AND SCC.[name] = 'Charge'
          INNER JOIN SYS.[columns] SCCd
                  ON SCCd.[object_id] = SO.[object_id]
                 AND SCCd.[name] = 'Charged'
    WHERE SO.[name] = 'TimeEntry'
      AND SO.[type] = 'U')
  BEGIN
    -- the FIXED TimeEntry table will contain both a "CHARGE" and a "CHARGED" Column.
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = ''TIEFIX''
      AND SO.[type] = ''U'')
BEGIN
  DROP TABLE [dbo].[TIEFIX]
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'SELECT *
  INTO [dbo].[TIEFIX]
  FROM [dbo].[TimeEntry]'

    EXEC (@COMMAND)

    SET @COMMAND = 'IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = ''TimeEntry''
      AND SO.[type] = ''U'')
BEGIN
  DROP TABLE [dbo].[TimeEntry]
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TABLE
       [dbo].[TimeEntry]
      ([RecordID]                        INT             IDENTITY(1, 1)                                                                       NOT NULL,
       [Matter]                          VARCHAR(20)                                                                                          NOT NULL,
       [FeeEarn]                         VARCHAR(10)                                                                                          NOT NULL,
       [Date]                            DATETIME                                                                                             NOT NULL,
       [Time]                            INT             CONSTRAINT [DF_TimeEntry_Time] DEFAULT 0                                             NOT NULL,
       [Rate]                            DECIMAL(10, 2)  CONSTRAINT [DF_TimeEntry_Rate] DEFAULT 0                                             NOT NULL,
       [Charge]                          DECIMAL(10, 2)  CONSTRAINT [DF_TimeEntry_Charge] DEFAULT 0                                           NOT NULL,
       [Charged]                         DECIMAL(10, 2)  CONSTRAINT [DF_TimeEntry_Charged] DEFAULT 0                                          NOT NULL,
       [Units]                           DECIMAL(11, 2)  CONSTRAINT [DF_TimeEntry_Units] DEFAULT 0                                            NOT NULL,
       [Task]                            VARCHAR(6)      CONSTRAINT [DF_TimeEntry_Task] DEFAULT ''''                                            NOT NULL,
       [TimeOrCharge]                    VARCHAR(1)      CONSTRAINT [CS_TimeEntry_TOC] CHECK ([TimeOrCharge] IN (''B'', ''C'', ''T''))              NOT NULL,
       [Comment]                         VARCHAR(1000)                                                                                            NULL,
       [Billed]                          DECIMAL(13, 2)  CONSTRAINT [DF_TimeEntry_Billed] DEFAULT 0                                           NOT NULL,
       [NCCode]                          VARCHAR(10)                                                                                              NULL,
       [Docket]                          INT             CONSTRAINT [DF_TimeEntry_Docket] DEFAULT 0                                           NOT NULL,
       [Team]                            VARCHAR(10)                                                                                              NULL,
       [TrackRef]                        INT             CONSTRAINT [DF_TimeEntry_TrackRef] DEFAULT 0                                         NOT NULL,
       [Rec_Irr]                         VARCHAR(1)      CONSTRAINT [CS_TimeEntry_RECIRR] CHECK ([Rec_Irr] IN ('''', ''C'', ''N'', ''T'', ''Y''))       NOT NULL,
       [ShouldHave]                      DECIMAL(13, 2)  CONSTRAINT [DF_TimeEntry_ShouldHave] DEFAULT 0                                       NOT NULL,
       [InvoiceNo]                       INT             CONSTRAINT [DF_TimeEntry_InvoiceNo] DEFAULT 0                                        NOT NULL,
       [Period]                          INT                                                                                                      NULL,
       [Year]                            INT                                                                                                      NULL,
       [BillingPeriod]                   INT                                                                                                      NULL,
       [BillingYear]                     INT                                                                                                      NULL,
       [OpenInv]                         VARCHAR(1)                                                                                               NULL,
       [ActionID]                        INT                                                                                                      NULL,
       [StageCode]                       VARCHAR(3)                                                                                               NULL,
       [BillingDate]                     DATETIME                                                                                                 NULL,
       [BilledDate]                      DATETIME                                                                                                 NULL,
       [BilledAmount]                    DECIMAL(10, 2)  CONSTRAINT [DF_TimeEntry_BilledAmount] DEFAULT 0                                     NOT NULL,
       [AxleNumber]                      INT                                                                                                      NULL,
       [WriteOffDT]                      DATETIME                                                                                                 NULL,
       [WriteOffID]                      INT                                                                                                      NULL,
       [IncludeInBill]                   INT             CONSTRAINT [DF_TimeEntry_IncludeInBill] DEFAULT 1 
                                                         CONSTRAINT [CS_TimeEntry_IncludeInBill] CHECK ([IncludeInBill] IN (0, 1, 2))         NOT NULL,
       [Leave]                           VARCHAR(1)                                                                                               NULL,
       [MatterLevel]                     CHAR(1)                                                                                                  NULL,
       [FEERate]                         DECIMAL(7, 2)                                                                                            NULL,
       [ChargedMins]                     INT                                                                                                      NULL,
       [FEECost]                         DECIMAL(9, 2)                                                                                            NULL,
       [TaskLevel]                       CHAR(1)                                                                                                  NULL,
       [WriteOff]                        CHAR(1)                                                                                                  NULL,
       [Branch]                          VARCHAR(3)                                                                                               NULL,
       [EntryDate]                       DATETIME                                                                                                 NULL,
       [ModifyDate]                      DATETIME                                                                                                 NULL,
       CONSTRAINT [PK_TimeEntry] 
                  PRIMARY KEY CLUSTERED 
                 ([RECORDID] ASC))'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRTimeEntryInsert]
    ON [dbo].[TimeEntry]
       AFTER INSERT
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      DECLARE @CHARGE DECIMAL(10, 2)

      UPDATE TIE
         SET TIE.[Charge] = CASE WHEN ISNULL(TIE.[Charge], 0) <> 0
                                      THEN ISNULL(TIE.[Charge], 0)
                                 ELSE ISNULL(TIE.[Charged], 0) END,
             TIE.[Charged] = CASE WHEN ISNULL(TIE.[Charge], 0) <> 0
                                      THEN ISNULL(TIE.[Charge], 0)
                                 ELSE ISNULL(TIE.[Charged], 0) END,
             TIE.[BillingDate] = CASE WHEN TIE.[BillingDate] IS NULL
                                           THEN TIE.[BilledDate]
                                      WHEN TIE.[BilledDate] IS NULL
                                           THEN TIE.[BillingDate]
                                      ELSE TIE.[BillingDate] END,
             TIE.[BilledDate] = CASE WHEN TIE.[BillingDate] IS NULL
                                           THEN TIE.[BilledDate]
                                      WHEN TIE.[BilledDate] IS NULL
                                           THEN TIE.[BillingDate]
                                      ELSE TIE.[BillingDate] END
        FROM inserted INS
             INNER JOIN [dbo].[TimeEntry] TIE
                     ON TIE.[RecordID] = INS.[RecordID]
       WHERE ISNULL(INS.[Charge], 0) <> ISNULL(INS.[Charged], 0)
          OR ISNULL(INS.[BillingDate], CONVERT(DATETIME, ''19000101'')) <> ISNULL(INS.[BilledDate], CONVERT(DATETIME, ''19000101''))

    END
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRTimeEntryUpdate]
    ON [dbo].[TimeEntry]
       AFTER Update
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE TIE
         SET TIE.[Charge] = CASE WHEN ISNULL(INS.[Charged], 0) <> ISNULL(DEL.[Charged], 0) 
                                      THEN ISNULL(INS.[Charged], 0)
                                 ELSE ISNULL(INS.[Charge], 0) END,
             TIE.[Charged] = CASE WHEN ISNULL(INS.[Charge], 0) <> ISNULL(DEL.[Charge], 0) 
                                      THEN ISNULL(INS.[Charge], 0)
                                  ELSE ISNULL(INS.[Charged], 0) END,
             TIE.[BillingDate] = CASE WHEN ISNULL(INS.[BilledDate], CONVERT(DATETIME, ''19000101'')) <> ISNULL(DEL.[BilledDate], CONVERT(DATETIME, ''19000101'')) 
                                      THEN INS.[BilledDate]
                                 ELSE INS.[BillingDate] END,
             TIE.[BilledDate] = CASE WHEN ISNULL(INS.[BillingDate], CONVERT(DATETIME, ''19000101'')) <> ISNULL(DEL.[BillingDate], CONVERT(DATETIME, ''19000101'')) 
                                      THEN INS.[BillingDate]
                                ELSE INS.[BilledDate] END
        FROM inserted INS
             INNER JOIN deleted DEL
                     ON DEL.[RecordID] = INS.[RecordID]
             INNER JOIN [dbo].[TimeEntry] TIE
                     ON TIE.[RecordID] = INS.[RecordID]
       WHERE ISNULL(INS.[Charge], 0) <> ISNULL(DEL.[Charge], 0)
          OR ISNULL(INS.[Charged], 0) <> ISNULL(DEL.[Charged], 0)
          OR ISNULL(INS.[BillingDate], CONVERT(DATETIME, ''19000101'')) <> ISNULL(DEL.[BillingDate], CONVERT(DATETIME, ''19000101''))
          OR ISNULL(INS.[BilledDate], CONVERT(DATETIME, ''19000101'')) <> ISNULL(DEL.[BilledDate], CONVERT(DATETIME, ''19000101''))
    END
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'SET IDENTITY_INSERT [dbo].[TimeEntry] ON

INSERT
  INTO [dbo].[TimeEntry]
      ([RecordID],
       [Matter],
       [FeeEarn],
       [Date],
       [Time],
       [Rate],
       [Task],
       [TimeOrCharge],
       [Comment],
       [Billed],
       [NCCode],
       [Docket],
       [Team],
       [TrackRef],
       [Rec_Irr],
       [ShouldHave],
       [InvoiceNo],
       [Period],
       [Year],
       [BillingPeriod],
       [BillingYear],
       [OpenInv],
       [ActionID],
       [StageCode],
       [BilledAmount],
       [AxleNumber],
       [WriteOffDT],
       [WriteOffID])
SELECT TIEX.[RecordID],
       RTRIM(ISNULL(TIEX.[Matter], '''')),
       RTRIM(ISNULL(TIEX.[FeeEarn], '''')),
       ISNULL(TIEX.[Date], ISNULL(MAT.[Started], ''19000101'')),
       ISNULL(TIEX.[Time], 0),
       ISNULL(TIEX.[Rate], 0),
       RTRIM(ISNULL(TIEX.[Task], '''')),
       RTRIM(ISNULL(TIEX.[TimeOrCharge], ''T'')),
       RTRIM(TIEX.[Comment]),
       ISNULL(TIEX.[Billed], 0),
       TIEX.[NCCode],
       ISNULL(TIEX.[Docket], 0),
       TIEX.[Team],
       ISNULL(TIEX.[TrackRef], 0),
       RTRIM(ISNULL(TIEX.[Rec_Irr], '''')),
       ISNULL(TIEX.[ShouldHave], 0),
       ISNULL(TIEX.[InvoiceNo], 0),
       TIEX.[Period],
       TIEX.[Year],
       TIEX.[BillingPeriod],
       TIEX.[BillingYear],
       TIEX.[OpenInv],
       TIEX.[ActionID],
       TIEX.[StageCode],
       ISNULL(TIEX.[BilledAmount], 0),
       TIEX.[AxleNumber],'

IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
          INNER JOIN SYS.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                 AND SC.[name] = 'WriteOffDT'
    WHERE SO.[name] = 'TIEFIX')
  BEGIN
    SET @COMMAND = @COMMAND + '
       TIEX.[WriteOffDT],'
  END
ELSE
  BEGIN
    SET @COMMAND = @COMMAND + '
       CONVERT(DATETIME, NULL),'
  END

IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
          INNER JOIN SYS.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                 AND SC.[name] = 'WriteOffID'
    WHERE SO.[name] = 'TIEFIX')
  BEGIN
    SET @COMMAND = @COMMAND + '
       TIEX.[WriteOffID]'
  END
ELSE
  BEGIN
    SET @COMMAND = @COMMAND + '
       CONVERT(INT, NULL)'
  END

SET @COMMAND = @COMMAND + '
  FROM [dbo].[TIEFIX] TIEX
       LEFT OUTER JOIN [dbo].[matters] MAT 
                    ON MAT.[Code] = TIEX.[Matter]

SET IDENTITY_INSERT [dbo].[TimeEntry] OFF

DECLARE @maxVal INT
SELECT @maxVal = ISNULL(max(RECORDID),0)+1 from [dbo].[TimeEntry]
DBCC CHECKIDENT(''TimeEntry'', RESEED, @maxVal)'

    EXEC (@COMMAND)

    --SAM3 - Column is named "CHARGE"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CHARGE'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[Charge] = ISNULL(TIEX.[Charge], 0)
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "CHARGED"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CHARGED'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[Charge] = ISNULL(TIEX.[Charged], 0)
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "BillingDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BillingDate'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[BillingDate] = TIEX.[BillingDate]
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "BilledDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BilledDate'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[BillingDate] = TIEX.[BilledDate]
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM3 - DOES contain a IncludeInBill column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'IncludeInBill'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[IncludeInBill] = ISNULL(TIEX.[IncludeInBill], 1)
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM3 - DOES contain a Leave column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Leave'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[Leave] = TIEX.[Leave]
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a Units column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Units'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[Units] = ISNULL(TIEX.[Units], 0)
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a MatterLevel column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'MatterLevel'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[MatterLevel] = TIEX.[MatterLevel]
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a FEERate column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'FEERate'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[FEERate] = TIEX.[FEERate]
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a ChargedMins column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ChargedMins'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[ChargedMins] = TIEX.[ChargedMins]
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a FEECost column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'FEECost'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[FEECost] = TIEX.[FEECost]
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a TaskLevel column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'TaskLevel'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[TaskLevel] = TIEX.[TaskLevel]
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a WriteOff column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'WriteOff'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[WriteOff] = TIEX.[WriteOff]
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a Branch column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Branch'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[Branch] = TIEX.[Branch]
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a EntryDate column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'EntryDate'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[EntryDate] = TIEX.[EntryDate]
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - DOES contain a ModifyDate column
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ModifyDate'
        WHERE SO.[name] = 'TIEFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE TIE
     SET TIE.[ModifyDate] = TIEX.[ModifyDate]
    FROM [dbo].[TimeEntry] TIE
         INNER JOIN [dbo].[TIEFIX] TIEX
                 ON TIEX.[RecordId] = TIE.[RecordID]'

        EXEC (@COMMAND)
      END

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [IDX_WriteOffs]
      ON [dbo].[TimeEntry]
        ([WriteOffID] ASC,
         [RECORDID]   ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeeFeeMater] 
      ON [dbo].[TimeEntry]
        ([FEEEARN] ASC,
         [MATTER]  ASC,
         [DATE]    ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyFeeEarn] 
      ON [dbo].[TimeEntry]
        ([FEEEARN] ASC,
         [DATE]    ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX
         [KeyInvoiceNo]
      ON [dbo].[TimeEntry]
        ([INVOICENO] ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX
         [KeyMatter]
      ON [dbo].[TimeEntry]
        ([MATTER]   ASC,
         [DATE]     ASC,
         [RECORDID] ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX
         [KeyNCCCode]
      ON [dbo].[TimeEntry]
        ([NCCODE]  ASC,
         [FEEEARN] ASC,
         [DATE]    ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX 
         [KeyPeriod]
      ON [dbo].[TimeEntry]
        ([MATTER] ASC,
         [PERIOD] ASC,
         [YEAR] ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX
         [KeyTask]
      ON [dbo].[TimeEntry]
        ([TASK] ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX
         [KeyTeam]
      ON [dbo].[TimeEntry]
        ([TEAM]   ASC,
         [MATTER] ASC,
         [DATE]   ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

        SET @COMMAND = '  CREATE NONCLUSTERED INDEX
         [KeyTrackRef]
      ON [dbo].[TimeEntry]
        ([TRACKREF]   ASC,
         [DATE]       ASC)
      ON [PRIMARY]'

    EXEC (@COMMAND)

    IF EXISTS
      (SELECT TOP 1 1 FROM [dbo].[TimeEntry])
      BEGIN
        SET @COMMAND = 'DROP TABLE [dbo].[TIEFIX]'

        EXEC (@COMMAND)
      END
    ELSE
      BEGIN
        IF NOT EXISTS
          (SELECT TOP 1 1 FROM [dbo].[TIEFIX])
          BEGIN
            SET @COMMAND = 'DROP TABLE [dbo].[TIEFIX]'

            EXEC (@COMMAND)
          END
      END


  END
GO

IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
          INNER JOIN SYS.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                 AND SC.[name] = 'DESC'
          INNER JOIN SYS.[columns] SC2
                  ON SC2.[object_id] = SO.[object_id]
                 AND SC2.[name] = 'Description'
    WHERE SO.[name] = 'Departments'
      AND SO.[type] = 'U')
  BEGIN
    EXEC ('UPDATE [DEP]
   SET [DEP].[Description] = RTRIM(ISNULL([DEP].[Description], ISNULL([DEP].[DESC], ''''))),
       [DEP].[DESC] = RTRIM(ISNULL([DEP].[DESC], ISNULL([DEP].[Description], '''')))
  FROM [dbo].[Departments] [DEP]')
  END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'Departments'
      AND SO.[type] = 'U')
BEGIN
  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
            INNER JOIN SYS.[indexes] SI
                    ON SI.[object_id] = SO.[object_id]
                   AND SI.[name] = 'PK_Departments'
            INNER JOIN sys.[columns] SC
                    ON SC.[object_id] = SO.[object_id]
                   AND SC.[name] = 'Parent'
      WHERE SO.[name] = 'Departments'
        AND SO.[type] = 'U')
    BEGIN
      SELECT * INTO [dbo].[DEPFIX] FROM [dbo].[Departments] 
        
      DECLARE @COMMAND VARCHAR(MAX)

      SET @COMMAND = 'DROP TABLE [dbo].[Departments]'

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE TABLE 
       [dbo].[Departments]
      ([CODE]                 [varchar](5)                                                                                   NOT NULL,
	     [DESCRIPTION]          [varchar](50)   CONSTRAINT [DF_Departments_Description] DEFAULT ''''                           NOT NULL,
	     [RETIRED]              [char](1)       CONSTRAINT [CS_Departments_Retired] CHECK ([RETIRED] IN (''Y'', ''N''))
                                              CONSTRAINT [DF_Departments_Retired] DEFAULT ''N''                              NOT NULL,
	     [AnalyseYN]            [char](1)       CONSTRAINT [CS_Departments_AnalyseYN] CHECK ([AnalyseYN] IN (''Y'', ''N''))
                                              CONSTRAINT [DF_Departments_AnalyseYN] DEFAULT ''Y''                            NOT NULL,
	     [Target1]              [decimal](18,0) CONSTRAINT [DF_Departments_Target01] DEFAULT 0                                 NOT NULL,
	     [Target2]              [decimal](18,0) CONSTRAINT [DF_Departments_Target02] DEFAULT 0                                 NOT NULL,
	     [Target3]              [decimal](18,0) CONSTRAINT [DF_Departments_Target03] DEFAULT 0                                 NOT NULL,
	     [Target4]              [decimal](18,0) CONSTRAINT [DF_Departments_Target04] DEFAULT 0                                 NOT NULL,
	     [Target5]              [decimal](18,0) CONSTRAINT [DF_Departments_Target05] DEFAULT 0                                 NOT NULL,
	     [Target6]              [decimal](18,0) CONSTRAINT [DF_Departments_Target06] DEFAULT 0                                 NOT NULL,
	     [Target7]              [decimal](18,0) CONSTRAINT [DF_Departments_Target07] DEFAULT 0                                 NOT NULL,
	     [Target8]              [decimal](18,0) CONSTRAINT [DF_Departments_Target08] DEFAULT 0                                 NOT NULL,
	     [Target9]              [decimal](18,0) CONSTRAINT [DF_Departments_Target09] DEFAULT 0                                 NOT NULL,
	     [Target10]             [decimal](18,0) CONSTRAINT [DF_Departments_Target10] DEFAULT 0                                 NOT NULL,
	     [Target11]             [decimal](18,0) CONSTRAINT [DF_Departments_Target11] DEFAULT 0                                 NOT NULL,
	     [Target12]             [decimal](18,0) CONSTRAINT [DF_Departments_Target12] DEFAULT 0                                 NOT NULL,
	     [Parent]               [varchar](15)                                                                                      NULL,
	     [DESC]                 [varchar](50)   CONSTRAINT [DF_Departments_Desc] DEFAULT ''''                                  NOT NULL,
       CONSTRAINT [PK_Departments]
                  PRIMARY KEY CLUSTERED 
                 ([CODE] ASC)
               ON [PRIMARY])
    ON [PRIMARY]'                

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRDepartmentsInsert]
    ON [dbo].[Departments]
       AFTER INSERT
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      DECLARE @CHARGE DECIMAL(10, 2)

      UPDATE DEP
         SET DEP.[DESC] = CASE WHEN ISNULL(DEP.[DESC], '''') <> ''''
                                    THEN ISNULL(DEP.[DESC], '''')
                               ELSE ISNULL(DEP.[Description], '''') END,
             DEP.[Description] = CASE WHEN ISNULL(DEP.[DESC], '''') <> ''''
                                           THEN ISNULL(DEP.[DESC], '''')
                                      ELSE ISNULL(DEP.[Description], '''') END
        FROM inserted INS
             INNER JOIN [dbo].[Departments] DEP
                     ON DEP.[CODE] = INS.[CODE]
       WHERE ISNULL(INS.[DESC], '''') <> ISNULL(INS.[Description], '''')

    END
END'

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRDepartmentsUpdate]
    ON [dbo].[Departments]
       AFTER Update
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE DEP
         SET DEP.[DESC] = CASE WHEN ISNULL(INS.[Description], ''**NULL**'') <> ISNULL(DEL.[Description], ''**NULL**'') 
                                    THEN INS.[Description]
                               ELSE INS.[DESC] END,
             DEP.[Description] = CASE WHEN ISNULL(INS.[DESC], ''**NULL**'') <> ISNULL(DEL.[DESC], ''**NULL**'') 
                                      THEN INS.[DESC]
                                 ELSE INS.[Description] END
        FROM inserted INS
             INNER JOIN deleted DEL
                     ON DEL.[CODE] = INS.[CODE]
             INNER JOIN [dbo].[Departments] DEP
                     ON DEP.[CODE] = INS.[CODE]
       WHERE ISNULL(INS.[DESC], ''**NULL**'') <> ISNULL(DEL.[DESC], ''**NULL**'')
          OR ISNULL(INS.[Description], ''**NULL**'') <> ISNULL(DEL.[Description], ''**NULL**'')
    END
END'

      EXEC (@COMMAND)

      SET @COMMAND = '  INSERT
    INTO [dbo].[Departments]
        ([CODE],
         [DESC],
         [RETIRED])
  SELECT RTRIM(ISNULL(DEX.[CODE], '''')),
         RTRIM(ISNULL(DEX.[DESC], '''')),
         CASE WHEN RTRIM(ISNULL(DEX.[RETIRED], ''N'')) = ''Y'' THEN ''Y'' ELSE ''N'' END
    FROM [dbo].[DEPFIX] DEX'

      EXEC (@COMMAND)

      --SAM4 - DOES contain a Description column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'Description'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[Description] = RTRIM(ISNULL(DEPX.[Description], ''''))
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

        SET @COMMAND = 'UPDATE DEP
           SET DEP.[DESC] = CASE WHEN ISNULL(DEP.[Description], '''') = '''' THEN DEP.[DESC] ELSE ISNULL(DEP.[Description], '''') END
          FROM [dbo].[Departments] DEP'

        EXEC (@COMMAND)

        SET @COMMAND = 'UPDATE DEP
           SET DEP.[Description] = CASE WHEN ISNULL(DEP.[DESC], '''') = '''' THEN DEP.[Description] ELSE ISNULL(DEP.[DESC], '''') END
          FROM [dbo].[Departments] DEP'

        EXEC (@COMMAND)

      --SAM4 - DOES contain a AnalyseYN column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'AnalyseYN'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[AnalyseYN] = CASE WHEN RTRIM(ISNULL(DEPX.[AnalyseYN], ''Y'')) = ''N'' THEN ''N'' ELSE ''Y'' END
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

      --SAM4 - DOES contain a Target1 column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'Target1'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[Target1] = ISNULL(DEPX.[Target1], 0)
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

      --SAM4 - DOES contain a Target2 column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'Target2'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[Target2] = ISNULL(DEPX.[Target2], 0)
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

      --SAM4 - DOES contain a Target3 column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'Target3'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[Target3] = ISNULL(DEPX.[Target3], 0)
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

      --SAM4 - DOES contain a Target4 column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'Target4'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[Target4] = ISNULL(DEPX.[Target4], 0)
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

      --SAM4 - DOES contain a Target5 column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'Target5'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[Target5] = ISNULL(DEPX.[Target5], 0)
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

      --SAM4 - DOES contain a Target6 column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'Target6'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[Target6] = ISNULL(DEPX.[Target6], 0)
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

      --SAM4 - DOES contain a Target7 column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'Target7'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[Target7] = ISNULL(DEPX.[Target7], 0)
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

      --SAM4 - DOES contain a Target8 column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'Target8'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[Target8] = ISNULL(DEPX.[Target8], 0)
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

      --SAM4 - DOES contain a Target9 column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'Target9'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[Target9] = ISNULL(DEPX.[Target9], 0)
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

      --SAM4 - DOES contain a Target10 column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'Target10'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[Target10] = ISNULL(DEPX.[Target10], 0)
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

      --SAM4 - DOES contain a Target11 column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'Target11'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[Target11] = ISNULL(DEPX.[Target11], 0)
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

      --SAM4 - DOES contain a Target12 column
      IF EXISTS
        (SELECT *
           FROM SYS.[objects] SO
                INNER JOIN SYS.[columns] SC
                        ON SC.[object_id] = SO.[object_id]
                       AND SC.[name] = 'Target12'
          WHERE SO.[name] = 'DEPFIX'
            AND SO.[type] = 'U')
        BEGIN

          SET @COMMAND = '  UPDATE DEP
     SET DEP.[Target12] = ISNULL(DEPX.[Target12], 0)
    FROM [dbo].[Departments] DEP
         INNER JOIN [dbo].[DEPFIX] DEPX
                 ON DEPX.[CODE] = DEP.[CODE]'

          EXEC (@COMMAND)
        END

      IF EXISTS
        (SELECT TOP 1 1 FROM [dbo].[Departments])
        BEGIN
          SET @COMMAND = 'DROP TABLE [dbo].[DEPFIX]'

          EXEC (@COMMAND)
        END
      ELSE
        BEGIN
          IF NOT EXISTS
            (SELECT TOP 1 1 FROM [dbo].[DEPFIX])
            BEGIN
              SET @COMMAND = 'DROP TABLE [dbo].[DEPFIX]'

              EXEC (@COMMAND)
            END
        END
    END
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'Handlers'
      AND SO.[type] = 'U')
BEGIN
  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
            INNER JOIN SYS.[columns] SC1
                    ON SC1.[object_id] = SO.[object_id]
                   AND SC1.[name] = 'Phoneno'
            INNER JOIN SYS.[columns] SC2
                    ON SC2.[object_id] = SO.[object_id]
                   AND SC2.[name] = 'PhoneNumber'
            INNER JOIN SYS.[columns] SC3
                    ON SC3.[object_id] = SO.[object_id]
                   AND SC3.[name] = 'AutoLaunchKPI'
                   AND SC3.[system_type_id] = 175
      WHERE SO.[name] = 'Handlers'
        AND SO.[type] = 'U')
    BEGIN
      SELECT * INTO [dbo].[HANFIX] FROM [dbo].[Handlers] 
        
      DECLARE @COMMAND VARCHAR(MAX)

      SET @COMMAND = 'DROP TABLE [dbo].[Handlers]'

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE TABLE 
       [dbo].[Handlers]
      ([CODE]                  [varchar](10)                                                                                     NOT NULL,
       [TEAM]                  [varchar](10)                                                                                         NULL,
       [TEAMCODE]              [char](1)          CONSTRAINT [CS_Handlers_TEAMCODE] CHECK ([TEAMCODE] IN (''Y'', ''N''))
                                                  CONSTRAINT [DF_Handlers_TEAMCODE] DEFAULT ''N''                                  NOT NULL,
       [Dept]                  [varchar](5)                                                                                          NULL,
       [Type]                  [char](1)                                                                                             NULL,
       [NAME]                  [varchar](30)      CONSTRAINT [DF_Handlers_NAME] DEFAULT ''''                                       NOT NULL,
       [RATE]                  [decimal](10, 2)   CONSTRAINT [DF_Handlers_RATE] DEFAULT 0                                        NOT NULL,
       [BUDGET1]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_BUDGET01] DEFAULT (0)                                  NOT NULL,
       [BUDGET2]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_BUDGET02] DEFAULT (0)                                  NOT NULL,
       [BUDGET3]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_BUDGET03] DEFAULT (0)                                  NOT NULL,
       [BUDGET4]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_BUDGET04] DEFAULT (0)                                  NOT NULL,
       [BUDGET5]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_BUDGET05] DEFAULT (0)                                  NOT NULL,
       [BUDGET6]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_BUDGET06] DEFAULT (0)                                  NOT NULL,
       [BUDGET7]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_BUDGET07] DEFAULT (0)                                  NOT NULL,
       [BUDGET8]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_BUDGET08] DEFAULT (0)                                  NOT NULL,
       [BUDGET9]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_BUDGET09] DEFAULT (0)                                  NOT NULL,
       [BUDGET10]              [decimal](13, 2)   CONSTRAINT [DF_Handlers_BUDGET10] DEFAULT (0)                                  NOT NULL,
       [BUDGET11]              [decimal](13, 2)   CONSTRAINT [DF_Handlers_BUDGET11] DEFAULT (0)                                  NOT NULL,
       [BUDGET12]              [decimal](13, 2)   CONSTRAINT [DF_Handlers_BUDGET12] DEFAULT (0)                                  NOT NULL,
       [ACTUAL1]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_ACTUAL01] DEFAULT (0)                                  NOT NULL,
       [ACTUAL2]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_ACTUAL02] DEFAULT (0)                                  NOT NULL,
       [ACTUAL3]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_ACTUAL03] DEFAULT (0)                                  NOT NULL,
       [ACTUAL4]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_ACTUAL04] DEFAULT (0)                                  NOT NULL,
       [ACTUAL5]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_ACTUAL05] DEFAULT (0)                                  NOT NULL,
       [ACTUAL6]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_ACTUAL06] DEFAULT (0)                                  NOT NULL,
       [ACTUAL7]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_ACTUAL07] DEFAULT (0)                                  NOT NULL,
       [ACTUAL8]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_ACTUAL08] DEFAULT (0)                                  NOT NULL,
       [ACTUAL9]               [decimal](13, 2)   CONSTRAINT [DF_Handlers_ACTUAL09] DEFAULT (0)                                  NOT NULL,
       [ACTUAL10]              [decimal](13, 2)   CONSTRAINT [DF_Handlers_ACTUAL10] DEFAULT (0)                                  NOT NULL,
       [ACTUAL11]              [decimal](13, 2)   CONSTRAINT [DF_Handlers_ACTUAL11] DEFAULT (0)                                  NOT NULL,
       [ACTUAL12]              [decimal](13, 2)   CONSTRAINT [DF_Handlers_ACTUAL12] DEFAULT (0)                                  NOT NULL,
       [TEMPCALC]              [decimal](13, 2)   CONSTRAINT [DF_Handlers_TEMPCALC] DEFAULT (0)                                  NOT NULL,
       [LOGON]                 [varchar](10)                                                                                         NULL,
       [MAILADDRESS]           [varchar](20)                                                                                         NULL,
       [TIMECOSTER]            [char](1)                                                                                             NULL,
       [TEAMLEADER]            [char](1)                                                                                             NULL,
       [NORECENTMATTERS]       [int]              CONSTRAINT [DF_Handlers_NORECENTMATTERS] DEFAULT ((0))                         NOT NULL,
       [DEFAULTTASK]           [char](6)                                                                                             NULL,
       [EXCHANGEALIAS]         [varchar](256)                                                                                        NULL,
       [RATE1]                 [decimal](7, 2)    CONSTRAINT [DF_Handlers_RATE1] DEFAULT ((0))                                   NOT NULL,
       [RATE2]                 [decimal](7, 2)    CONSTRAINT [DF_Handlers_RATE2] DEFAULT ((0))                                   NOT NULL,
       [RATE3]                 [decimal](7, 2)    CONSTRAINT [DF_Handlers_RATE3] DEFAULT ((0))                                   NOT NULL,
       [RATE4]                 [decimal](7, 2)    CONSTRAINT [DF_Handlers_RATE4] DEFAULT ((0))                                   NOT NULL,
       [RATE5]                 [decimal](7, 2)    CONSTRAINT [DF_Handlers_RATE5] DEFAULT ((0))                                   NOT NULL,
       [SIGNATURE]             [varchar](MAX)                                                                                        NULL,
       [EMAIL]                 [varchar](100)                                                                                        NULL,
       [RETIRED]               [char](1)                                                                                             NULL,
       [DELEGATE]              [varchar](50)                                                                                         NULL,
       [OutlookView]           [char](1)                                                                                             NULL,
       [AutoLaunchTimer]       [char](1)                                                                                             NULL,
       [Phoneno]               [varchar](31)                                                                                         NULL,
       [PhoneNumber]           [varchar](31)                                                                                         NULL,
       [AutoLaunchKPI]         [char](1)         CONSTRAINT [DF_Handlers_AutoLaunchKPI] DEFAULT ((''0''))                        NOT NULL,
       [AxleNumber]            [int]                                                                                                 NULL,
       [UnitCost]              [decimal](14, 2)  CONSTRAINT [DF_Handlers_UnitCost] DEFAULT ((0))                                 NOT NULL,
       [TargetRecov]           [decimal](7, 2)   CONSTRAINT [DF_Handlers_TargetRecov] DEFAULT ((0))                              NOT NULL,
       [Branch]                [char](3)                                                                                             NULL,
       [FaxNumber]             [varchar](31)                                                                                         NULL,
       [ChargeGroup]           [char](5)                                                                                             NULL,
       CONSTRAINT [PK_Handlers] 
                  PRIMARY KEY CLUSTERED 
                 ([CODE] ASC)
               ON [PRIMARY])
    ON [PRIMARY]'                

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRHandlersInsert]
    ON [dbo].[Handlers]
       AFTER INSERT
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      DECLARE @CHARGE DECIMAL(10, 2)

      UPDATE HAN
         SET HAN.[Phoneno] = CASE WHEN ISNULL(HAN.[Phoneno], '''') <> ''''
                                       THEN ISNULL(HAN.[Phoneno], '''')
                                  ELSE ISNULL(HAN.[PhoneNumber], '''') END,
             HAN.[PhoneNumber] = CASE WHEN ISNULL(HAN.[Phoneno], '''') <> ''''
                                           THEN ISNULL(HAN.[Phoneno], '''')
                                      ELSE ISNULL(HAN.[PhoneNumber], '''') END
        FROM inserted INS
             INNER JOIN [dbo].[Handlers] HAN
                     ON HAN.[CODE] = INS.[CODE]
       WHERE ISNULL(INS.[Phoneno], '''') <> ISNULL(INS.[PhoneNumber], '''')

    END
END'

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRHandlersUpdate]
    ON [dbo].[Handlers]
       AFTER Update
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE HAN
         SET HAN.[Phoneno] = CASE WHEN ISNULL(INS.[PhoneNumber], ''**NULL**'') <> ISNULL(DEL.[PhoneNumber], ''**NULL**'') 
                                       THEN INS.[PhoneNumber]
                                  ELSE INS.[Phoneno] END,
             HAN.[PhoneNumber] = CASE WHEN ISNULL(INS.[Phoneno], ''**NULL**'') <> ISNULL(DEL.[Phoneno], ''**NULL**'') 
                                      THEN INS.[Phoneno]
                                  ELSE INS.[PhoneNumber] END
        FROM inserted INS
             INNER JOIN deleted DEL
                     ON DEL.[CODE] = INS.[CODE]
             INNER JOIN [dbo].[Handlers] HAN
                     ON HAN.[CODE] = INS.[CODE]
       WHERE ISNULL(INS.[Phoneno], ''**NULL**'') <> ISNULL(DEL.[Phoneno], ''**NULL**'')
          OR ISNULL(INS.[PhoneNumber], ''**NULL**'') <> ISNULL(DEL.[PhoneNumber], ''**NULL**'')
    END
END'

      EXEC (@COMMAND)

      SET @COMMAND = '  INSERT
    INTO [dbo].[Handlers]
        ([CODE],
         [TEAM],
         [TEAMCODE],
         [Dept],
         [Type],
         [NAME],
         [RATE],
         [BUDGET1],
         [BUDGET2],
         [BUDGET3],
         [BUDGET4],
         [BUDGET5],
         [BUDGET6],
         [BUDGET7],
         [BUDGET8],
         [BUDGET9],
         [BUDGET10],
         [BUDGET11],
         [BUDGET12],
         [ACTUAL1],
         [ACTUAL2],
         [ACTUAL3],
         [ACTUAL4],
         [ACTUAL5],
         [ACTUAL6],
         [ACTUAL7],
         [ACTUAL8],
         [ACTUAL9],
         [ACTUAL10],
         [ACTUAL11],
         [ACTUAL12],
         [TEMPCALC],
         [LOGON],
         [MAILADDRESS],
         [TIMECOSTER],
         [TEAMLEADER],
         [NORECENTMATTERS],
         [DEFAULTTASK],
         [EXCHANGEALIAS],
         [RATE1],
         [RATE2],
         [RATE3],
         [RATE4],
         [RATE5],
         [SIGNATURE],
         [EMAIL],
         [RETIRED],
         [DELEGATE],
         [OutlookView],
         [AutoLaunchTimer],
         [AxleNumber])
  SELECT RTRIM(ISNULL([CODE], '''')),
         RTRIM([TEAM]),
         CASE WHEN RTRIM(ISNULL([TEAMCODE], ''N'')) = ''Y'' THEN ''Y'' ELSE ''N'' END,
         RTRIM([Dept]),
         [Type],
         RTRIM(ISNULL([NAME], '''')),
         ISNULL([RATE], 0),
         ISNULL([BUDGET1], 0),
         ISNULL([BUDGET2], 0),
         ISNULL([BUDGET3], 0),
         ISNULL([BUDGET4], 0),
         ISNULL([BUDGET5], 0),
         ISNULL([BUDGET6], 0),
         ISNULL([BUDGET7], 0),
         ISNULL([BUDGET8], 0),
         ISNULL([BUDGET9], 0),
         ISNULL([BUDGET10], 0),
         ISNULL([BUDGET11], 0),
         ISNULL([BUDGET12], 0),
         ISNULL([ACTUAL1], 0),
         ISNULL([ACTUAL2], 0),
         ISNULL([ACTUAL3], 0),
         ISNULL([ACTUAL4], 0),
         ISNULL([ACTUAL5], 0),
         ISNULL([ACTUAL6], 0),
         ISNULL([ACTUAL7], 0),
         ISNULL([ACTUAL8], 0),
         ISNULL([ACTUAL9], 0),
         ISNULL([ACTUAL10], 0),
         ISNULL([ACTUAL11], 0),
         ISNULL([ACTUAL12], 0),
         ISNULL([TEMPCALC], 0),
         RTRIM([LOGON]),
         RTRIM([MAILADDRESS]),
         [TIMECOSTER],
         [TEAMLEADER],
         ISNULL([NORECENTMATTERS], 30),
         [DEFAULTTASK],
         RTRIM([EXCHANGEALIAS]),
         ISNULL([RATE1], 0),
         ISNULL([RATE2], 0),
         ISNULL([RATE3], 0),
         ISNULL([RATE4], 0),
         ISNULL([RATE5], 0),
         RTRIM(CONVERT(VARCHAR(MAX), [SIGNATURE])),
         RTRIM([EMAIL]),
         [RETIRED],
         RTRIM([DELEGATE]),
         [OutlookView],
         [AutoLaunchTimer],
         [AxleNumber]
    FROM [dbo].[HANFIX] DEX'

      EXEC (@COMMAND)

    --SAM4 - Column is named "AutoLaunchKPI"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'AutoLaunchKPI'
        WHERE SO.[name] = 'HANFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE HAN
     SET HAN.[AutoLaunchKPI] = CASE WHEN ISNUMERIC(HANX.[AutoLaunchKPI]) = 1 THEN CONVERT(CHAR(1), ISNULL(CONVERT(INT, HANX.[AutoLaunchKPI]), 0)) ELSE ''0'' END
    FROM [dbo].[Handlers] HAN
         INNER JOIN [dbo].[HANFIX] HANX
                 ON HANX.[CODE] = HAN.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "PhoneNumber"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'PhoneNumber'
        WHERE SO.[name] = 'HANFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE HAN
     SET HAN.[Phoneno] = RTRIM(ISNULL(HANX.[PhoneNumber], ''''))
    FROM [dbo].[Handlers] HAN
         INNER JOIN [dbo].[HANFIX] HANX
                 ON HANX.[CODE] = HAN.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "Phoneno"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Phoneno'
        WHERE SO.[name] = 'HANFIX'
          AND SO.[type] = 'U')
      BEGIN
        SET @COMMAND = '  UPDATE HAN
     SET HAN.[Phoneno] = RTRIM(ISNULL(HANX.[Phoneno], ''''))
    FROM [dbo].[Handlers] HAN
         INNER JOIN [dbo].[HANFIX] HANX
                 ON HANX.[CODE] = HAN.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Has Branch
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Branch'
        WHERE SO.[name] = 'HANFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE HAN
     SET HAN.[Branch] = HANX.[Branch]
    FROM [dbo].[Handlers] HAN
         INNER JOIN [dbo].[HANFIX] HANX
                 ON HANX.[CODE] = HAN.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Has FaxNumber
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'FaxNumber'
        WHERE SO.[name] = 'HANFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE HAN
     SET HAN.[FaxNumber] = RTRIM(HANX.[FaxNumber])
    FROM [dbo].[Handlers] HAN
         INNER JOIN [dbo].[HANFIX] HANX
                 ON HANX.[CODE] = HAN.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Has FaxNumber
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ChargeGroup'
        WHERE SO.[name] = 'HANFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE HAN
     SET HAN.[ChargeGroup] = RTRIM(HANX.[ChargeGroup])
    FROM [dbo].[Handlers] HAN
         INNER JOIN [dbo].[HANFIX] HANX
                 ON HANX.[CODE] = HAN.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Has FaxNumber
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'UnitCost'
        WHERE SO.[name] = 'HANFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE HAN
     SET HAN.[UnitCost] = ISNULL(HANX.[UnitCost], 0)
    FROM [dbo].[Handlers] HAN
         INNER JOIN [dbo].[HANFIX] HANX
                 ON HANX.[CODE] = HAN.[CODE]'

        EXEC (@COMMAND)
      END

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX 
       [KeyExchange]
    ON [dbo].[Handlers]
      ([EXCHANGEALIAS] ASC)
       INCLUDE ([CODE])
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX 
       [KeyLogon] 
    ON [dbo].[Handlers]
      ([LOGON] ASC)
       INCLUDE ([CODE])
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX 
       [KeyTeam] 
    ON [dbo].[Handlers]
      ([TEAM] ASC,
	     [CODE] ASC)
    ON [PRIMARY]'

    EXEC (@COMMAND)

      IF EXISTS
        (SELECT TOP 1 1 FROM [dbo].[Handlers])
        BEGIN
          SET @COMMAND = 'DROP TABLE [dbo].[HANFIX]'

          EXEC (@COMMAND)
        END
      ELSE
        BEGIN
          IF NOT EXISTS
            (SELECT TOP 1 1 FROM [dbo].[HANFIX])
            BEGIN
              SET @COMMAND = 'DROP TABLE [dbo].[HANFIX]'

              EXEC (@COMMAND)
            END
        END
    END
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'Undertakings'
      AND SO.[type] = 'U')
BEGIN
  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
            INNER JOIN SYS.[indexes] SI
                    ON SI.[object_id] = SO.[object_id]
                   AND SI.[name] = 'PK_Undertakings'
            INNER JOIN SYS.[columns] SC
                    ON SC.[object_id] = SO.[object_id]
                   AND SC.[name] = 'Notes'
            INNER JOIN SYS.[columns] SC2
                    ON SC2.[object_id] = SO.[object_id]
                   AND SC2.[name] = 'UNDVALUE'
      WHERE SO.[name] = 'Undertakings'
        AND SO.[type] = 'U')
    BEGIN
      SELECT * INTO [dbo].[UNDFIX] FROM [dbo].[Undertakings] 
        
      DECLARE @COMMAND VARCHAR(MAX)

      SET @COMMAND = 'DROP TABLE [dbo].[Undertakings]'

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE TABLE
       [dbo].[Undertakings]
      ([RECORDID]             [int]             IDENTITY(1,1)                                                            NOT NULL,
	     [MATTER]               [varchar](20)                                                                              NOT NULL,
       [SEQ]                  [int]                                                                                      NOT NULL,
       [DISCHARGEDATE]        [datetime]                                                                                     NULL,
       [TYPE]                 [char](1)                                                                                      NULL,
       [DESCRIPTION]          [varchar](500)    CONSTRAINT [DF_UndertakingsDescription] DEFAULT ('''')                   NOT NULL,
       [WHO]                  [varchar](200)                                                                                 NULL,
	     [ActionID]             [int]                                                                                          NULL,
       [GivenOrReceived]      [char](1)                                                                                      NULL,
       [Notified]             [char](1)                                                                                      NULL,
       [DischargeDescription] [varchar](100)                                                                                 NULL,
       [DischargedBy]         [varchar](10)                                                                                  NULL,
       [DealingNumber]        [varchar](40)                                                                                  NULL,
       [Notes]                [varchar](4000)                                                                                NULL,
       [CommercialOrNon]      [varchar](1)                                                                                   NULL,
       [Status]               [int]                                                                                          NULL,
       [DATE]                 [datetime]        CONSTRAINT [DF_UndertakingsDate] DEFAULT (''19000101'')                  NOT NULL,
       [UNDDATE]              [datetime]        CONSTRAINT [DF_UndertakingsUndDate] DEFAULT (''19000101'')               NOT NULL,
       [VALUE]                [decimal](13, 2)  CONSTRAINT [DF_UndertakingsValue] DEFAULT (0)                            NOT NULL,
       [UNDVALUE]             [decimal](13, 2)  CONSTRAINT [DF_UndertakingsUndValue] DEFAULT (0)                         NOT NULL,
       [AuthorisedByFE]       [varchar](10)                                                                                  NULL,
       [Handler]              [varchar](10)                                                                                  NULL,
       [UndertakingTo]        [varchar](10)                                                                                  NULL,
       [CaseContact]          [varchar](10)                                                                                  NULL,
	     [EntryDate]            [datetime]                                                                                     NULL,
       CONSTRAINT [PK_Undertakings]
                  PRIMARY KEY CLUSTERED 
                 ([RECORDID] ASC)
               ON [PRIMARY])
    ON [PRIMARY]'                

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRUndertakingsInsert]
    ON [dbo].[Undertakings]
       AFTER INSERT
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE UND
         SET UND.[VALUE] = CASE WHEN ISNULL(UND.[VALUE], 0) <> 0
                                     THEN ISNULL(UND.[VALUE], 0)
                                ELSE ISNULL(UND.[UNDVALUE], 0) END,
             UND.[UNDVALUE] = CASE WHEN ISNULL(UND.[VALUE], 0) <> 0
                                        THEN ISNULL(UND.[VALUE], 0)
                                   ELSE ISNULL(UND.[UNDVALUE], 0) END,
             UND.[DATE] = CASE WHEN UND.[DATE] IS NULL
                                    THEN UND.[UNDDATE]
                               ELSE UND.[DATE] END,
             UND.[UNDDATE] = CASE WHEN UND.[DATE] IS NULL
                                       THEN UND.[UNDDATE]
                                  ELSE UND.[DATE] END,
             UND.[AuthorisedByFE] = CASE WHEN UND.[AuthorisedByFE] IS NULL
                                              THEN UND.[Handler]
                                         ELSE UND.[AuthorisedByFE] END,
             UND.[Handler] = CASE WHEN UND.[AuthorisedByFE] IS NULL
                                              THEN UND.[Handler]
                                         ELSE UND.[AuthorisedByFE] END,
             UND.[UndertakingTo] = CASE WHEN UND.[UndertakingTo] IS NULL
                                             THEN UND.[CaseContact]
                                        ELSE UND.[UndertakingTo] END,
             UND.[CaseContact] = CASE WHEN UND.[UndertakingTo] IS NULL
                                           THEN UND.[CaseContact]
                                      ELSE UND.[UndertakingTo] END
        FROM inserted INS
             INNER JOIN [dbo].[Undertakings] UND
                     ON UND.[RecordID] = INS.[RecordID]
       WHERE ISNULL(INS.[VALUE], 0) <> ISNULL(INS.[UNDVALUE], 0)
          OR ISNULL(INS.[DATE], CONVERT(DATETIME, ''19000101'')) <> ISNULL(INS.[UNDDATE], CONVERT(DATETIME, ''19000101''))
          OR ISNULL(INS.[AuthorisedByFE], '''') <> ISNULL(INS.[Handler], '''')
          OR ISNULL(INS.[UndertakingTo], '''') <> ISNULL(INS.[CaseContact], '''')

    END
END'

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRUndertakingsUpdate]
    ON [dbo].[Undertakings]
       AFTER Update
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE UND
         SET UND.[VALUE] = CASE WHEN ISNULL(INS.[UNDVALUE], 0) <> ISNULL(DEL.[UNDVALUE], 0) 
                                     THEN ISNULL(INS.[UNDVALUE], 0)
                                ELSE ISNULL(INS.[VALUE], 0) END,
             UND.[UNDVALUE] = CASE WHEN ISNULL(INS.[VALUE], 0) <> ISNULL(DEL.[VALUE], 0) 
                                        THEN ISNULL(INS.[VALUE], 0)
                                   ELSE ISNULL(INS.[UNDVALUE], 0) END,
             UND.[DATE] = CASE WHEN ISNULL(INS.[UNDDATE], CONVERT(DATETIME, ''19000101'')) <> ISNULL(DEL.[UNDDATE], CONVERT(DATETIME, ''19000101'')) 
                                    THEN INS.[UNDDATE]
                               ELSE INS.[DATE] END,
             UND.[UNDDATE] = CASE WHEN ISNULL(INS.[DATE], CONVERT(DATETIME, ''19000101'')) <> ISNULL(DEL.[DATE], CONVERT(DATETIME, ''19000101'')) 
                                       THEN INS.[DATE]
                                  ELSE INS.[UNDDATE] END,
             UND.[AuthorisedByFE] = CASE WHEN ISNULL(INS.[Handler], ''**NULL**'') <> ISNULL(DEL.[Handler], ''**NULL**'') 
                                              THEN INS.[Handler]
                                         ELSE INS.[AuthorisedByFE] END,
             UND.[Handler] = CASE WHEN ISNULL(INS.[AuthorisedByFE], ''**NULL**'') <> ISNULL(DEL.[AuthorisedByFE], ''**NULL**'') 
                                       THEN INS.[AuthorisedByFE]
                                  ELSE INS.[Handler] END,
             UND.[UndertakingTo] = CASE WHEN ISNULL(INS.[CaseContact], ''**NULL**'') <> ISNULL(DEL.[CaseContact], ''**NULL**'') 
                                             THEN INS.[CaseContact]
                                        ELSE INS.[UndertakingTo] END,
             UND.[CaseContact] = CASE WHEN ISNULL(INS.[UndertakingTo], ''**NULL**'') <> ISNULL(DEL.[UndertakingTo], ''**NULL**'') 
                                           THEN INS.[UndertakingTo]
                                      ELSE INS.[CaseContact] END
        FROM inserted INS
             INNER JOIN deleted DEL
                     ON DEL.[RecordID] = INS.[RecordID]
             INNER JOIN [dbo].[Undertakings] UND
                     ON UND.[RecordID] = INS.[RecordID]
       WHERE ISNULL(INS.[VALUE], 0) <> ISNULL(DEL.[VALUE], 0)
          OR ISNULL(INS.[UNDVALUE], 0) <> ISNULL(DEL.[UNDVALUE], 0)
          OR ISNULL(INS.[DATE], CONVERT(DATETIME, ''19000101'')) <> ISNULL(DEL.[DATE], CONVERT(DATETIME, ''19000101''))
          OR ISNULL(INS.[UNDDATE], CONVERT(DATETIME, ''19000101'')) <> ISNULL(DEL.[UNDDATE], CONVERT(DATETIME, ''19000101''))
          OR ISNULL(INS.[AuthorisedByFE], ''**NULL**'') <> ISNULL(DEL.[AuthorisedByFE], ''**NULL**'')
          OR ISNULL(INS.[Handler], ''**NULL**'') <> ISNULL(DEL.[Handler], ''**NULL**'')
          OR ISNULL(INS.[UndertakingTo], ''**NULL**'') <> ISNULL(DEL.[UndertakingTo], ''**NULL**'')
          OR ISNULL(INS.[CaseContact], ''**NULL**'') <> ISNULL(DEL.[CaseContact], ''**NULL**'')
    END
END'

      EXEC (@COMMAND)

      SET @COMMAND = '  SET IDENTITY_INSERT [dbo].[Undertakings] ON

  INSERT
    INTO [dbo].[Undertakings]
        ([RECORDID],
	       [MATTER],
         [SEQ],
         [DISCHARGEDATE],
         [TYPE],
         [Status],
         [DESCRIPTION],
         [WHO],
	       [ActionID],
         [GivenOrReceived],
         [Notified],
         [DischargedBy],
         [DealingNumber])
  SELECT [RECORDID],
	       RTRIM(ISNULL([MATTER], '''')),
         ISNULL([SEQ], 0),
         [DISCHARGEDATE],
         [TYPE],
         [Status],
         [DESCRIPTION],
         [WHO],
	       [ActionID],
         [GivenOrReceived],
         [Notified],
         [DischargedBy],
         [DealingNumber]
    FROM [dbo].[UNDFIX] UNX
    
  SET IDENTITY_INSERT [dbo].[Undertakings] OFF

  DECLARE @maxVal INT
  SELECT @maxVal = ISNULL(max(RECORDID),0)+1 from [dbo].[Undertakings]
  DBCC CHECKIDENT(''Undertakings'', RESEED, @maxVal)'

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE NONCLUSTERED INDEX 
       [KeyMatter] 
    ON [dbo].[Undertakings]
      ([MATTER]      ASC,
	     [SEQ]         ASC,
	     [DATE]        ASC)
    ON [PRIMARY]'

      EXEC (@COMMAND)

    --Column is named "Notes"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Notes'
        WHERE SO.[name] = 'UNDFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE UND
     SET UND.[Notes] = RTRIM(UNDX.[Notes])
    FROM [dbo].[Undertakings] UND
         INNER JOIN [dbo].[UNDFIX] UNDX
                 ON UNDX.[RecordId] = UND.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "DATE"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'DATE'
        WHERE SO.[name] = 'UNDFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE UND
     SET UND.[DATE] = ISNULL(UNDX.[DATE], ''19000101'')
    FROM [dbo].[Undertakings] UND
         INNER JOIN [dbo].[UNDFIX] UNDX
                 ON UNDX.[RecordId] = UND.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "UNDDATE"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'UNDDATE'
        WHERE SO.[name] = 'UNDFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE UND
     SET UND.[UNDDATE] = ISNULL(UNDX.[UNDDATE], ''19000101'')
    FROM [dbo].[Undertakings] UND
         INNER JOIN [dbo].[UNDFIX] UNDX
                 ON UNDX.[RecordId] = UND.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "VALUE"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'VALUE'
        WHERE SO.[name] = 'UNDFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE UND
     SET UND.[VALUE] = ISNULL(UNDX.[VALUE], 0)
    FROM [dbo].[Undertakings] UND
         INNER JOIN [dbo].[UNDFIX] UNDX
                 ON UNDX.[RecordId] = UND.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "UNDVALUE"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'UNDVALUE'
        WHERE SO.[name] = 'UNDFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE UND
     SET UND.[UNDVALUE] = ISNULL(UNDX.[UNDVALUE], 0)
    FROM [dbo].[Undertakings] UND
         INNER JOIN [dbo].[UNDFIX] UNDX
                 ON UNDX.[RecordId] = UND.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "AuthorisedByFE"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'AuthorisedByFE'
        WHERE SO.[name] = 'UNDFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE UND
     SET UND.[AuthorisedByFE] = UNDX.[AuthorisedByFE]
    FROM [dbo].[Undertakings] UND
         INNER JOIN [dbo].[UNDFIX] UNDX
                 ON UNDX.[RecordId] = UND.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "Handler"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Handler'
        WHERE SO.[name] = 'UNDFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE UND
     SET UND.[Handler] = UNDX.[Handler]
    FROM [dbo].[Undertakings] UND
         INNER JOIN [dbo].[UNDFIX] UNDX
                 ON UNDX.[RecordId] = UND.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "UndertakingTo"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'UndertakingTo'
        WHERE SO.[name] = 'UNDFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE UND
     SET UND.[UndertakingTo] = UNDX.[UndertakingTo]
    FROM [dbo].[Undertakings] UND
         INNER JOIN [dbo].[UNDFIX] UNDX
                 ON UNDX.[RecordId] = UND.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "CaseContact"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CaseContact'
        WHERE SO.[name] = 'UNDFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE UND
     SET UND.[CaseContact] = UNDX.[CaseContact]
    FROM [dbo].[Undertakings] UND
         INNER JOIN [dbo].[UNDFIX] UNDX
                 ON UNDX.[RecordId] = UND.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "EntryDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'EntryDate'
        WHERE SO.[name] = 'UNDFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE UND
     SET UND.[EntryDate] = UNDX.[EntryDate]
    FROM [dbo].[Undertakings] UND
         INNER JOIN [dbo].[UNDFIX] UNDX
                 ON UNDX.[RecordId] = UND.[RecordID]'

        EXEC (@COMMAND)
      END


    --SAM3 - Column is named "DischargeDescription"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'DischargeDescription'
        WHERE SO.[name] = 'UNDFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE UND
     SET UND.[DischargeDescription] = UNDX.[DischargeDescription]
    FROM [dbo].[Undertakings] UND
         INNER JOIN [dbo].[UNDFIX] UNDX
                 ON UNDX.[RecordId] = UND.[RecordID]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "CommercialOrNon"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CommercialOrNon'
        WHERE SO.[name] = 'UNDFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE UND
     SET UND.[CommercialOrNon] = UNDX.[CommercialOrNon]
    FROM [dbo].[Undertakings] UND
         INNER JOIN [dbo].[UNDFIX] UNDX
                 ON UNDX.[RecordId] = UND.[RecordID]'

        EXEC (@COMMAND)
      END

    IF EXISTS
      (SELECT TOP 1 1 FROM [dbo].[Undertakings])
      BEGIN
        SET @COMMAND = 'DROP TABLE [dbo].[UNDFIX]'

        EXEC (@COMMAND)
      END
    ELSE
      BEGIN
        IF NOT EXISTS
          (SELECT TOP 1 1 FROM [dbo].[UNDFIX])
          BEGIN
            SET @COMMAND = 'DROP TABLE [dbo].[UNDFIX]'

            EXEC (@COMMAND)
          END
      END


    END
END
GO

DECLARE @COMMAND VARCHAR(MAX)

DECLARE @CODELEN VARCHAR(2)
DECLARE @FixCAC BIT

SET @FixCAC = 0

SELECT @CODELEN = CONVERT(VARCHAR(2), SC.[max_length])
  FROM SYS.[objects] SO
       INNER JOIN SYS.[columns] SC
               ON SC.[object_id] = SO.[object_id]
              AND SC.[name] = 'CASECODE'
 WHERE SO.[name] = 'CaseContacts'
   AND SO.[type] = 'U'

IF (@CODELEN <> '20')
  BEGIN
    SET @FixCAC = 1
  END

IF (@FixCAC = 0)
  BEGIN
    IF NOT EXISTS
      (SELECT TOP 1 1
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'PUBLISH'
        WHERE SO.[name] = 'CaseContacts'
          AND SO.[type] = 'U')
      BEGIN
        SET @FixCAC = 1
      END
  END

IF (@FixCAC = 1)
  BEGIN
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
        WHERE SO.[name] = 'FIXCAC'
          AND SO.[type] = 'U')
    BEGIN
      SET @COMMAND = 'DROP TABLE [dbo].[FIXCAC]'

      EXEC (@COMMAND)
    END

    SET @COMMAND = 'SELECT *
  INTO [dbo].[FIXCAC]
  FROM [dbo].[CaseContacts]'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE 
      [dbo].[FIXCAC]
  ADD CONSTRAINT 
      [PK_FIXCAC]
      PRIMARY KEY CLUSTERED 
     ([CASECODE] ASC,
      [CONTYPE]  ASC,
      [CONNUM]   ASC)'

    EXEC (@COMMAND)

    SET @COMMAND = 'DROP TABLE [dbo].[CaseContacts]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TABLE 
       [dbo].[CaseContacts]
      ([CASECODE]                     [varchar](20)                                                                   NOT NULL,
       [CONTYPE]                      [varchar](12)                                                                   NOT NULL,
       [CONNUM]                       [smallint]                                                                      NOT NULL,
       [NAMECODE]                     [varchar](6)                                                                        NULL,
       [SOLCODE]                      [varchar](6)                                                                        NULL,
       [SOLREF]                       [varchar](50)                                                                       NULL,
       [INSCODE]                      [varchar](6)                                                                        NULL,
       [INSREF]                       [varchar](20)                                                                       NULL,
       [COURTRECORDNO]                [varchar](20)                                                                       NULL,
       [HEARINGDATE]                  [datetime]                                                                          NULL,
       [TIME]                         [varchar](10)                                                                       NULL,
       [Relationship]                 [varchar](40)                                                                       NULL,
       [Nominated]                    [bit]                                                                               NULL,
       [AssignedContact]              [int]                                                                               NULL,
       [ForCopy]                      [char](1)                                                                           NULL,
       [CivilSumSDate]                [datetime]                                                                          NULL,
       [CivilBillSDate]               [datetime]                                                                          NULL,
       [SSumSDate]                    [datetime]                                                                          NULL,
       [InstOrdSDate]                 [datetime]                                                                          NULL,
       [ComOrdSDate]                  [datetime]                                                                          NULL,
       [WarrantIssDate]               [datetime]                                                                          NULL,
       [SumAttSerDate]                [datetime]                                                                          NULL,
       [PUBLISH]                      [char](1)                                                                           NULL,
       [FileNum]                      [int]             CONSTRAINT [DF_CaseContacts_FileNum] DEFAULT 0                NOT NULL,
       CONSTRAINT [PK_CaseContacts]
                  PRIMARY KEY CLUSTERED 
                 ([CASECODE] ASC,
                  [CONTYPE] ASC,
                  [CONNUM] ASC)
               ON [PRIMARY]) ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'INSERT
  INTO [dbo].[CaseContacts]
      ([CASECODE],
       [CONTYPE],
       [CONNUM],
       [NAMECODE],
       [SOLCODE],
       [SOLREF],
       [INSCODE],
       [INSREF],
       [COURTRECORDNO],
       [HEARINGDATE],
       [TIME],
       [Relationship],
       [Nominated],
       [AssignedContact],
       [ForCopy])
SELECT RTRIM(ISNULL(CTX.[CASECODE], '''')),
       RTRIM(ISNULL(CTX.[CONTYPE], '''')),
       RTRIM(ISNULL(CTX.[CONNUM], '''')),
       RTRIM(CTX.[NAMECODE]),
       RTRIM(CTX.[SOLCODE]),
       RTRIM(CTX.[SOLREF]),
       RTRIM(CTX.[INSCODE]),
       RTRIM(CTX.[INSREF]),
       RTRIM(CTX.[COURTRECORDNO]),
       CTX.[HEARINGDATE],
       RTRIM(CTX.[TIME]),
       RTRIM(CTX.[Relationship]),
       CTX.[Nominated],
       CONVERT(INT, CTX.[AssignedContact]),
       CTX.[ForCopy]
  FROM [dbo].[FIXCAC] CTX'

    EXEC (@COMMAND)

    -- New Column "PUBLISH"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'PUBLISH'
        WHERE SO.[name] = 'FIXCAC'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAC
     SET CAC.[PUBLISH] = CTX.[PUBLISH]
    FROM [dbo].[CaseContacts] CAC
         INNER JOIN [dbo].[FIXCAC] CTX
                 ON CTX.[CASECODE] = CAC.[CASECODE]
                AND CTX.[CONTYPE] = CAC.[CONTYPE]
                AND CTX.[CONNUM] = CAC.[CONNUM]'

        EXEC (@COMMAND)
      END

    -- New Column "CivilSumSDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CivilSumSDate'
        WHERE SO.[name] = 'FIXCAC'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAC
     SET CAC.[CivilSumSDate] = CTX.[CivilSumSDate]
    FROM [dbo].[CaseContacts] CAC
         INNER JOIN [dbo].[FIXCAC] CTX
                 ON CTX.[CASECODE] = CAC.[CASECODE]
                AND CTX.[CONTYPE] = CAC.[CONTYPE]
                AND CTX.[CONNUM] = CAC.[CONNUM]'

        EXEC (@COMMAND)
      END

    -- New Column "CivilBillSDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CivilBillSDate'
        WHERE SO.[name] = 'FIXCAC'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAC
     SET CAC.[CivilBillSDate] = CTX.[CivilBillSDate]
    FROM [dbo].[CaseContacts] CAC
         INNER JOIN [dbo].[FIXCAC] CTX
                 ON CTX.[CASECODE] = CAC.[CASECODE]
                AND CTX.[CONTYPE] = CAC.[CONTYPE]
                AND CTX.[CONNUM] = CAC.[CONNUM]'

        EXEC (@COMMAND)
      END

    -- New Column "SSumSDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'SSumSDate'
        WHERE SO.[name] = 'FIXCAC'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAC
     SET CAC.[SSumSDate] = CTX.[SSumSDate]
    FROM [dbo].[CaseContacts] CAC
         INNER JOIN [dbo].[FIXCAC] CTX
                 ON CTX.[CASECODE] = CAC.[CASECODE]
                AND CTX.[CONTYPE] = CAC.[CONTYPE]
                AND CTX.[CONNUM] = CAC.[CONNUM]'

        EXEC (@COMMAND)
      END

    -- New Column "InstOrdSDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'InstOrdSDate'
        WHERE SO.[name] = 'FIXCAC'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAC
     SET CAC.[InstOrdSDate] = CTX.[InstOrdSDate]
    FROM [dbo].[CaseContacts] CAC
         INNER JOIN [dbo].[FIXCAC] CTX
                 ON CTX.[CASECODE] = CAC.[CASECODE]
                AND CTX.[CONTYPE] = CAC.[CONTYPE]
                AND CTX.[CONNUM] = CAC.[CONNUM]'

        EXEC (@COMMAND)
      END

    -- New Column "ComOrdSDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ComOrdSDate'
        WHERE SO.[name] = 'FIXCAC'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAC
     SET CAC.[ComOrdSDate] = CTX.[ComOrdSDate]
    FROM [dbo].[CaseContacts] CAC
         INNER JOIN [dbo].[FIXCAC] CTX
                 ON CTX.[CASECODE] = CAC.[CASECODE]
                AND CTX.[CONTYPE] = CAC.[CONTYPE]
                AND CTX.[CONNUM] = CAC.[CONNUM]'

        EXEC (@COMMAND)
      END

    -- New Column "WarrantIssDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'WarrantIssDate'
        WHERE SO.[name] = 'FIXCAC'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAC
     SET CAC.[WarrantIssDate] = CTX.[WarrantIssDate]
    FROM [dbo].[CaseContacts] CAC
         INNER JOIN [dbo].[FIXCAC] CTX
                 ON CTX.[CASECODE] = CAC.[CASECODE]
                AND CTX.[CONTYPE] = CAC.[CONTYPE]
                AND CTX.[CONNUM] = CAC.[CONNUM]'

        EXEC (@COMMAND)
      END

    -- New Column "SumAttSerDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'SumAttSerDate'
        WHERE SO.[name] = 'FIXCAC'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAC
     SET CAC.[SumAttSerDate] = CTX.[SumAttSerDate]
    FROM [dbo].[CaseContacts] CAC
         INNER JOIN [dbo].[FIXCAC] CTX
                 ON CTX.[CASECODE] = CAC.[CASECODE]
                AND CTX.[CONTYPE] = CAC.[CONTYPE]
                AND CTX.[CONNUM] = CAC.[CONNUM]'

        EXEC (@COMMAND)
      END

    -- New Column "FileNum"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'FileNum'
        WHERE SO.[name] = 'FIXCAC'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAC
     SET CAC.[FileNum] = ISNULL(CTX.[FileNum], 0)
    FROM [dbo].[CaseContacts] CAC
         INNER JOIN [dbo].[FIXCAC] CTX
                 ON CTX.[CASECODE] = CAC.[CASECODE]
                AND CTX.[CONTYPE] = CAC.[CONTYPE]
                AND CTX.[CONNUM] = CAC.[CONNUM]'

        EXEC (@COMMAND)
      END

      SET @COMMAND = 'CREATE NONCLUSTERED INDEX 
       [IDX_Name]
    ON [dbo].[CaseContacts]
      ([NAMECODE] ASC,
	     [CASECODE] ASC,
	     [CONTYPE] ASC,
	     [CONNUM] ASC)
    ON [PRIMARY]'

      EXEC (@COMMAND)

      SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [KeyAssignedContacts]
    ON [dbo].[CaseContacts]
      ([AssignedContact] ASC,
	     [CASECODE] ASC,
	     [NAMECODE] ASC)
    ON [PRIMARY]'

      EXEC (@COMMAND)

      IF EXISTS
        (SELECT TOP 1 1 FROM [dbo].[CaseContacts])
        BEGIN
          SET @COMMAND = 'DROP TABLE [dbo].[FIXCAC]'

          EXEC (@COMMAND)
        END
      ELSE
        BEGIN
          IF NOT EXISTS
            (SELECT TOP 1 1 FROM [dbo].[FIXCAC])
            BEGIN
              SET @COMMAND = 'DROP TABLE [dbo].[FIXCAC]'

              EXEC (@COMMAND)
            END
        END
  END
GO

IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] [SO]
    WHERE UPPER([SO].[name]) = 'CONTACTSOLD'
      AND [SO].[type] = 'U')
  BEGIN
    EXEC ('DROP TABLE [dbo].[contactsold]')
  END
GO

DECLARE @COMMAND VARCHAR(MAX)

DECLARE @CODELEN VARCHAR(2)
DECLARE @UPDATE BIT

SET @UPDATE = 0

SELECT @CODELEN = CONVERT(VARCHAR(2), SC.[max_length])
  FROM SYS.[objects] SO
       INNER JOIN SYS.[columns] SC
               ON SC.[object_id] = SO.[object_id]
              AND SC.[name] = 'Code'
 WHERE SO.[name] = 'Contacts'
   AND SO.[type] = 'U'

IF (@CODELEN <> '10')
  BEGIN
    SET @UPDATE = 1
  END

IF (@UPDATE = 0)
  BEGIN
    IF NOT EXISTS
      (SELECT *
         FROM SYS.objects SO
              INNER JOIN sys.columns SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankName'
                     AND SC.[system_type_id] = 167
        WHERE SO.[name] = 'Contacts'
          AND SO.[type] = 'U')
      BEGIN
        SET @UPDATE = 1
      END
  END

IF (@UPDATE = 1)
  BEGIN
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
    BEGIN
      SET @COMMAND = 'DROP TABLE [dbo].[FIXCON]'

      EXEC (@COMMAND)
    END

    SET @COMMAND = 'SELECT *
  INTO [dbo].[FIXCON]
  FROM [dbo].[Contacts]'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE 
      [dbo].[FIXCON]
  ADD CONSTRAINT 
      [PK_FIXCON]
      PRIMARY KEY CLUSTERED 
     ([Code] ASC)'

    EXEC (@COMMAND)

    SET @COMMAND = 'DROP TABLE [dbo].[Contacts]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TABLE 
       [dbo].[Contacts]
      ([Code]                         [varchar](10)                                                                   NOT NULL,
       [Name]                         [varchar](80)                                                                   NOT NULL,
       [Address]                      [varchar](500)                                                                      NULL,
       [Salut]                        [varchar](20)                                                                       NULL,
       [Tel]                          [varchar](20)                                                                       NULL,
       [Fax]                          [varchar](20)                                                                       NULL,
       [email]                        [varchar](40)                                                                       NULL,
       [Principal]                    [varchar](30)                                                                       NULL,
       [FE]                           [varchar](10)                                                                       NULL,
       [Client]                       [char](1)                                                                           NULL,
       [Nation]                       [char](3)                                                                           NULL,
       [ClientGroup]                  [varchar](10)                                                                       NULL,
       [LastMatter]                   [int]                                                                               NULL,
       [OpenMatters]                  [int]                                                                               NULL,
       [StartDate]                    [datetime]       CONSTRAINT [DF_Contacts_StartDate] DEFAULT (getdate())         NOT NULL,
       [BillBal]                      [decimal](17, 2) CONSTRAINT [DF_Contacts_BillBal] DEFAULT (0)                   NOT NULL,
       [OutlayBal]                    [decimal](17, 2) CONSTRAINT [DF_Contacts_OutlayBal] DEFAULT (0)                 NOT NULL,
       [ClientCur]                    [decimal](17, 2) CONSTRAINT [DF_Contacts_ClientCur] DEFAULT (0)                 NOT NULL,
       [ClientDep]                    [decimal](17, 2) CONSTRAINT [DF_Contacts_ClientDep] DEFAULT (0)                 NOT NULL,
       [RSINo]                        [varchar](50)                                                                       NULL,
       [Spouse]                       [varchar](50)                                                                       NULL,
       [DOB]                          [datetime]                                                                          NULL,
       [SpouseDOB]                    [datetime]                                                                          NULL,
       [Introducer]                   [varchar](50)                                                                       NULL,
       [IntroFE]                      [varchar](5)                                                                        NULL,
       [Comments]                     [varchar](2000)                                                                     NULL,
       [Corporate]                    [varchar](50)                                                                       NULL,
       [Inactive]                     [char](1)                                                                           NULL,
       [DateInactive]                 [datetime]                                                                          NULL,
       [LastAR]                       [datetime]                                                                          NULL,
       [OtherAddress]                 [varchar](500)                                                                      NULL,
       [DateOfMarriage]               [datetime]                                                                          NULL,
       [SpouseDead]                   [char](1)                                                                           NULL,
       [Separated]                    [char](1)                                                                           NULL,
       [HowSeparated]                 [varchar](20)                                                                       NULL,
       [Partner]                      [varchar](30)                                                                       NULL,
       [PartnerSince]                 [datetime]                                                                          NULL,
       [Occupation]                   [varchar](20)                                                                       NULL,
       [OtherRef]                     [varchar](10)                                                                       NULL,
       [OpsisRef]                     [varchar](20)                                                                       NULL,
       [ContactNo]                    [int]                                                                               NULL,
       [CurBillBal]                   [decimal](17, 2) CONSTRAINT [DF_Contacts_CurBillBal] DEFAULT (0)                NOT NULL,
       [CurOutlayBal]                 [decimal](17, 2) CONSTRAINT [DF_Contacts_CurOutlayBal] DEFAULT (0)              NOT NULL,
       [CurClientCBal]                [decimal](17, 2) CONSTRAINT [DF_Contacts_CurClientCBal] DEFAULT (0)             NOT NULL,
       [CurClientDBal]                [decimal](17, 2) CONSTRAINT [DF_Contacts_CurClientDBal] DEFAULT (0)             NOT NULL,
       [Statements]                   [char](1)                                                                           NULL,
       [RemoteAccess]                 [char](1)                                                                           NULL,
       [Password]                     [varchar](20)                                                                       NULL,
       [CompBillOnOff]                [tinyint]                                                                           NULL,
       [CompMatter]                   [varchar](20)                                                                       NULL,
       [CompFrequency]                [char](1)                                                                           NULL,
       [CompOutlayLimit]              [decimal](17, 2) CONSTRAINT [DF_Contacts_CompOutlayLimit] DEFAULT (0)           NOT NULL,
       [CompFeesLimit]                [decimal](17, 2) CONSTRAINT [DF_Contacts_CompFeesLimit] DEFAULT (0)             NOT NULL,
       [CompTotalLimit]               [decimal](17, 2) CONSTRAINT [DF_Contacts_CompTotalLimit] DEFAULT (0)            NOT NULL,
       [ChargeArrangement]            [char](3)                                                                           NULL,
       [BillingMethod]                [char](1)                                                                           NULL,
       [Approved]                     [smallint]                                                                          NULL,
       [SpousePPS]                    [varchar](20)                                                                       NULL,
       [CompanyWebSite]               [varchar](120)                                                                      NULL,
       [ChargeOutRateInd]             [char](1)                                                                           NULL,
       --Conflict
       [CRONumber]                    varchar(20)                                                                         NULL,
       [CompanyRegNo]                 varchar(20)                                                                         NULL,
       [ClientVATNo]                  varchar(20)                                                                         NULL,
       [VATNumber]                    varchar(20)                                                                         NULL,
       --SAM3
       [TaxType]                      [varchar](3)                                                                        NULL,
       --SAM4
       [DisconDate]                   [datetime]                                                                          NULL,
       [Marketing]                    [char](1)                                                                           NULL,
       [ChargeLevel]                  [int]                                                                               NULL,
       --NEW
       [County]                       [varchar](100)                                                                      NULL,
       [PostalCode]                   [varchar](100)                                                                      NULL,
       [BankName]                     [varchar](60)                                                                       NULL,
       [BankAddress]                  [varchar](120)                                                                      NULL,
       [BankSortCode]                 [varchar](20)                                                                       NULL,
       [BankAccNo]                    [varchar](20)                                                                       NULL,
       [IBAN]                         [varchar](20)                                                                       NULL,
       [BIC]                          [varchar](20)                                                                       NULL,
       CONSTRAINT [PK_Contacts]
                  PRIMARY KEY CLUSTERED 
                 ([Code] ASC)
               ON [PRIMARY]) ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRContactsInsert]
    ON [dbo].[Contacts]
       AFTER INSERT
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE CON
         SET CON.[CRONumber] = CASE WHEN CON.[CRONumber] IS NULL
                                         THEN CON.[CompanyRegNo]
                                    ELSE CON.[CRONumber] END,
             CON.[CompanyRegNo] = CASE WHEN CON.[CRONumber] IS NULL
                                            THEN CON.[CompanyRegNo]
                                       ELSE CON.[CRONumber] END,
             CON.[ClientVATNo] = CASE WHEN CON.[ClientVATNo] IS NULL
                                           THEN CON.[VATNumber]
                                      ELSE CON.[ClientVATNo] END,
             CON.[VATNumber] = CASE WHEN CON.[ClientVATNo] IS NULL
                                         THEN CON.[VATNumber]
                                    ELSE CON.[ClientVATNo] END
        FROM inserted INS
             INNER JOIN [dbo].[Contacts] CON
                     ON CON.[Code] = INS.[Code]
       WHERE ISNULL(INS.[CRONumber], ''**NULL**'') <> ISNULL(INS.[CompanyRegNo], ''**NULL**'')
          OR ISNULL(INS.[ClientVATNo], ''**NULL**'') <> ISNULL(INS.[VATNumber], ''**NULL**'')

    END
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRContactsUpdate]
    ON [dbo].[Contacts]
       AFTER Update
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE CON
         SET CON.[CRONumber] = CASE WHEN ISNULL(INS.[CompanyRegNo], ''**NULL**'') <> ISNULL(DEL.[CompanyRegNo], ''**NULL**'') 
                                         THEN INS.[CompanyRegNo]
                                    ELSE INS.[CRONumber] END,
             CON.[CompanyRegNo] = CASE WHEN ISNULL(INS.[CRONumber], ''**NULL**'') <> ISNULL(DEL.[CRONumber], ''**NULL**'') 
                                            THEN INS.[CRONumber]
                                       ELSE INS.[CompanyRegNo] END,
             CON.[ClientVATNo] = CASE WHEN ISNULL(INS.[VATNumber], ''**NULL**'') <> ISNULL(DEL.[VATNumber], ''**NULL**'') 
                                           THEN INS.[VATNumber]
                                      ELSE INS.[ClientVATNo] END,
             CON.[VATNumber] = CASE WHEN ISNULL(INS.[ClientVATNo], ''**NULL**'') <> ISNULL(DEL.[ClientVATNo], ''**NULL**'') 
                                         THEN INS.[ClientVATNo]
                                    ELSE INS.[VATNumber] END
        FROM inserted INS
             INNER JOIN deleted DEL
                     ON DEL.[Code] = INS.[Code]
             INNER JOIN [dbo].[Contacts] CON
                     ON CON.[Code] = INS.[Code]
       WHERE ISNULL(INS.[CRONumber], ''**NULL**'') <> ISNULL(DEL.[CRONumber], ''**NULL**'')
          OR ISNULL(INS.[CompanyRegNo], ''**NULL**'') <> ISNULL(DEL.[CompanyRegNo], ''**NULL**'')
          OR ISNULL(INS.[ClientVATNo], ''**NULL**'') <> ISNULL(DEL.[ClientVATNo], ''**NULL**'')
          OR ISNULL(INS.[VATNumber], ''**NULL**'') <> ISNULL(DEL.[VATNumber], ''**NULL**'')
    END
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'INSERT
  INTO [dbo].[Contacts]
      ([Code],
       [Name],
       [Address],
       [Salut],
       [Tel],
       [Fax],
       [email],
       [Principal],
       [FE],
       [Client],
       [Nation],
       [ClientGroup],
       [LastMatter],
       [OpenMatters],
       [StartDate],
       [BillBal],
       [OutlayBal],
       [ClientCur],
       [ClientDep],
       [RSINo],
       [Spouse],
       [DOB],
       [SpouseDOB],
       [Introducer],
       [IntroFE],
       [Comments],
       [Corporate],
       [Inactive],
       [DateInactive],
       [LastAR],
       [OtherAddress],
       [DateOfMarriage],
       [SpouseDead],
       [Separated],
       [HowSeparated],
       [Partner],
       [PartnerSince],
       [Occupation],
       [OtherRef],
       [OpsisRef],
       [ContactNo],
       [CurBillBal],
       [CurOutlayBal],
       [CurClientCBal],
       [CurClientDBal],
       [Statements],
       [RemoteAccess],
       [Password],
       [CompBillOnOff],
       [CompMatter],
       [CompFrequency],
       [CompOutlayLimit],
       [CompFeesLimit],
       [CompTotalLimit],
       [ChargeArrangement],
       [BillingMethod],
       [Approved],
       [SpousePPS],
       [CompanyWebSite],
       [ChargeOutRateInd])
SELECT RTRIM(ISNULL(CTX.[Code], '''')),
       RTRIM(ISNULL(CONVERT(VARCHAR(80), CTX.[Name]), '''')),
       RTRIM(CTX.[Address]),
       RTRIM(CTX.[Salut]),
       RTRIM(CTX.[Tel]),
       RTRIM(CTX.[Fax]),
       RTRIM(CTX.[email]),
       RTRIM(CTX.[Principal]),
       RTRIM(CTX.[FE]),
       CTX.[Client],
       CTX.[Nation],
       RTRIM(CTX.[ClientGroup]),
       CTX.[LastMatter],
       CTX.[OpenMatters],
       ISNULL(CTX.[StartDate], GetDate()),
       ISNULL(CTX.[BillBal], 0),
       ISNULL(CTX.[OutlayBal], 0),
       ISNULL(CTX.[ClientCur], 0),
       ISNULL(CTX.[ClientDep], 0),
       RTRIM(CTX.[RSINo]),
       RTRIM(CTX.[Spouse]),
       CTX.[DOB],
       CTX.[SpouseDOB],
       RTRIM(CTX.[Introducer]),
       RTRIM(CTX.[IntroFE]),
       RTRIM(CTX.[Comments]),
       RTRIM(CTX.[Corporate]),
       CTX.[Inactive],
       CTX.[DateInactive],
       CTX.[LastAR],
       RTRIM(CTX.[OtherAddress]),
       CTX.[DateOfMarriage],
       CTX.[SpouseDead],
       CTX.[Separated],
       RTRIM(CTX.[HowSeparated]),
       RTRIM(CTX.[Partner]),
       CTX.[PartnerSince],
       RTRIM(CTX.[Occupation]),
       RTRIM(CTX.[OtherRef]),
       RTRIM(CTX.[OpsisRef]),
       CTX.[ContactNo],
       ISNULL(CTX.[CurBillBal], 0),
       ISNULL(CTX.[CurOutlayBal], 0),
       ISNULL(CTX.[CurClientCBal], 0),
       ISNULL(CTX.[CurClientDBal], 0),
       CTX.[Statements],
       CTX.[RemoteAccess],
       RTRIM(CTX.[Password]),
       CTX.[CompBillOnOff],
       RTRIM(CTX.[CompMatter]),
       CTX.[CompFrequency],
       ISNULL(CTX.[CompOutlayLimit], 0),
       ISNULL(CTX.[CompFeesLimit], 0),
       ISNULL(CTX.[CompTotalLimit], 0),
       CTX.[ChargeArrangement],
       CTX.[BillingMethod],
       CTX.[Approved],
       RTRIM(CTX.[SpousePPS]),
       RTRIM(CTX.[CompanyWebSite]),
       CTX.[ChargeOutRateInd]
  FROM [dbo].[FIXCON] CTX'

    EXEC (@COMMAND)

    --Conflict - Column is named "CRONumber"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CRONumber'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[CRONumber] = CTX.[CRONumber]
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --Conflict - Column is named "CompanyRegNo"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CompanyRegNo'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[CompanyRegNo] = CTX.[CompanyRegNo]
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --Conflict - Column is named "ClientVATNo"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ClientVATNo'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[ClientVATNo] = CTX.[ClientVATNo]
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --Conflict - Column is named "VATNumber"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'VATNumber'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[VATNumber] = CTX.[VATNumber]
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "TaxType"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'TaxType'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[TaxType] = CTX.[TaxType]
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "DisconDate"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'DisconDate'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[DisconDate] = CTX.[DisconDate]
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "Marketing"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Marketing'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[Marketing] = CTX.[Marketing]
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "ChargeLevel"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ChargeLevel'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[ChargeLevel] = CTX.[ChargeLevel]
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "County"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'County'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[County] = RTRIM(CONVERT(VARCHAR(100), CTX.[County]))
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "PostalCode"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'PostalCode'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[PostalCode] = RTRIM(CONVERT(VARCHAR(100), CTX.[PostalCode]))
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankName"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankName'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BankName] = RTRIM(CONVERT(VARCHAR(60), CTX.[BankName]))
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankAddress"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankAddress'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BankAddress] = RTRIM(CONVERT(VARCHAR(120), CTX.[BankAddress]))
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankSortCode"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankSortCode'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BankSortCode] = RTRIM(CONVERT(VARCHAR(20), CTX.[BankSortCode]))
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankAccNo"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankAccNo'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BankAccNo] = RTRIM(CONVERT(VARCHAR(20), CTX.[BankAccNo]))
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "IBAN"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'IBAN'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[IBAN] = RTRIM(CONVERT(VARCHAR(20), CTX.[IBAN]))
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BIC"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BIC'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BIC] = RTRIM(CONVERT(VARCHAR(20), CTX.[BIC]))
    FROM [dbo].[Contacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

      IF EXISTS
        (SELECT TOP 1 1 FROM [dbo].[Contacts])
        BEGIN
          SET @COMMAND = 'DROP TABLE [dbo].[FIXCON]'

          EXEC (@COMMAND)
        END
      ELSE
        BEGIN
          IF NOT EXISTS
            (SELECT TOP 1 1 FROM [dbo].[FIXCON])
            BEGIN
              SET @COMMAND = 'DROP TABLE [dbo].[FIXCON]'

              EXEC (@COMMAND)
            END
        END
  END
GO

DECLARE @COMMAND VARCHAR(MAX)

DECLARE @CODELEN VARCHAR(2)
DECLARE @UPDATE BIT

SET @UPDATE = 0

SELECT @CODELEN = CONVERT(VARCHAR(2), SC.[max_length])
  FROM SYS.[objects] SO
       INNER JOIN SYS.[columns] SC
               ON SC.[object_id] = SO.[object_id]
              AND SC.[name] = 'Code'
 WHERE SO.[name] = 'ClientContacts'
   AND SO.[type] = 'U'

IF (@CODELEN <> '10')
  BEGIN
    SET @UPDATE = 1
  END

IF (@UPDATE = 0)
  BEGIN
    IF NOT EXISTS
      (SELECT *
         FROM SYS.objects SO
              INNER JOIN sys.columns SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankName'
                     AND SC.[system_type_id] = 167
        WHERE SO.[name] = 'ClientContacts'
          AND SO.[type] = 'U')
      BEGIN
        SET @UPDATE = 1
      END
  END

IF (@UPDATE = 1)
  BEGIN
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
    BEGIN
      SET @COMMAND = 'DROP TABLE [dbo].[FIXCON]'

      EXEC (@COMMAND)
    END

    SET @COMMAND = 'SELECT *
  INTO [dbo].[FIXCON]
  FROM [dbo].[ClientContacts]'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE 
      [dbo].[FIXCON]
  ADD CONSTRAINT 
      [PK_FIXCON]
      PRIMARY KEY CLUSTERED 
     ([CLCODE] ASC,
      [CLNUMCONTACT] ASC)'

    EXEC (@COMMAND)

    SET @COMMAND = 'DROP TABLE [dbo].[ClientContacts]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TABLE 
       [dbo].[ClientContacts]
      ([CLCODE]                       [varchar](8)                                                                    NOT NULL,
       [CLNUMCONTACT]                 [smallint]                                                                      NOT NULL,
       [CLTITLE]                      [varchar](10)                                                                       NULL,
       [CLINITS]                      [varchar](5)                                                                        NULL,
       [CLNAMECON]                    [varchar](35)                                                                       NULL,
       [CLSALUTE]                     [varchar](30)                                                                       NULL,
       [CLSSNUMBER]                   [varchar](15)                                                                       NULL,
       [FIRSTNAME]                    [varchar](20)                                                                       NULL,
       [SURNAME]                      [varchar](20)                                                                       NULL,
       [Address]                      [varchar](200)                                                                      NULL,
       [HomePhone]                    [varchar](30)                                                                       NULL,
       [WorkPhone]                    [varchar](30)                                                                       NULL,
       [Mobile]                       [varchar](30)                                                                       NULL,
       [EmailAddress]                 [varchar](100)                                                                      NULL,
       [PPSNo]                        [varchar](20)                                                                       NULL,
       [Dob]                          [datetime]                                                                          NULL,
       [MarrigeDate]                  [datetime]                                                                          NULL,
       [Occupation]                   [varchar](100)                                                                      NULL,
       [DateofDeath]                  [datetime]                                                                          NULL,
       [MartialStatus]                [char](3)                                                                           NULL,
	     [Marketing]                    [char](1)                                                                           NULL,
       [County]                       [varchar](100)                                                                      NULL,
       [PostalCode]                   [varchar](100)                                                                      NULL,
       [FaxNumber]                    [varchar](30)                                                                       NULL,
       [BankName]                     [varchar](60)                                                                       NULL,
       [BankAddress]                  [varchar](120)                                                                      NULL,
       [BankSortCode]                 [varchar](20)                                                                       NULL,
       [BankAccNo]                    [varchar](20)                                                                       NULL,
       [IBAN]                         [varchar](20)                                                                       NULL,
       [BIC]                          [varchar](20)                                                                       NULL,
       CONSTRAINT [PK_ClientContacts]
                  PRIMARY KEY CLUSTERED 
                 ([CLCODE] ASC,
                  [CLNUMCONTACT] ASC)
               ON [PRIMARY])
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'INSERT
  INTO [dbo].[ClientContacts]
      ([CLCODE],
       [CLNUMCONTACT],
       [CLTITLE],
       [CLINITS],
       [CLNAMECON],
       [CLSALUTE],
       [CLSSNUMBER],
       [FIRSTNAME],
       [SURNAME],
       [Address],
       [HomePhone],
       [WorkPhone],
       [Mobile],
       [EmailAddress],
       [PPSNo],
       [Dob],
       [MarrigeDate],
       [Occupation],
       [DateofDeath],
       [MartialStatus])
SELECT RTRIM(ISNULL([CLCODE], '''')),
       ISNULL([CLNUMCONTACT], 0),
       RTRIM([CLTITLE]),
       RTRIM([CLINITS]),
       RTRIM([CLNAMECON]),
       RTRIM([CLSALUTE]),
       RTRIM([CLSSNUMBER]),
       RTRIM([FIRSTNAME]),
       RTRIM([SURNAME]),
       RTRIM([Address]),
       RTRIM([HomePhone]),
       RTRIM([WorkPhone]),
       RTRIM([Mobile]),
       RTRIM([EmailAddress]),
       RTRIM([PPSNo]),
       [Dob],
       [MarrigeDate],
       RTRIM([Occupation]),
       [DateofDeath],
       [MartialStatus]
  FROM [dbo].[FIXCON] CTX'

    EXEC (@COMMAND)

    --SAM4 - Column is named "Marketing"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Marketing'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[Marketing] = CTX.[Marketing]
    FROM [dbo].[ClientContacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CLCODE] = CON.[CLCODE]
                AND CTX.[CLNUMCONTACT] = CON.[CLNUMCONTACT]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "County"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'County'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[County] = RTRIM(CONVERT(VARCHAR(100), CTX.[County]))
    FROM [dbo].[ClientContacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CLCODE] = CON.[CLCODE]
                AND CTX.[CLNUMCONTACT] = CON.[CLNUMCONTACT]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "PostalCode"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'PostalCode'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[PostalCode] = RTRIM(CONVERT(VARCHAR(100), CTX.[PostalCode]))
    FROM [dbo].[ClientContacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CLCODE] = CON.[CLCODE]
                AND CTX.[CLNUMCONTACT] = CON.[CLNUMCONTACT]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "FaxNumber"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'FaxNumber'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[FaxNumber] = RTRIM(CONVERT(VARCHAR(30), CTX.[FaxNumber]))
    FROM [dbo].[ClientContacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CLCODE] = CON.[CLCODE]
                AND CTX.[CLNUMCONTACT] = CON.[CLNUMCONTACT]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankName"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankName'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BankName] = RTRIM(CONVERT(VARCHAR(60), CTX.[BankName]))
    FROM [dbo].[ClientContacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CLCODE] = CON.[CLCODE]
                AND CTX.[CLNUMCONTACT] = CON.[CLNUMCONTACT]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankAddress"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankAddress'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BankAddress] = RTRIM(CONVERT(VARCHAR(120), CTX.[BankAddress]))
    FROM [dbo].[ClientContacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CLCODE] = CON.[CLCODE]
                AND CTX.[CLNUMCONTACT] = CON.[CLNUMCONTACT]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankSortCode"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankSortCode'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BankSortCode] = RTRIM(CONVERT(VARCHAR(20), CTX.[BankSortCode]))
    FROM [dbo].[ClientContacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CLCODE] = CON.[CLCODE]
                AND CTX.[CLNUMCONTACT] = CON.[CLNUMCONTACT]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankAccNo"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankAccNo'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BankAccNo] = RTRIM(CONVERT(VARCHAR(20), CTX.[BankAccNo]))
    FROM [dbo].[ClientContacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CLCODE] = CON.[CLCODE]
                AND CTX.[CLNUMCONTACT] = CON.[CLNUMCONTACT]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "IBAN"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'IBAN'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[IBAN] = RTRIM(CONVERT(VARCHAR(20), CTX.[IBAN]))
    FROM [dbo].[ClientContacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CLCODE] = CON.[CLCODE]
                AND CTX.[CLNUMCONTACT] = CON.[CLNUMCONTACT]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BIC"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BIC'
        WHERE SO.[name] = 'FIXCON'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BIC] = RTRIM(CONVERT(VARCHAR(20), CTX.[BIC]))
    FROM [dbo].[ClientContacts] CON
         INNER JOIN [dbo].[FIXCON] CTX
                 ON CTX.[CLCODE] = CON.[CLCODE]
                AND CTX.[CLNUMCONTACT] = CON.[CLNUMCONTACT]'

        EXEC (@COMMAND)
      END

      IF EXISTS
        (SELECT TOP 1 1 FROM [dbo].[ClientContacts])
        BEGIN
          SET @COMMAND = 'DROP TABLE [dbo].[FIXCON]'

          EXEC (@COMMAND)
        END
      ELSE
        BEGIN
          IF NOT EXISTS
            (SELECT TOP 1 1 FROM [dbo].[FIXCON])
            BEGIN
              SET @COMMAND = 'DROP TABLE [dbo].[FIXCON]'

              EXEC (@COMMAND)
            END
        END
  END
GO

DECLARE @COMMAND VARCHAR(MAX)

IF NOT EXISTS
  (SELECT * 
     FROM SYS.[objects] SO
          INNER JOIN SYS.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                 AND SC.[name] = 'CRONumber'
          INNER JOIN SYS.[columns] SC2
                  ON SC2.[object_id] = SO.[object_id]
                 AND SC2.[name] = 'CompanyRegNo'
          INNER JOIN SYS.[columns] SC3
                  ON SC3.[object_id] = SO.[object_id]
                 AND SC3.[name] = 'Retired'
          INNER JOIN SYS.[columns] SC4
                  ON SC4.[object_id] = SO.[object_id]
                 AND SC4.[name] = 'BankName'
                 AND SC4.[system_type_id] = 167
    WHERE SO.[name] = 'CaseAssociatesNames'
      AND SO.[type] = 'U')
  BEGIN
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
    BEGIN
      SET @COMMAND = 'DROP TABLE [dbo].[FIXCAN]'

      EXEC (@COMMAND)
    END

    SET @COMMAND = 'SELECT *
  INTO [dbo].[FIXCAN]
  FROM [dbo].[CaseAssociatesNames]'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE 
      [dbo].[FIXCAN]
  ADD CONSTRAINT 
      [PK_FIXCAN]
      PRIMARY KEY CLUSTERED 
     ([CODE] ASC)'

    EXEC (@COMMAND)

    SET @COMMAND = 'DROP TABLE [dbo].[CaseAssociatesNames]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TABLE 
       [dbo].[CaseAssociatesNames]
      ([CODE]                 [varchar](6)    NOT NULL,
       [TYPE]                 [varchar](12)       NULL,
       [NAME]                 [varchar](80)       NULL,
       [SALUTATION]           [varchar](30)       NULL,
       [TITLE]                [varchar](50)       NULL,
       [COMPANY]              [varchar](80)       NULL,
       [ADDRESS]              [varchar](200)      NULL,
       [FORENAME]             [varchar](30)       NULL,
       [SURNAME]              [varchar](40)       NULL,
       [PHONENO]              [varchar](20)       NULL,
       [FAXNO]                [varchar](20)       NULL,
       [HOME]                 [varchar](20)       NULL,
       [MOBILENO]             [varchar](20)       NULL,
       [EMAIL]                [varchar](100)      NULL,
       [WEBADDRESS]           [varchar](150)      NULL,
       [SSNUMBER]             [varchar](20)       NULL,
       [LEGALNAME]            [varchar](150)      NULL,
       [LEGALADDRESS]         [varchar](200)      NULL,
       [COURTNO]              [smallint]          NULL,
       [COURTAREA]            [varchar](50)       NULL,
       [TAX]                  [char](1)           NULL,
       [DXREF]                [varchar](30)       NULL,
       [DOB]                  [datetime]          NULL,
       [MARTIALSTATUS]        [varchar](20)       NULL,
       [MARRIAGEDATE]         [datetime]          NULL,
       [DECEASED]             [char](1)           NULL,
       [SEPARATED]            [char](3)           NULL,
       [HOWSEPARATED]         [varchar](10)       NULL,
       [DATESEPARATED]        [datetime]          NULL,
       [DECEASEDDATE]         [datetime]          NULL,
       [OCCUPATION]           [varchar](100)      NULL,
       [SEARCH]               [varchar](10)       NULL,
       [CONTACTNO]            [decimal](9, 0)     NULL,
       [NOTES]                [varchar](6000)     NULL,
       [Area]                 [varchar](15)       NULL,
       [Town]                 [varchar](20)       NULL,
       [Gender]               [varchar](20)       NULL,
       [VATNumber]            [varchar](20)       NULL,
       --Conflict
       [CRONumber]            [varchar](20)       NULL,
       [CompanyRegNo]         [varchar](20)       NULL,
       --SAM3
       [AddressType]          [char](1)           NULL,
       [ServiceType]          [char](1)           NULL,
       --SAM4
       [Marketing]            [char](1)           NULL,
       [CompanyWebSite]       [varchar](120)      NULL,
       [AssociateGroup]       [int]               NULL,
       [Retired]              [char](1)           NULL,
       --NEW
       [County]               [varchar](100)      NULL,
       [PostalCode]           [varchar](100)      NULL,
       [BankName]             [varchar](60)       NULL,
       [BankAddress]          [varchar](120)      NULL,
       [BankSortCode]         [varchar](20)       NULL,
       [BankAccNo]            [varchar](20)       NULL,
       [IBAN]                 [varchar](20)       NULL,
       [BIC]                  [varchar](20)       NULL,
       CONSTRAINT [PK_CaseAssociatesNames]
                  PRIMARY KEY CLUSTERED 
                 ([CODE] ASC)
               ON [PRIMARY]) ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRCaseAssociatesNamesInsert]
    ON [dbo].[CaseAssociatesNames]
       AFTER INSERT
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE CAN
         SET CAN.[CRONumber] = CASE WHEN CAN.[CRONumber] IS NULL
                                         THEN CAN.[CompanyRegNo]
                                    ELSE CAN.[CRONumber] END,
             CAN.[CompanyRegNo] = CASE WHEN CAN.[CRONumber] IS NULL
                                            THEN CAN.[CompanyRegNo]
                                       ELSE CAN.[CRONumber] END
        FROM inserted INS
             INNER JOIN [dbo].[CaseAssociatesNames] CAN
                     ON CAN.[CODE] = INS.[CODE]
       WHERE ISNULL(INS.[CRONumber], ''**NULL**'') <> ISNULL(INS.[CompanyRegNo], ''**NULL**'')

    END
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRCaseAssociatesNamesUpdate]
    ON [dbo].[CaseAssociatesNames]
       AFTER Update
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE CAN
         SET CAN.[CRONumber] = CASE WHEN ISNULL(INS.[CompanyRegNo], ''**NULL**'') <> ISNULL(DEL.[CompanyRegNo], ''**NULL**'') 
                                         THEN INS.[CompanyRegNo]
                                    ELSE INS.[CRONumber] END,
             CAN.[CompanyRegNo] = CASE WHEN ISNULL(INS.[CRONumber], ''**NULL**'') <> ISNULL(DEL.[CRONumber], ''**NULL**'') 
                                            THEN INS.[CRONumber]
                                       ELSE INS.[CompanyRegNo] END
        FROM inserted INS
             INNER JOIN deleted DEL
                     ON DEL.[CODE] = INS.[CODE]
             INNER JOIN [dbo].[CaseAssociatesNames] CAN
                     ON CAN.[CODE] = INS.[CODE]
       WHERE ISNULL(INS.[CRONumber], ''**NULL**'') <> ISNULL(DEL.[CRONumber], ''**NULL**'')
          OR ISNULL(INS.[CompanyRegNo], ''**NULL**'') <> ISNULL(DEL.[CompanyRegNo], ''**NULL**'')
    END
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'INSERT
  INTO [dbo].[CaseAssociatesNames]
      ([CODE],
       [TYPE],
       [NAME],
       [SALUTATION],
       [TITLE],
       [COMPANY],
       [ADDRESS],
       [FORENAME],
       [SURNAME],
       [PHONENO],
       [FAXNO],
       [HOME],
       [MOBILENO],
       [EMAIL],
       [WEBADDRESS],
       [SSNUMBER],
       [LEGALNAME],
       [LEGALADDRESS],
       [COURTNO],
       [COURTAREA],
       [TAX],
       [DXREF],
       [DOB],
       [MARTIALSTATUS],
       [MARRIAGEDATE],
       [DECEASED],
       [SEPARATED],
       [HOWSEPARATED],
       [DATESEPARATED],
       [DECEASEDDATE],
       [OCCUPATION],
       [SEARCH],
       [CONTACTNO],
       [NOTES],
       [Area],
       [Town],
       [Gender],
       [VATNumber])
SELECT RTRIM(ISNULL(CTX.[CODE], '''')),
       RTRIM(CTX.[TYPE]),
       RTRIM(CTX.[NAME]),
       RTRIM(CTX.[SALUTATION]),
       RTRIM(CTX.[TITLE]),
       RTRIM(CTX.[COMPANY]),
       RTRIM(CTX.[ADDRESS]),
       RTRIM(CTX.[FORENAME]),
       RTRIM(CTX.[SURNAME]),
       RTRIM(CTX.[PHONENO]),
       RTRIM(CTX.[FAXNO]),
       RTRIM(CTX.[HOME]),
       RTRIM(CTX.[MOBILENO]),
       RTRIM(CTX.[EMAIL]),
       RTRIM(CTX.[WEBADDRESS]),
       RTRIM(CTX.[SSNUMBER]),
       RTRIM(CTX.[LEGALNAME]),
       RTRIM(CTX.[LEGALADDRESS]),
       CTX.[COURTNO],
       RTRIM(CTX.[COURTAREA]),
       CTX.[TAX],
       RTRIM(CTX.[DXREF]),
       CTX.[DOB],
       RTRIM(CTX.[MARTIALSTATUS]),
       CTX.[MARRIAGEDATE],
       CTX.[DECEASED],
       CTX.[SEPARATED],
       RTRIM(CTX.[HOWSEPARATED]),
       CTX.[DATESEPARATED],
       CTX.[DECEASEDDATE],
       RTRIM(CTX.[OCCUPATION]),
       RTRIM(CTX.[SEARCH]),
       CTX.[CONTACTNO],
       RTRIM(CTX.[NOTES]),
       RTRIM(CTX.[Area]),
       RTRIM(CTX.[Town]),
       RTRIM(CTX.[Gender]),
       RTRIM(CTX.[VATNumber])
  FROM [dbo].[FIXCAN] CTX'

    EXEC (@COMMAND)

    --Conflict - Column is named "CRONumber"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CRONumber'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[CRONumber] = CTX.[CRONumber]
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --Conflict - Column is named "CompanyRegNo"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CompanyRegNo'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[CompanyRegNo] = CTX.[CompanyRegNo]
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "AddressType"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'AddressType'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[AddressType] = CTX.[AddressType]
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "ServiceType"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ServiceType'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[ServiceType] = CTX.[ServiceType]
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "Marketing"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Marketing'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[Marketing] = CTX.[Marketing]
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "CompanyWebSite"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'CompanyWebSite'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[CompanyWebSite] = RTRIM(CTX.[CompanyWebSite])
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "AssociateGroup"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'AssociateGroup'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[AssociateGroup] = CTX.[AssociateGroup]
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "Retired"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Retired'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[Retired] = CTX.[Retired]
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "County"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'County'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[County] = RTRIM(CONVERT(VARCHAR(100), CTX.[County]))
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "PostalCode"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'PostalCode'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[PostalCode] = RTRIM(CONVERT(VARCHAR(100), CTX.[PostalCode]))
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankName"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankName'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[BankName] = RTRIM(CONVERT(VARCHAR(60), CTX.[BankName]))
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankAddress"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankAddress'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[BankAddress] = RTRIM(CONVERT(VARCHAR(120), CTX.[BankAddress]))
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankSortCode"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankSortCode'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[BankSortCode] = RTRIM(CONVERT(VARCHAR(20), CTX.[BankSortCode]))
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankAccNo"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankAccNo'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[BankAccNo] = RTRIM(CONVERT(VARCHAR(20), CTX.[BankAccNo]))
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "IBAN"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'IBAN'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[IBAN] = RTRIM(CONVERT(VARCHAR(20), CTX.[IBAN]))
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BIC"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BIC'
        WHERE SO.[name] = 'FIXCAN'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAN
     SET CAN.[BIC] = RTRIM(CONVERT(VARCHAR(20), CTX.[BIC]))
    FROM [dbo].[CaseAssociatesNames] CAN
         INNER JOIN [dbo].[FIXCAN] CTX
                 ON CTX.[CODE] = CAN.[CODE]'

        EXEC (@COMMAND)
      END

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [KeyNo]
    ON [dbo].[CaseAssociatesNames]
      ([CONTACTNO] ASC)
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [KeySearch]
    ON [dbo].[CaseAssociatesNames]
      ([SEARCH] ASC)
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [KeyType]
    ON [dbo].[CaseAssociatesNames]
      ([TYPE] ASC,
	     [CODE] ASC)
    ON [PRIMARY]'

    EXEC (@COMMAND)

      IF EXISTS
        (SELECT TOP 1 1 FROM [dbo].[CaseAssociatesNames])
        BEGIN
          SET @COMMAND = 'DROP TABLE [dbo].[FIXCAN]'

          EXEC (@COMMAND)
        END
      ELSE
        BEGIN
          IF NOT EXISTS
            (SELECT TOP 1 1 FROM [dbo].[FIXCAN])
            BEGIN
              SET @COMMAND = 'DROP TABLE [dbo].[FIXCAN]'

              EXEC (@COMMAND)
            END
        END
  END
GO

DECLARE @FixCAC BIT

SET @FixCAC = 0

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'CaseAssociatesContacts'
      AND SO.[type] = 'U')
  BEGIN
    IF NOT EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[indexes] SI
                      ON SI.[object_id] = SO.[object_id]
                     AND SI.[name] = 'PK_CaseAssociatesContacts'
        WHERE SO.[name] = 'CaseAssociatesContacts'
          AND SO.[type] = 'U')
      BEGIN
        SET @FixCAC = 1
      END

    IF NOT EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Retired'
        WHERE SO.[name] = 'CaseAssociatesContacts'
          AND SO.[type] = 'U')
      BEGIN
        SET @FixCAC = 1
      END
  END

IF @FixCAC = 1
  BEGIN
    SELECT * INTO [dbo].[CACFIX] FROM [dbo].[CaseAssociatesContacts] 
        
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'ALTER TABLE 
      [dbo].[CACFIX]
  ADD CONSTRAINT 
      [PK_CACFIX]
      PRIMARY KEY CLUSTERED 
     ([KEYID] ASC)'

    EXEC (@COMMAND)

    SET @COMMAND = 'DROP TABLE [dbo].[CaseAssociatesContacts]'

    EXEC (@COMMAND)

    SET @COMMAND = '
    CREATE TABLE 
            [dbo].[CaseAssociatesContacts]
           ([KEYID]                [int]            IDENTITY(1,1)     NOT NULL,
            [NAMECODE]             [varchar](6)                       NOT NULL,
            [NAME]                 [varchar](100)                     NOT NULL,
            [SALUTATION]           [varchar](100)                         NULL,
            [JOBTITLE]             [varchar](100)                         NULL,
            [ADDRESS]              [varchar](200)                         NULL,
            [PHONE]                [varchar](30)                          NULL,
            [FAX]                  [varchar](30)                          NULL,
            [MOBILE]               [varchar](30)                          NULL,
            [EMAIL]                [varchar](100)                         NULL,
            [RELATIONSHIP]         [varchar](20)                          NULL,
            [NOTES]                [varchar](200)                         NULL,
            [COUNTY]               [varchar](100)                         NULL,
            [POSTALCODE]           [varchar](30)                          NULL,
            [Retired]              [char](1)                              NULL,
            CONSTRAINT [PK_CaseAssociatesContacts]
                      PRIMARY KEY CLUSTERED 
                      ([KEYID] ASC)
                    ON [PRIMARY])
        ON [PRIMARY]'                

    EXEC (@COMMAND)

    SET @COMMAND = '
    SET IDENTITY_INSERT [dbo].[CaseAssociatesContacts] ON

    INSERT
      INTO [dbo].[CaseAssociatesContacts]
          ([KEYID],
           [NAMECODE],
           [NAME],
           [SALUTATION],
           [JOBTITLE],
           [ADDRESS],
           [PHONE],
           [FAX],
           [MOBILE],
           [EMAIL],
           [RELATIONSHIP],
           [NOTES])
    SELECT [KEYID],
           RTRIM(ISNULL([NAMECODE], '''')),
           RTRIM(ISNULL([NAME], '''')),
           RTRIM([SALUTATION]),
           RTRIM([JOBTITLE]),
           RTRIM([ADDRESS]),
           RTRIM([PHONE]),
           RTRIM([FAX]),
           RTRIM([MOBILE]),
           RTRIM([EMAIL]),
           RTRIM([RELATIONSHIP]),
           RTRIM([NOTES])
      FROM [dbo].[CACFIX] CAX
    
    SET IDENTITY_INSERT [dbo].[CaseAssociatesContacts] OFF

    DECLARE @maxVal INT
    SELECT @maxVal = ISNULL(max([KEYID]),0)+1 from [dbo].[CaseAssociatesContacts]
    DBCC CHECKIDENT(''CaseAssociatesContacts'', RESEED, @maxVal)'

    EXEC (@COMMAND)

    --Column is named "Retired"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Retired'
        WHERE SO.[name] = 'CACFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAC
     SET CAC.[Retired] = CAX.[Retired]
    FROM [dbo].[CaseAssociatesContacts] CAC
         INNER JOIN [dbo].[CACFIX] CAX
                 ON CAX.[KEYID] = CAC.[KEYID]'

        EXEC (@COMMAND)
      END

    --Column is named "County"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'County'
        WHERE SO.[name] = 'CACFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAC
     SET CAC.[County] = CONVERT(VARCHAR(100), CAX.[County])
    FROM [dbo].[CaseAssociatesContacts] CAC
         INNER JOIN [dbo].[CACFIX] CAX
                 ON CAX.[KEYID] = CAC.[KEYID]'

        EXEC (@COMMAND)
      END

    --Column is named "PostalCode"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'PostalCode'
        WHERE SO.[name] = 'CACFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CAC
     SET CAC.[PostalCode] = CONVERT(VARCHAR(100), CAX.[PostalCode])
    FROM [dbo].[CaseAssociatesContacts] CAC
         INNER JOIN [dbo].[CACFIX] CAX
                 ON CAX.[KEYID] = CAC.[KEYID]'

        EXEC (@COMMAND)
      END

    SET @COMMAND = '
    CREATE UNIQUE NONCLUSTERED INDEX 
           [UQ_CaseAssociatesContacts]
        ON [dbo].[CaseAssociatesContacts]
          ([NAMECODE]     ASC,
           [KEYID]        ASC)
        ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = '
    CREATE UNIQUE NONCLUSTERED INDEX 
           [CACode]
        ON [dbo].[CaseAssociatesContacts]
          ([KEYID]        ASC,
           [NAMECODE]     ASC)
        ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = '
    CREATE NONCLUSTERED INDEX
           [CAMail]
        ON [dbo].[CaseAssociatesContacts]
          ([EMAIL]        ASC,
           [KEYID]        ASC)
        ON [PRIMARY]'

    EXEC (@COMMAND)

    IF EXISTS
      (SELECT TOP 1 1 FROM [dbo].[CaseAssociatesContacts])
      BEGIN
        SET @COMMAND = 'DROP TABLE [dbo].[CACFIX]'

        EXEC (@COMMAND)
      END
    ELSE
      BEGIN
        IF NOT EXISTS
          (SELECT TOP 1 1 FROM [dbo].[CACFIX])
          BEGIN
            SET @COMMAND = 'DROP TABLE [dbo].[CACFIX]'

            EXEC (@COMMAND)
          END
      END


  END
GO


DECLARE @COMMAND VARCHAR(MAX)

IF NOT EXISTS
  (SELECT * 
     FROM SYS.[objects] SO
          INNER JOIN SYS.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                AND SC.[name] = 'CLASSDESCRIPTION'
                AND SC.[system_type_id] = 167
          INNER JOIN SYS.[columns] SC2
                  ON SC2.[object_id] = SO.[object_id]
                 AND SC2.[name] = 'Retired'
    WHERE SO.[name] = 'DocumentClasses'
      AND SO.[type] = 'U')
  BEGIN
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
        WHERE SO.[name] = 'FIXDCL'
          AND SO.[type] = 'U')
    BEGIN
      SET @COMMAND = 'DROP TABLE [dbo].[FIXDCL]'

      EXEC (@COMMAND)
    END

    SET @COMMAND = 'SELECT *
  INTO [dbo].[FIXDCL]
  FROM [dbo].[DocumentClasses]'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE 
      [dbo].[FIXDCL]
  ADD CONSTRAINT 
      [PK_FIXDCL]
      PRIMARY KEY CLUSTERED 
     ([CLASSCODE] ASC)'

    EXEC (@COMMAND)

    SET @COMMAND = 'DROP TABLE [dbo].[DocumentClasses]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TABLE 
       [dbo].[DocumentClasses]
      ([CLASSCODE]            [char](3)                                                                                    NOT NULL,
       [CLASSDESCRIPTION]     [varchar](40)  CONSTRAINT [DF_DocumentClasses_CLASSDESCRIPTION] DEFAULT ''''                 NOT NULL,
       [Retired]              [char](1)      CONSTRAINT [CS_DocumentClasses_Retired] CHECK ([Retired] IN (''Y'', ''N''))
                                             CONSTRAINT [DF_DocumentClasses_Retired] DEFAULT ''N''                         NOT NULL,
       CONSTRAINT [PK_DocumentClasses]
                  PRIMARY KEY CLUSTERED 
                 ([CLASSCODE] ASC)
               ON [PRIMARY]) ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = '  INSERT
  INTO [dbo].[DocumentClasses]
      ([CLASSCODE],
       [CLASSDESCRIPTION])
SELECT RTRIM(ISNULL(DCX.[CLASSCODE], '''')),
       RTRIM(ISNULL(DCX.[CLASSDESCRIPTION], ''''))
  FROM [dbo].[FIXDCL] DCX'

    EXEC (@COMMAND)

    --SAM3 - Column is named "Retired"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Retired'
        WHERE SO.[name] = 'FIXDCL'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE DCL
     SET DCL.[Retired] = CASE WHEN DCX.[Retired] = ''Y'' THEN ''Y'' ELSE ''N'' END
    FROM [dbo].[DocumentClasses] DCL
         INNER JOIN [dbo].[FIXDCL] DCX
                 ON DCX.[CLASSCODE] = DCL.[CLASSCODE]'

        EXEC (@COMMAND)
      END

      IF EXISTS
        (SELECT TOP 1 1 FROM [dbo].[DocumentClasses])
        BEGIN
          SET @COMMAND = 'DROP TABLE [dbo].[FIXDCL]'

          EXEC (@COMMAND)
        END
      ELSE
        BEGIN
          IF NOT EXISTS
            (SELECT TOP 1 1 FROM [dbo].[FIXDCL])
            BEGIN
              SET @COMMAND = 'DROP TABLE [dbo].[FIXDCL]'

              EXEC (@COMMAND)
            END
        END
  END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'DiaryAttachments'
      AND SO.[type] = 'U')
IF NOT EXISTS
  (select TOP 1 1
     from sys.[objects] SO
          INNER JOIN sys.[sysconstraints] SC
                     INNER JOIN sys.[objects] SOC
                             ON SOC.[object_id] = SC.[constid]
                            AND SOC.[name] = 'DF_DiaryAttachments_ARCHPATH'
                  ON SC.[id] = SO.[object_id]
          INNER JOIN sys.[columns] SCL
                  ON SCL.[object_id] = SO.[object_id]
                 AND SCL.[name] = 'OutlaySupplier'
          INNER JOIN sys.[columns] SCL2
                  ON SCL2.[object_id] = SO.[object_id]
                 AND SCL2.[name] = 'CASECODE'
                 AND SCL2.[system_type_id] = 167
                 AND SCL2.[max_length] = 20
    WHERE SO.[name] = 'DiaryAttachments')
  BEGIN
    -- the FIXED DiaryAttachments table will contain:
    --    - A CASECODE column defined as VARCHAR(20)
    --    - An OutlaySupplier column defined as int
    --    - A default constraint named DF_DiaryAttachments_ARCHPATH
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = ''DATFIX''
      AND SO.[type] = ''U'')
BEGIN
  DROP TABLE [dbo].[DATFIX]
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'SELECT *
  INTO [dbo].[DATFIX]
  FROM [dbo].[DiaryAttachments]'
    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE 
      [dbo].[DATFIX]
  ADD CONSTRAINT 
      [PK_DATFIX]
      PRIMARY KEY CLUSTERED 
     ([TrackReference] ASC)'
    EXEC (@COMMAND)

    SET @COMMAND = 'IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = ''DiaryAttachments''
      AND SO.[type] = ''U'')
BEGIN
  DROP TABLE [dbo].[DiaryAttachments]
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TABLE
       [dbo].[DiaryAttachments]
      ([TrackReference]                  INT                                                                                                  NOT NULL,
       [DiaryID]                         INT                                                                                                  NOT NULL,
       [CASECODE]                        VARCHAR(20)                                                                                          NOT NULL,
       [NAME]                            VARCHAR(10)                                                                                          NOT NULL,
       [DOCUMENT]                        VARCHAR(100)    CONSTRAINT [DF_DiaryAttachments_DOCUMENT] DEFAULT ''''                                 NOT NULL,
       [FILEPATH]                        VARCHAR(255)    CONSTRAINT [DF_DiaryAttachments_FILEPATH] DEFAULT ''''                                 NOT NULL,
       [TYPE]                            VARCHAR(10)     CONSTRAINT [DF_DiaryAttachments_TYPE] DEFAULT ''''                                     NOT NULL,
       [DOCCLASS]                        VARCHAR(10)     CONSTRAINT [DF_DiaryAttachments_DOCCLASS] DEFAULT ''''                                 NOT NULL,
       [DATEENTERED]                     datetime                                                                                             NOT NULL,
       [ENTEREDBY]                       VARCHAR(8)      CONSTRAINT [DF_DiaryAttachments_ENTEREDBY] DEFAULT ''''                                NOT NULL,
       [LASTACCESSDATE]                  datetime                                                                                                 NULL,
       [LASTACCESSBY]                    VARCHAR(8)      CONSTRAINT [DF_DiaryAttachments_LASTACCESSBY] DEFAULT ''''                             NOT NULL,
       [SYSTEM]                          CHAR(1)                                                                                                  NULL,
       [DICTATIONFILE]                   VARCHAR(255)                                                                                             NULL,
       [SOURCE]                          VARCHAR(20)                                                                                              NULL,
       [Fees]                            int             CONSTRAINT [DF_DiaryAttachments_Fees] DEFAULT 0                                      NOT NULL,
       [Outlay]                          int             CONSTRAINT [DF_DiaryAttachments_Outlay] DEFAULT 0                                    NOT NULL,
       [OutlaySupplier]                  int                                                                                                      NULL,
       [ARCHPATH]                        VARCHAR(255)    CONSTRAINT [DF_DiaryAttachments_ARCHPATH] DEFAULT ''''                                 NOT NULL,
       CONSTRAINT [PK_DiaryAttachments] 
                  PRIMARY KEY CLUSTERED 
                 ([TrackReference] ASC))'

    EXEC (@COMMAND)

    SET @COMMAND = 'INSERT
  INTO [dbo].[DiaryAttachments]
      ([TrackReference],
       [DiaryID],
       [CASECODE],
       [NAME],
       [DOCUMENT],
       [FILEPATH],
       [TYPE],
       [DOCCLASS],
       [DATEENTERED],
       [ENTEREDBY],
       [LASTACCESSDATE],
       [LASTACCESSBY],
       [SYSTEM],
       [DICTATIONFILE],
       [SOURCE])
SELECT DATX.[TrackReference],
       DATX.[DiaryID],
       RTRIM(ISNULL(DATX.[CASECODE], '''')),
       RTRIM(ISNULL(DATX.[NAME], '''')),
       RTRIM(ISNULL(DATX.[DOCUMENT], '''')),
       RTRIM(ISNULL(DATX.[FILEPATH], '''')),
       RTRIM(ISNULL(DATX.[TYPE], '''')),
       RTRIM(ISNULL(DATX.[DOCCLASS], '''')),
       ISNULL(DATX.[DATEENTERED], ''19000101''),
       RTRIM(ISNULL(DATX.[ENTEREDBY], '''')),
       DATX.[LASTACCESSDATE],
       RTRIM(ISNULL(DATX.[LASTACCESSBY], '''')),
       DATX.[SYSTEM],
       RTRIM(DATX.[DICTATIONFILE]),
       RTRIM(DATX.[SOURCE])
  FROM [dbo].[DATFIX] DATX'

    EXEC (@COMMAND)

    --SAM3 - Column is named "Fees"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Fees'
        WHERE SO.[name] = 'DATFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE DAT
     SET DAT.[Fees] = ISNULL(DATX.[Fees], 0)
    FROM [dbo].[DiaryAttachments] DAT
         INNER JOIN [dbo].[DATFIX] DATX
                 ON DATX.[TrackReference] = DAT.[TrackReference]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "Outlay"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Outlay'
        WHERE SO.[name] = 'DATFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE DAT
     SET DAT.[Outlay] = ISNULL(DATX.[Outlay], 0)
    FROM [dbo].[DiaryAttachments] DAT
         INNER JOIN [dbo].[DATFIX] DATX
                 ON DATX.[TrackReference] = DAT.[TrackReference]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "OutlaySupplier"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'OutlaySupplier'
        WHERE SO.[name] = 'DATFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE DAT
     SET DAT.[OutlaySupplier] = DATX.[OutlaySupplier]
    FROM [dbo].[DiaryAttachments] DAT
         INNER JOIN [dbo].[DATFIX] DATX
                 ON DATX.[TrackReference] = DAT.[TrackReference]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "ARCHPATH"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ARCHPATH'
        WHERE SO.[name] = 'DATFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE DAT
     SET DAT.[ARCHPATH] = RTRIM(ISNULL(DATX.[ARCHPATH], ''''))
    FROM [dbo].[DiaryAttachments] DAT
         INNER JOIN [dbo].[DATFIX] DATX
                 ON DATX.[TrackReference] = DAT.[TrackReference]'

        EXEC (@COMMAND)
      END

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX 
       [IX_DiaryAttachments] 
    ON [dbo].[DiaryAttachments]
      ([DIARYID] ASC,
	     [TRACKREFERENCE] ASC)
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX 
       [KeyCaseCode]
    ON [dbo].[DiaryAttachments]
      ([CASECODE] ASC,
       [TRACKREFERENCE] ASC)
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [KeyDocClass]
    ON [dbo].[DiaryAttachments]
      ([DOCCLASS] ASC)
       INCLUDE ([NAME],
                [DOCUMENT],
                [TYPE])
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [KeyDocument]
    ON [dbo].[DiaryAttachments]
      ([DOCUMENT] ASC,
       [DIARYID] ASC)
       INCLUDE ([NAME],
                [DOCCLASS],
                [TYPE])
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [KeyName]
    ON [dbo].[DiaryAttachments]
      ([NAME] ASC,
       [DIARYID] ASC)
       INCLUDE ([DOCUMENT],
                [DOCCLASS],
                [TYPE])
    ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE NONCLUSTERED INDEX
       [KeyType]
    ON [dbo].[DiaryAttachments]
      ([TYPE] ASC,
       [DIARYID] ASC)
       INCLUDE ([DOCUMENT],
                [DOCCLASS],
                [NAME])
    ON [PRIMARY]'

    EXEC (@COMMAND)

    IF EXISTS
      (SELECT TOP 1 1 FROM [dbo].[DiaryAttachments])
      BEGIN
        SET @COMMAND = 'DROP TABLE [dbo].[DATFIX]'

        EXEC (@COMMAND)
      END
    ELSE
      BEGIN
        IF NOT EXISTS
          (SELECT TOP 1 1 FROM [dbo].[DATFIX])
          BEGIN
            SET @COMMAND = 'DROP TABLE [dbo].[DATFIX]'

            EXEC (@COMMAND)
          END
      END


  END
GO

/****** Object:  Table [dbo].[BGControl]    Script Date: 12/11/2014 09:30:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BGControl]') AND type in (N'U'))
BEGIN
CREATE TABLE 
       [dbo].[BGControl]
      ([ID]          [int]          NOT NULL,
       [Date]        [datetime]     NOT NULL,
       [TDate]       [datetime]     NOT NULL,
       [ODate]       [datetime]     NOT NULL,
       [Description] [varchar](255) NOT NULL,
       [DRAFTNO]     [int]          NOT NULL,
       [BATCHNO]     [int]          NOT NULL,
       [ADDRESSEE]   [varchar](400) NOT NULL,
       [OURREF]      [varchar](15)  NOT NULL,
       [YOURREF]     [varchar](20)  NOT NULL,
       [MATTER]      [varchar](17)  NOT NULL,
       [IsAdhoc]     [int]          NOT NULL DEFAULT ((0)),
       [OAmount]     [money]        NOT NULL DEFAULT ((0)),
       [TAmount]     [money]        NOT NULL DEFAULT ((0)),
       CONSTRAINT [PK_BGControl] 
                  PRIMARY KEY CLUSTERED 
                 ([ID] ASC)
               ON [PRIMARY])
    ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[BGDetail]    Script Date: 12/11/2014 09:30:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BGDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE 
       [dbo].[BGDetail]
      ([ID]               [uniqueidentifier]  NOT NULL,
       [IncludeInBill]    [int]               NOT NULL,
       [Seqno]            [int]               NOT NULL,
       [BGGroupID]        [uniqueidentifier]  NOT NULL,
       [BGControlID]      [int]               NOT NULL,
       [Type]             [varchar](1)        NOT NULL,
       [Matter]           [varchar](11)           NULL,
       [FEEEARN]          [varchar](5)            NULL,
       [OUTLAYCODE]       [varchar](10)           NULL,
       [DATE]             [datetime]          NOT NULL,
       [Narrative]        [varchar](1000)         NULL,
       [InvoiceNo]        [int]               NOT NULL,
       [Charge]           [decimal](19, 2)    NOT NULL,
       [BilledAmount]     [decimal](19, 2)    NOT NULL,
       [BillNow]          [decimal](19, 2)    NOT NULL,
       [OriginalID]       [int]               NOT NULL,
       [ORGInvoiceNo]     [int]                   NULL,
       [ORGIncludeInBill] [int]                   NULL,
       [ORGBILLINGDATE]   [datetime]              NULL,
       [ORGBILLINGYEAR]   [int]                   NULL,
       [ORGBILLINGPERIOD] [int]                   NULL,
       [ORGAMOUNT]        [decimal](17, 2)        NULL,
       [PaidNow]          [decimal](19, 2)    NOT NULL DEFAULT ((0)),
       CONSTRAINT [PK_BGDetail]
                  PRIMARY KEY CLUSTERED 
                 ([ID] ASC)
               ON [PRIMARY])
    ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[BGGroups]    Script Date: 12/11/2014 09:30:53 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BGGroups]') AND type in (N'U'))
BEGIN
CREATE TABLE 
       [dbo].[BGGroups]
      ([ID]          [uniqueidentifier] NOT NULL,
       [SeqNo]       [int]              NOT NULL,
       [BGControlID] [int]              NOT NULL,
       [Narrative]   [varchar](1000)        NULL,
       CONSTRAINT [PK_BGGroups]
                  PRIMARY KEY CLUSTERED 
                 ([ID] ASC)
               ON [PRIMARY])
    ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Index [BGControlBatches]    Script Date: 12/11/2014 09:30:53 ******/
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BGControl]') AND name = N'BGControlBatches')
CREATE NONCLUSTERED INDEX
       [BGControlBatches]
    ON [dbo].[BGControl]
      ([BATCHNO] ASC,
       [ID] ASC)
    ON [PRIMARY]
GO
/****** Object:  Index [BGControlDrafts]    Script Date: 12/11/2014 09:30:53 ******/
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BGControl]') AND name = N'BGControlDrafts')
CREATE NONCLUSTERED INDEX 
       [BGControlDrafts]
    ON [dbo].[BGControl]
      ([DRAFTNO] ASC,
       [ID] ASC)
    ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
/****** Object:  Index [BGDetailByMatter]    Script Date: 12/11/2014 09:30:53 ******/
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BGDetail]') AND name = N'BGDetailByMatter')
CREATE NONCLUSTERED INDEX
       [BGDetailByMatter]
    ON [dbo].[BGDetail]
      ([Matter] ASC,
       [BGControlID] ASC,
       [Type] ASC,
       [ID] ASC)
    ON [PRIMARY]
GO
/****** Object:  Index [BGDetailGroups]    Script Date: 12/11/2014 09:30:53 ******/
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BGDetail]') AND name = N'BGDetailGroups')
CREATE NONCLUSTERED INDEX
       [BGDetailGroups]
    ON [dbo].[BGDetail]
      ([BGGroupID] ASC,
       [Seqno] ASC,
       [ID] ASC)
    ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BGDetail_BGControl]') AND parent_object_id = OBJECT_ID(N'[dbo].[BGDetail]'))
ALTER TABLE 
      [dbo].[BGDetail] 
 WITH CHECK 
  ADD CONSTRAINT [FK_BGDetail_BGControl] 
                 FOREIGN KEY
                ([BGControlID])
                 REFERENCES 
                 [dbo].[BGControl] 
                ([ID])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BGDetail_BGControl]') AND parent_object_id = OBJECT_ID(N'[dbo].[BGDetail]'))
ALTER TABLE 
      [dbo].[BGDetail] 
CHECK CONSTRAINT 
      [FK_BGDetail_BGControl]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BGDetail_BGGroups]') AND parent_object_id = OBJECT_ID(N'[dbo].[BGDetail]'))
ALTER TABLE 
      [dbo].[BGDetail]
 WITH CHECK 
  ADD CONSTRAINT [FK_BGDetail_BGGroups]
                 FOREIGN KEY
                ([BGGroupID])
                 REFERENCES 
                 [dbo].[BGGroups]
                ([ID])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BGDetail_BGGroups]') AND parent_object_id = OBJECT_ID(N'[dbo].[BGDetail]'))
ALTER TABLE
      [dbo].[BGDetail] 
CHECK CONSTRAINT 
      [FK_BGDetail_BGGroups]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BGGroups_BGControl]') AND parent_object_id = OBJECT_ID(N'[dbo].[BGGroups]'))
ALTER TABLE
      [dbo].[BGGroups]
 WITH CHECK 
  ADD CONSTRAINT 
      [FK_BGGroups_BGControl]
      FOREIGN KEY
     ([BGControlID])
      REFERENCES
      [dbo].[BGControl] 
     ([ID])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_BGGroups_BGControl]') AND parent_object_id = OBJECT_ID(N'[dbo].[BGGroups]'))
ALTER TABLE 
      [dbo].[BGGroups]
CHECK CONSTRAINT 
      [FK_BGGroups_BGControl]
GO

DECLARE @COMMAND VARCHAR(MAX)
DECLARE @FIXHB BIT

SET @FIXHB = 0
SET NOCOUNT ON

IF NOT EXISTS
  (SELECT *
     FROM sys.[objects] SO
          INNER JOIN sys.[objects] SO2
                  ON SO2.[name] = 'FeBudgets'
                 AND SO2.[type] = 'U'
    WHERE SO.[name] = 'HandlerBudgets'
      AND SO.[type] = 'U')
  BEGIN
    SET @FIXHB = 1
  END

IF (@FIXHB = 1)
  BEGIN
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
        WHERE SO.[name] = 'FIXHB'
          AND SO.[type] = 'U')
    BEGIN
      SET @COMMAND = 'DROP TABLE [dbo].[FIXHB]'

      EXEC (@COMMAND)
    END
  END

IF (@FIXHB = 1)
  BEGIN
    IF [dbo].[ISSAM4]() = 0
      BEGIN
        IF EXISTS
          (SELECT *
             FROM SYS.[objects] SO
            WHERE SO.[name] = 'HandlerBudgets'
              AND SO.[type] = 'U')
          BEGIN
            SET @COMMAND = '
              SELECT CONVERT(VARCHAR(10), RTRIM([Handler]))             AS [Handler],
                     CONVERT(int, [Year])                               AS [Year],
                     CONVERT(int, [Month])                              AS [Month],
                     CONVERT(DECIMAL(18, 2), [FeesBudget])              AS [FeesBudget],
                     CONVERT(DECIMAL(18, 2), [ChargableTimeBudget])     AS [TimeBudget],
                     CONVERT(DECIMAL(18, 2), [NonChargableTimeBudget])  AS [FreeBudget]
                INTO [dbo].[FIXHB]
                FROM [dbo].[HandlerBudgets]'
          END
      END
    ELSE
      BEGIN
        IF EXISTS
          (SELECT *
             FROM SYS.[objects] SO
            WHERE SO.[name] = 'FeBudgets'
              AND SO.[type] = 'U')
          BEGIN
            SET @COMMAND = '
              SELECT CONVERT(VARCHAR(10), RTRIM([FeCode]))              AS [Handler],
                     CONVERT(int, [Year])                               AS [Year],
                     CONVERT(int, [Period])                             AS [Month],
                     CONVERT(DECIMAL(18, 2), [BudgetFees])              AS [FeesBudget],
                     CONVERT(DECIMAL(18, 2), [BudgetHours])             AS [TimeBudget],
                     CONVERT(DECIMAL(18, 2), [NonBillable])             AS [FreeBudget]
                INTO [dbo].[FIXHB]
                FROM [dbo].[FeBudgets]'
          END
      END

    EXEC (@COMMAND)
  END

SET NOCOUNT OFF

GO

SET NOCOUNT ON

DECLARE @COMMAND VARCHAR(MAX)
DECLARE @FIXHB BIT

SET @FIXHB = 0

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'FIXHB'
      AND SO.[type] = 'U')
BEGIN
  SET @FIXHB = 1
END

IF (@FIXHB = 1)
  BEGIN
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
        WHERE SO.[name] = 'HandlerBudgets'
          AND SO.[type] = 'U')
      BEGIN
        SET @COMMAND = 'DROP TABLE [dbo].[HandlerBudgets]'

        EXEC (@COMMAND)
      END

    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
        WHERE SO.[name] = 'FeBudgets'
          AND SO.[type] = 'U')
      BEGIN
        SET @COMMAND = 'DROP TABLE [dbo].[FeBudgets]'

        EXEC (@COMMAND)
      END

    SET @COMMAND = '
    CREATE
     TABLE [dbo].[HandlerBudgets]
          ([Id]                      [int]            IDENTITY(1,1)                                                       NOT NULL,
           [Handler]                 [varchar](10)                                                                        NOT NULL,
           [Year]                    [int]                                                                                NOT NULL,
           [Month]                   [int]                                                                                NOT NULL,
           [FeesBudget]              [decimal](18, 2) CONSTRAINT [DF_HandlerBudgets_FeesBudget] DEFAULT (0)               NOT NULL,
           [ChargableTimeBudget]     [decimal](18, 2) CONSTRAINT [DF_HandlerBudgets_ChargableTimeBudget] DEFAULT (0)      NOT NULL,
           [NonChargableTimeBudget]  [decimal](18, 2) CONSTRAINT [DF_HandlerBudgets_NonChargableTimeBudget] DEFAULT (0)   NOT NULL,
           CONSTRAINT [PK_HandlerBudgets] 
                      PRIMARY KEY CLUSTERED
                     ([Id]    ASC)
                   ON [PRIMARY])
        ON [PRIMARY]'
    EXEC (@COMMAND)

    SET @COMMAND = '
    CREATE UNIQUE NONCLUSTERED INDEX 
           [IX_HandlerBudgets]
        ON [dbo].[HandlerBudgets]
          ([Handler]      ASC,
           [Year]         ASC,
           [Month]        ASC)
        ON [PRIMARY]'
    EXEC (@COMMAND)

    SET @COMMAND = '
    CREATE TABLE 
           [dbo].[FeBudgets]
          ([FeCode]                    [varchar](5) NOT NULL,
           [Year]        [int]                                                                           NOT NULL,
           [Period]      [int]                                                                           NOT NULL,
           [BudgetFees]  [decimal](18, 2) CONSTRAINT [DF_FeBudgets_BudgetFees] DEFAULT (0)               NOT NULL,
           [BudgetHours] [decimal](18, 2) CONSTRAINT [DF_FeBudgets_BudgetHours] DEFAULT (0)              NOT NULL,
           [NonBillable] [decimal](18, 2) CONSTRAINT [DF_FeBudgets_NonBillable] DEFAULT (0)              NOT NULL,
           CONSTRAINT [PK_FeBudgets] 
                      PRIMARY KEY CLUSTERED 
                     ([FeCode]   ASC,
                      [Year]     ASC,
                      [Period]   ASC)
                   ON [PRIMARY])
        ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = '
    CREATE TRIGGER
           [dbo].[ky_NETTRHandlerBudgetsInsert]
        ON [dbo].[HandlerBudgets]
           AFTER INSERT, UPDATE
    AS
    BEGIN
      IF ((SELECT TRIGGER_NESTLEVEL()) < 3)
        BEGIN

          INSERT
            INTO [dbo].[FeBudgets]
                ([FeCode],
                 [Year],
                 [Period],
                 [BudgetFees],
                 [BudgetHours],
                 [NonBillable])
          SELECT INS.[Handler],
                 INS.[Year],
                 INS.[Month],
                 INS.[FeesBudget],
                 INS.[ChargableTimeBudget],
                 INS.[NonChargableTimeBudget]
            FROM inserted INS
                 LEFT OUTER JOIN [dbo].[FeBudgets] FEB
                              ON FEB.[FeCode] = INS.[Handler]
                             AND FEB.[Year] = INS.[Year]
                             AND FEB.[Period] = INS.[Month]
           WHERE FEB.[FeCode] IS NULL

          UPDATE FEB
             SET FEB.[BudgetFees] = INS.[FeesBudget],
                 FEB.[BudgetHours] = INS.[ChargableTimeBudget],
                 FEB.[NonBillable] = INS.[NonChargableTimeBudget]
            FROM inserted INS
                 INNER JOIN [dbo].[FeBudgets] FEB
                         ON FEB.[FeCode] = INS.[Handler]
                        AND FEB.[Year] = INS.[Year]
                        AND FEB.[Period] = INS.[Month]
                        AND (   FEB.[BudgetFees] <> INS.[FeesBudget]
                             OR FEB.[BudgetHours] <> INS.[ChargableTimeBudget]
                             OR FEB.[NonBillable] <> INS.[NonChargableTimeBudget])

        END
    END'

    EXEC (@COMMAND)

    SET @COMMAND = '
    CREATE TRIGGER
           [dbo].[ky_NETTRHandlerBudgetsDelete]
        ON [dbo].[HandlerBudgets]
           AFTER DELETE
    AS
    BEGIN
      IF ((SELECT TRIGGER_NESTLEVEL()) < 3)
        BEGIN

          DELETE FEB
            FROM deleted DEL
                 INNER JOIN [dbo].[FeBudgets] FEB
                         ON FEB.[FeCode] = DEL.[Handler]
                        AND FEB.[Year] = DEL.[Year]
                        AND FEB.[Period] = DEL.[Month]

        END
    END'

    EXEC (@COMMAND)

    SET @COMMAND = '
    CREATE TRIGGER
           [dbo].[ky_NETTRFeBudgetsInsert]
        ON [dbo].[FeBudgets]
           AFTER INSERT, UPDATE
    AS
    BEGIN
      IF ((SELECT TRIGGER_NESTLEVEL()) < 3)
        BEGIN

          INSERT
            INTO [dbo].[HandlerBudgets]
                ([Handler],
                 [Year],
                 [Month],
                 [FeesBudget],
                 [ChargableTimeBudget],
                 [NonChargableTimeBudget])
          SELECT INS.[FeCode],
                 INS.[Year],
                 INS.[Period],
                 INS.[BudgetFees],
                 INS.[BudgetHours],
                 INS.[NonBillable]
            FROM inserted INS
                 LEFT OUTER JOIN [dbo].[HandlerBudgets] HAB
                              ON HAB.[Handler] = INS.[FeCode]
                             AND HAB.[Year] = INS.[Year]
                             AND HAB.[Month] = INS.[Period]
           WHERE HAB.[Handler] IS NULL

          UPDATE HAB
             SET HAB.[FeesBudget] = INS.[BudgetFees],
                 HAB.[ChargableTimeBudget] = INS.[BudgetHours],
                 HAB.[NonChargableTimeBudget] = INS.[NonBillable]
            FROM inserted INS
                 INNER JOIN [dbo].[HandlerBudgets] HAB
                         ON HAB.[Handler] = INS.[FeCode]
                        AND HAB.[Year] = INS.[Year]
                        AND HAB.[Month] = INS.[Period]
                        AND (   HAB.[FeesBudget] <> INS.[BudgetFees]
                             OR HAB.[ChargableTimeBudget] <> INS.[BudgetHours]
                             OR HAB.[NonChargableTimeBudget] <> INS.[NonBillable])

        END
    END'

    EXEC (@COMMAND)

    SET @COMMAND = '
    CREATE TRIGGER
           [dbo].[ky_NETTRFeBudgetsDelete]
        ON [dbo].[FeBudgets]
           AFTER DELETE
    AS
    BEGIN
      IF ((SELECT TRIGGER_NESTLEVEL()) < 3)
        BEGIN

          DELETE HAB
            FROM deleted DEL
                 INNER JOIN [dbo].[HandlerBudgets] HAB
                         ON HAB.[Handler] = DEL.[FeCode]
                        AND HAB.[Year] = DEL.[Year]
                        AND HAB.[Month] = DEL.[Period]

        END
    END'

    EXEC (@COMMAND)

    SET @COMMAND = '
    INSERT
      INTO [dbo].[HandlerBudgets]
          ([Handler],
           [Year],
           [Month],
           [FeesBudget],
           [ChargableTimeBudget],
           [NonChargableTimeBudget])
    SELECT FHB.[Handler],
           FHB.[Year],
           FHB.[Month],
           FHB.[FeesBudget],
           FHB.[TimeBudget],
           FHB.[FreeBudget]
      FROM [dbo].[FIXHB] FHB'

    EXEC (@COMMAND)

    SET @COMMAND = 'DROP TABLE [dbo].[FIXHB]'

    EXEC (@COMMAND)
  END

SET NOCOUNT OFF

GO

IF NOT EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'TaxType'
      AND SO.[type] = 'U')
BEGIN
  CREATE TABLE 
         [dbo].[TaxType]
        ([TaxType]              [varchar](3)     NOT NULL,
	       [TaxDesc]              [varchar](40)    NOT NULL,
         CONSTRAINT [PK_TaxType]
                    PRIMARY KEY CLUSTERED 
                   ([TaxType] ASC)
                 ON [PRIMARY])
      ON [PRIMARY]

  INSERT [dbo].[TaxType] ([TaxType], [TaxDesc]) VALUES ('CAT', 'Capital Acquisitions Tax')

  INSERT [dbo].[TaxType] ([TaxType], [TaxDesc]) VALUES ('CGT', 'Capital Gains Tax')

  INSERT [dbo].[TaxType] ([TaxType], [TaxDesc]) VALUES ('CT', 'Corporation Tax')

  INSERT [dbo].[TaxType] ([TaxType], [TaxDesc]) VALUES ('INC', 'Income')

  INSERT [dbo].[TaxType] ([TaxType], [TaxDesc]) VALUES ('PAY', 'PAYE')

  INSERT [dbo].[TaxType] ([TaxType], [TaxDesc]) VALUES ('SMP', 'Stamp Duty')

  INSERT [dbo].[TaxType] ([TaxType], [TaxDesc]) VALUES ('VAT', 'Value Added Tax')

END

GO

IF EXISTS
  (SELECT SC.*
     FROM sys.[objects] SO
          INNER JOIN sys.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                 AND SC.[name] = 'BillDescriptions'
                 AND SC.[system_type_id] <> 167
    WHERE SO.[name] = 'BillDescriptions'
      AND SO.[type] = 'U')
BEGIN
  DECLARE @COMMAND VARCHAR(MAX)
  SET @COMMAND = '
  SELECT *
    INTO [dbo].[FIXBDSC]
    FROM [dbo].[BillDescriptions]'
  EXEC (@COMMAND)
END
GO

IF EXISTS
  (SELECT SC.*
     FROM sys.[objects] SO
          INNER JOIN sys.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                 AND SC.[name] = 'BillDescriptions'
                 AND SC.[system_type_id] <> 167
    WHERE SO.[name] = 'BillDescriptions'
      AND SO.[type] = 'U')
BEGIN
  DECLARE @COMMAND VARCHAR(MAX)
  SET @COMMAND = 'DROP TABLE [dbo].[BillDescriptions]'
  EXEC (@COMMAND)
END
GO

IF NOT EXISTS
  (SELECT *
     FROM sys.[objects] SO
    WHERE SO.[name] = 'BillDescriptions'
      AND SO.[type] = 'U')
BEGIN
  CREATE TABLE
         [dbo].[BillDescriptions]
        ([NUMBER]           [int]               IDENTITY(1,1) NOT NULL,
         [BILLDESCRIPTIONS] [varchar](max)                        NULL,
         [SEARCHFIELD]      [char](20)                            NULL,
         CONSTRAINT [PK_BillDescriptions]
                    PRIMARY KEY CLUSTERED 
                   ([NUMBER] ASC)
                 ON [PRIMARY])
      ON [PRIMARY] 
         TEXTIMAGE_ON [PRIMARY]

END
GO

IF NOT EXISTS
  (SELECT SI.*
     FROM sys.[objects] SO
          INNER JOIN sys.[indexes] SI
                  ON SI.[object_id] = SO.[object_id]
                 AND SI.[name] = 'KeySearch'
    WHERE SO.[name] = 'BillDescriptions'
      AND SO.[type] = 'U')
BEGIN
  CREATE NONCLUSTERED INDEX 
         [KeySearch]
      ON [dbo].[BillDescriptions]
        ([SEARCHFIELD] ASC)
      ON [PRIMARY]
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'FIXBDSC'
      AND SO.[type] = 'U')
  BEGIN
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = '
    SET IDENTITY_INSERT [dbo].[BillDescriptions] ON

    INSERT
      INTO [dbo].[BillDescriptions]
          ([NUMBER],
           [BILLDESCRIPTIONS],
           [SEARCHFIELD])
    SELECT [NUMBER],
           RTRIM(ISNULL(CONVERT(VARCHAR(MAX), [BILLDESCRIPTIONS]), '''')),
           [SEARCHFIELD]
      FROM [dbo].[FIXBDSC]

    SET IDENTITY_INSERT [dbo].[BillDescriptions] OFF

    DECLARE @maxVal INT
    SELECT @maxVal = ISNULL(max([NUMBER]),0)+1 from [dbo].[BillDescriptions]
    DBCC CHECKIDENT(''BillDescriptions'', RESEED, @maxVal)'

    EXEC (@COMMAND)

    SET @COMMAND = 'DROP TABLE [dbo].[FIXBDSC]'

    EXEC (@COMMAND)
  END
GO

IF NOT EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ReserveLedger'
      AND SO.[type] = 'U')
  BEGIN
    CREATE TABLE 
           [dbo].[ReserveLedger]
          ([Id]                     [int]                  IDENTITY(1,1) NOT NULL,
           [MatterCode]             [varchar](20)                        NOT NULL,
           [CreatedDate]            [datetime]                           NOT NULL,
           [AppUser]                [varchar](50)                            NULL,
           [GeneralDamages]         [decimal](18, 2)                         NULL,
           [GeneralComment]         [varchar](300)                           NULL,
           [SpecialDamages]         [decimal](18, 2)                         NULL,
           [SpecialComment]         [varchar](300)                           NULL,
           [FutureSpecials]         [decimal](18, 2)                         NULL,
           [FurtureComment]         [varchar](300)                           NULL,
           [PropertyDamage]         [decimal](18, 2)                         NULL,
           [PropertyComment]        [varchar](300)                           NULL,
           [OtherDamages]           [decimal](18, 2)                         NULL,
           [OtherComment]           [varchar](300)                           NULL,
           [ContributoryNegligence] [decimal](18, 2)                         NULL,
           [ContributoryComment]    [varchar](300)                           NULL,
           [CoDefendantLiability]   [decimal](18, 2)                         NULL,
           [CoDefendantComment]     [varchar](300)                           NULL,
           [Costs]                  [decimal](18, 2)                         NULL,
           [CostsComment]           [varchar](300)                           NULL,
           CONSTRAINT [PK_LitReserve]
                      PRIMARY KEY CLUSTERED 
                     ([Id] ASC)
                   ON [PRIMARY])
        ON [PRIMARY]
  END
GO

IF NOT EXISTS
  (SELECT *
     FROM SYS.[objects] SO
          INNER JOIN sys.[indexes] SI
                  ON SI.[object_id] = SO.[object_id]
                 AND SI.[name] = 'IX_LitReserve'
    WHERE SO.[name] = 'ReserveLedger'
      AND SO.[type] = 'U')
  BEGIN
    CREATE NONCLUSTERED INDEX 
           [IX_LitReserve] 
        ON [dbo].[ReserveLedger]
          ([MatterCode] ASC,
           [Id] ASC)
  END
GO

DECLARE @FixNC BIT

SET @FixNC = 0

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'NationCodes'
      AND SO.[type] = 'U')
  BEGIN
    IF NOT EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[indexes] SI
                      ON SI.[object_id] = SO.[object_id]
                     AND SI.[name] = 'PK_NationCodes'
        WHERE SO.[name] = 'NationCodes'
          AND SO.[type] = 'U')
      BEGIN
        SET @FixNC = 1
      END

    IF NOT EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'EU'
        WHERE SO.[name] = 'NationCodes'
          AND SO.[type] = 'U')
      BEGIN
        SET @FixNC = 1
      END
  END

IF @FixNC = 1
  BEGIN
    SELECT * INTO [dbo].[NACFIX] FROM [dbo].[NationCodes] 
        
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'DROP TABLE [dbo].[NationCodes]'

    EXEC (@COMMAND)

    SET @COMMAND = '
    CREATE TABLE 
            [dbo].[NationCodes]
           ([NATION]               [char](3)                          NOT NULL,
            [DESC]                 [varchar](20)                      NOT NULL,
            [EU]                   [int]                                  NULL,
            CONSTRAINT [PK_NationCodes]
                      PRIMARY KEY CLUSTERED 
                      ([NATION] ASC)
                    ON [PRIMARY])
        ON [PRIMARY]'                

    EXEC (@COMMAND)

    SET @COMMAND = '
    INSERT
      INTO [dbo].[NationCodes]
          ([NATION],
           [DESC])
    SELECT RTRIM([NATION]),
           RTRIM([DESC])
      FROM [dbo].[NACFIX] NAX'

    EXEC (@COMMAND)

    --Column is named "EU"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'EU'
        WHERE SO.[name] = 'NACFIX'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE NAC
     SET NAC.[EU] = NAX.[EU]
    FROM [dbo].[NationCodes] NAC
         INNER JOIN [dbo].[NACFIX] NAX
                 ON NAX.[NATION] = NAC.[NATION]'

        EXEC (@COMMAND)
      END

    IF EXISTS
      (SELECT TOP 1 1 FROM [dbo].[NationCodes])
      BEGIN
        SET @COMMAND = 'DROP TABLE [dbo].[NACFIX]'

        EXEC (@COMMAND)
      END
    ELSE
      BEGIN
        IF NOT EXISTS
          (SELECT TOP 1 1 FROM [dbo].[NACFIX])
          BEGIN
            SET @COMMAND = 'DROP TABLE [dbo].[NACFIX]'

            EXEC (@COMMAND)
          END
      END


  END
GO

DECLARE @COMMAND VARCHAR(MAX)

DECLARE @CODELEN VARCHAR(2)
DECLARE @UPDATE BIT

SET @UPDATE = 0

SELECT @CODELEN = CONVERT(VARCHAR(2), SC.[max_length])
  FROM SYS.[objects] SO
       INNER JOIN SYS.[columns] SC
               ON SC.[object_id] = SO.[object_id]
              AND SC.[name] = 'Code'
 WHERE SO.[name] = 'Suppliers'
   AND SO.[type] = 'U'

IF (@CODELEN <> '10')
  BEGIN
    SET @UPDATE = 1
  END

IF (@UPDATE = 0)
  BEGIN
    IF NOT EXISTS
      (SELECT *
         FROM SYS.objects SO
              INNER JOIN sys.columns SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankName'
                     AND SC.[system_type_id] = 167
        WHERE SO.[name] = 'Suppliers'
          AND SO.[type] = 'U')
      BEGIN
        SET @UPDATE = 1
      END
  END

IF (@UPDATE = 1)
  BEGIN
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
    BEGIN
      SET @COMMAND = 'DROP TABLE [dbo].[FIXSUP]'

      EXEC (@COMMAND)
    END

    SET @COMMAND = 'SELECT *
  INTO [dbo].[FIXSUP]
  FROM [dbo].[Suppliers]'

    EXEC (@COMMAND)

    SET @COMMAND = 'ALTER TABLE 
      [dbo].[FIXSUP]
  ADD CONSTRAINT 
      [PK_FIXSUP]
      PRIMARY KEY CLUSTERED 
     ([Code] ASC)'

    EXEC (@COMMAND)

    SET @COMMAND = 'DROP TABLE [dbo].[Suppliers]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TABLE 
       [dbo].[Suppliers]
      ([CODE]                         [varchar](10)                                                                   NOT NULL,
       [NAME]                         [varchar](40)                                                                       NULL,
       [ADDRESS]                      [varchar](120)                                                                      NULL,
       [NOMINAL]                      [varchar](10)                                                                       NULL,
       [BALANCE]                      [decimal](15, 2) CONSTRAINT [DF_Suppliers_Balance] DEFAULT (0)                  NOT NULL,
       [BALANCEFWD]                   [decimal](15, 2) CONSTRAINT [DF_Suppliers_BalanceFwd] DEFAULT (0)               NOT NULL,
       [TAXNO]                        [varchar](15)                                                                       NULL,
       [SERVICEDESC]                  [varchar](6)                                                                        NULL,
       [TPBAL]                        [decimal](15, 2) CONSTRAINT [DF_Suppliers_TPBAL] DEFAULT (0)                    NOT NULL,
       [DEFTPSTATUS]                  [char](1)                                                                           NULL,
       [COUNSEL]                      [char](1)                                                                           NULL,
       [UNALLOCATED]                  [decimal](13, 2) CONSTRAINT [DF_Suppliers_UNALLOCATED] DEFAULT (0)              NOT NULL,
       [PAYRUNTOTAL]                  [decimal](13, 2) CONSTRAINT [DF_Suppliers_PAYRUNTOTAL] DEFAULT (0)              NOT NULL,
       [VATNo]                        [varchar](20)                                                                       NULL,
       [Phone]                        [varchar](20)                                                                       NULL,
       [Retired]                      [char](1)                                                                           NULL,
       [ServiceCode]                  [varchar](6)                                                                        NULL,
       [PayeeOnly]                    [char](1)                                                                           NULL,
       [ContactName]                  [varchar](100)                                                                      NULL,
       [Fax]                          [varchar](20)                                                                       NULL,
       [EmailAddress]                 [varchar](100)                                                                      NULL,
       [BankName]                     [varchar](60)                                                                       NULL,
       [BankAddress]                  [varchar](120)                                                                      NULL,
       [BankSortCode]                 [varchar](20)                                                                       NULL,
       [BankAccNo]                    [varchar](20)                                                                       NULL,
       [IBAN]                         [varchar](20)                                                                       NULL,
       [BIC]                          [varchar](20)                                                                       NULL,
       CONSTRAINT [PK_Suppliers]
                  PRIMARY KEY CLUSTERED 
                 ([Code] ASC)
               ON [PRIMARY]) ON [PRIMARY]'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRSuppliersInsert]
    ON [dbo].[Suppliers]
       AFTER INSERT
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE SUP
         SET SUP.[SERVICEDESC] = CASE WHEN SUP.[SERVICEDESC] IS NULL
                                           THEN SUP.[ServiceCode]
                                      ELSE SUP.[SERVICEDESC] END,
             SUP.[ServiceCode] = CASE WHEN SUP.[SERVICEDESC] IS NULL
                                           THEN SUP.[ServiceCode]
                                      ELSE SUP.[SERVICEDESC] END
        FROM inserted INS
             INNER JOIN [dbo].[Suppliers] SUP
                     ON SUP.[Code] = INS.[Code]
       WHERE ISNULL(INS.[SERVICEDESC], ''**NULL**'') <> ISNULL(INS.[ServiceCode], ''**NULL**'')

    END
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'CREATE TRIGGER
       [dbo].[ky_NETTRSuppliersUpdate]
    ON [dbo].[Suppliers]
       AFTER Update
AS
BEGIN
  IF ((SELECT TRIGGER_NESTLEVEL()) < 2)
    BEGIN
      UPDATE SUP
         SET SUP.[SERVICEDESC] = CASE WHEN ISNULL(INS.[SERVICEDESC], ''**NULL**'') <> ISNULL(DEL.[SERVICEDESC], ''**NULL**'') 
                                         THEN INS.[SERVICEDESC]
                                    ELSE INS.[ServiceCode] END,
             SUP.[ServiceCode] = CASE WHEN ISNULL(INS.[ServiceCode], ''**NULL**'') <> ISNULL(DEL.[ServiceCode], ''**NULL**'') 
                                            THEN INS.[ServiceCode]
                                       ELSE INS.[SERVICEDESC] END
        FROM inserted INS
             INNER JOIN deleted DEL
                     ON DEL.[Code] = INS.[Code]
             INNER JOIN [dbo].[Suppliers] SUP
                     ON SUP.[Code] = INS.[Code]
       WHERE ISNULL(INS.[SERVICEDESC], ''**NULL**'') <> ISNULL(DEL.[SERVICEDESC], ''**NULL**'')
          OR ISNULL(INS.[ServiceCode], ''**NULL**'') <> ISNULL(DEL.[ServiceCode], ''**NULL**'')
    END
END'

    EXEC (@COMMAND)

    SET @COMMAND = 'INSERT
  INTO [dbo].[Suppliers]
      ([CODE],
       [NAME],
       [ADDRESS],
       [NOMINAL],
       [TAXNO],
       [DEFTPSTATUS],
       [COUNSEL],
       [Phone],
       [Retired])
SELECT RTRIM(ISNULL(SPX.[CODE], '''')),
       RTRIM(ISNULL(SPX.[NAME], '''')),
       RTRIM(SPX.[ADDRESS]),
       RTRIM(SPX.[NOMINAL]),
       RTRIM(SPX.[TAXNO]),
       RTRIM(SPX.[DEFTPSTATUS]),
       RTRIM(SPX.[COUNSEL]),
       RTRIM(SPX.[Phone]),
       ''N''
  FROM [dbo].[FIXSUP] SPX'

    EXEC (@COMMAND)

    --SAM3 - Column is named "BALANCE"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BALANCE'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BALANCE] = ISNULL(SPX.[BALANCE], 0)
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "BALANCEFWD"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BALANCEFWD'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BALANCEFWD] = ISNULL(SPX.[BALANCEFWD], 0)
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "SERVICEDESC"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'SERVICEDESC'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[SERVICEDESC] = SPX.[SERVICEDESC]
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "TPBAL"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'TPBAL'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[TPBAL] = ISNULL(SPX.[TPBAL], 0)
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "UNALLOCATED"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'UNALLOCATED'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[UNALLOCATED] = ISNULL(SPX.[UNALLOCATED], 0)
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "PAYRUNTOTAL"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'PAYRUNTOTAL'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[PAYRUNTOTAL] = ISNULL(SPX.[PAYRUNTOTAL], 0)
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "VATNo"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'VATNo'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[VATNo] = SPX.[VATNo]
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM3 - Column is named "Retired"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Retired'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[Retired] = SPX.[Retired]
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "ServiceCode"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ServiceCode'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[ServiceCode] = SPX.[ServiceCode]
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "PayeeOnly"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'PayeeOnly'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[PayeeOnly] = SPX.[PayeeOnly]
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "ContactName"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'ContactName'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[ContactName] = SPX.[ContactName]
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "Fax"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'Fax'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[Fax] = SPX.[Fax]
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --SAM4 - Column is named "EmailAddress"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'EmailAddress'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[EmailAddress] = SPX.[EmailAddress]
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankName"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankName'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BankName] = RTRIM(CONVERT(VARCHAR(60), SPX.[BankName]))
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankAddress"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankAddress'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BankAddress] = RTRIM(CONVERT(VARCHAR(120), SPX.[BankAddress]))
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankSortCode"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankSortCode'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BankSortCode] = RTRIM(CONVERT(VARCHAR(20), SPX.[BankSortCode]))
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BankAccNo"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BankAccNo'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BankAccNo] = RTRIM(CONVERT(VARCHAR(20), SPX.[BankAccNo]))
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "IBAN"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'IBAN'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[IBAN] = RTRIM(CONVERT(VARCHAR(20), SPX.[IBAN]))
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

    --NEW - Column is named "BIC"
    IF EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'BIC'
        WHERE SO.[name] = 'FIXSUP'
          AND SO.[type] = 'U')
      BEGIN

        SET @COMMAND = '  UPDATE CON
     SET CON.[BIC] = RTRIM(CONVERT(VARCHAR(20), SPX.[BIC]))
    FROM [dbo].[Suppliers] CON
         INNER JOIN [dbo].[FIXSUP] SPX
                 ON SPX.[CODE] = CON.[CODE]'

        EXEC (@COMMAND)
      END

      IF EXISTS
        (SELECT TOP 1 1 FROM [dbo].[Suppliers])
        BEGIN
          SET @COMMAND = 'DROP TABLE [dbo].[FIXSUP]'

          EXEC (@COMMAND)
        END
      ELSE
        BEGIN
          IF NOT EXISTS
            (SELECT TOP 1 1 FROM [dbo].[FIXSUP])
            BEGIN
              SET @COMMAND = 'DROP TABLE [dbo].[FIXSUP]'

              EXEC (@COMMAND)
            END
        END
  END
GO

IF NOT EXISTS
  (SELECT SI.*
     FROM SYS.objects SO
          INNER JOIN sys.indexes SI
                  ON SI.[object_id] = so.[object_id]
                 AND SI.[name] = 'SupNom'
    WHERE SO.[name] = 'Suppliers'
      AND SO.[type] = 'U')
BEGIN
  CREATE NONCLUSTERED INDEX 
         [SupNom]
      ON [dbo].[Suppliers]
        ([NOMINAL] ASC)
      ON [PRIMARY]
END
GO

/******************************************************************************************************
 *
 * Re-create all views affected by these changes
 *
 ******************************************************************************************************/
GO

/************************************************ 

    Matter Balances By Client
    Dependencies - None
    SAM3 - Not compatible - Matter ledger is a table

 **********************************************/

IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'MatterLedger'
      AND SO.[type] = 'V')
  BEGIN
    EXEC ('DROP VIEW [dbo].[MatterLedger]')

    IF [dbo].[ISSAM4]() = 1
      BEGIN
        EXEC ('
CREATE VIEW 
       [dbo].[MatterLedger]
AS
SELECT TRN.[XnID],
       TRN.[BatchNo],
       TRN.[XnType],
       TRN.[RecType],
       TRN.[Destination],
       TRN.[TypeCode],
       TRN.[ChequeStatus],
       TRN.[Branch],
       TRN.[PostRef],
       TRN.[TransRef],
       TRN.[TransDate],
       TRN.[MatterCode],
       TRN.[Narrative],
       TRN.[OutlayValue], 
       TRN.[CurrencyOutlay],
       TRN.[DebtorsValue],
       TRN.[CurrencyDebtors],
       TRN.[OutlayBill],
       TRN.[ClientCurrent],
       TRN.[CurrencyCurent],
       TRN.[ClientDeposit],
       TRN.[CurrencyDeposit],
       TRN.[PostingYear],
       TRN.[CorrectionInd],
       TRN.[ClearDate],
       TRN.[PreBilledOutlays],
       TRN.[BilledOutlay],
       TRN.[Seq],
       TRN.[MatterCode] AS [MATTER],
       TRN.[OutlayValue] AS [VALUEO],
       TRN.[DebtorsValue] AS [VALUED],
       TRN.[ClientCurrent] AS [VALUEC],
       TRN.[ClientCurrent] AS [VALUECC],
       TRN.[ClientDeposit] AS [VALUECD],
       TRN.[TransDate] AS [DATE]
  FROM [dbo].[Transactions] TRN
 WHERE TRN.[MatterCode] <> ''''
   AND TRN.[Posted] = ''Y''
   AND TRN.[RecType] <> ''V''
   AND (   TRN.[CorrectionInd] = ''L''
        OR TRN.[CorrectionInd] = ''C'')')
      END
  END
GO

DECLARE @COMMAND VARCHAR(MAX)

IF [dbo].[ISSAM4]() = 1
  BEGIN
    SET @COMMAND = 'CREATE VIEW [dbo].[MatterLastBillDate]
AS
  SELECT TOP 100 PERCENT 
         TRN.[MatterCode],
         MAX(TRN.[TransDate]) AS [BillDate]
    FROM [dbo].[Transactions] TRN
   WHERE TRN.[XnType] = ''I''
GROUP BY TRN.[MatterCode]
ORDER BY TRN.[MatterCode]'
    
    EXEC (@COMMAND)

  END
ELSE
  BEGIN
    SET @COMMAND = ' CREATE VIEW [dbo].[MatterLastBillDate]
AS
  SELECT TOP 100 PERCENT
         TIE.[MATTER] AS [MatterCode],
         MAX(TIE.[DATE]) AS [BillDate]
    FROM [dbo].[TimeEntry] TIE
   WHERE TIE.[TimeOrCharge] = ''B''
GROUP BY TIE.[Matter]
ORDER BY TIE.[Matter]'
    
    EXEC (@COMMAND)

  END
GO

CREATE VIEW [dbo].[TimeEntryView]
AS
SELECT TIE.[Matter],
       RTRIM(TIE.[FeeEarn]) AS [FeeCode],
       TIE.[Date],
       TIE.[Time],
       TIE.[Rate], 
       TIE.[Charge] AS [Charged],
       TIE.[Task],
       TIE.[TimeOrCharge],
       TIE.[Units],
       TIE.[Time] / 60 AS [Hours], 
       CON.[Name],
       MAT.[Description],
       TIE.[NCCode],
       TIE.[Rec_Irr],
       TIE.[InvoiceNo]
  FROM [dbo].[TimeEntry] TIE
       LEFT OUTER JOIN [dbo].[matters] MAT
                    ON TIE.[Matter] = MAT.[Code]
       LEFT OUTER JOIN dbo.[Contacts] CON
                    ON MAT.[ClientCode] = CON.[Code]
GO

IF [dbo].[ISSAM4]() = 1
  BEGIN
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'CREATE VIEW [dbo].[zCheckBilltime]
AS
SELECT     TOP 100 PERCENT dbo.TimeEntry.Matter, dbo.BillingGuide.ChargeType, dbo.BillingGuide.Tag, dbo.Billhead.BillStatus, dbo.TimeEntry.InvoiceNo, 
                      Billhead_1.CreditInvoiceNo, dbo.TimeEntry.RecordId, dbo.TimeEntry.[DATE], dbo.TimeEntry.Charge AS [Charged], dbo.TimeEntry.TimeOrCharge, 
                      dbo.BillingGuide.BillingNo, dbo.Billhead.InvoiceNo AS Expr1
FROM         dbo.BillingGuide INNER JOIN
                      dbo.TimeEntry ON dbo.BillingGuide.TimeID = dbo.TimeEntry.RecordId INNER JOIN
                      dbo.Billhead ON dbo.BillingGuide.BillingNo = dbo.Billhead.BillingID LEFT OUTER JOIN
                      dbo.Billhead Billhead_1 ON dbo.Billhead.BillingID = Billhead_1.CreditInvoiceNo
WHERE     (dbo.BillingGuide.ChargeType <> ''O'') AND (dbo.BillingGuide.Tag = ''Y'') AND (dbo.Billhead.BillStatus = ''Approved'') AND (dbo.TimeEntry.InvoiceNo = 0) 
                      AND (Billhead_1.CreditInvoiceNo IS NULL) AND (dbo.TimeEntry.Matter <> ''~'')
ORDER BY dbo.TimeEntry.Matter'

    EXEC (@COMMAND)
  END
GO

IF [dbo].[ISSAM4]() = 1
  BEGIN
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'CREATE VIEW [dbo].[RecoveryRate]
AS
SELECT     TOP 100 PERCENT matters_1.Code AS Matter, ISNULL(T1.Outlayincurred, 0) AS OutlayIncurred, ISNULL(T2.ChargeValue, 0) AS ChargeTime, 
                      ISNULL(T3.OutlayBilled, 0) + ISNULL(T4.FeesBilled, 0) AS FeesOutlayBilled, ISNULL(T5.UnbilledOutlay, 0) AS UnbilledOutlay, ISNULL(T6.WIP, 0) 
                      AS WIP
FROM         (SELECT     dbo.Transactions.MatterCode, SUM(dbo.Transactions.OutlayValue) AS Outlayincurred
                       FROM          dbo.Transactions INNER JOIN
                                              dbo.matters ON dbo.Transactions.MatterCode = dbo.matters.Code
                       WHERE      (dbo.Transactions.Posted = ''Y'') AND (dbo.Transactions.RecType <> ''V'') AND (dbo.Transactions.CorrectionInd = ''L'') AND 
                                              (dbo.Transactions.MatterCode IS NOT NULL) AND (dbo.Transactions.XnType <> ''I'') AND (dbo.Transactions.TypeCode <> ''Composite Xfer'')
                       GROUP BY dbo.Transactions.MatterCode
                       HAVING      (SUM(dbo.Transactions.OutlayValue) <> 0)) T1 RIGHT OUTER JOIN
                      dbo.matters matters_1 ON T1.MatterCode = matters_1.Code LEFT OUTER JOIN
                          (SELECT     Matter, SUM(Charge) AS ChargeValue
                            FROM          dbo.TimeEntry
                            WHERE      (TimeOrCharge <> ''B'') AND (Rec_irr <> ''N'')
                            GROUP BY Matter
                            HAVING      (SUM(Charge) <> 0)) T2 ON matters_1.Code = T2.Matter LEFT OUTER JOIN
                          (SELECT     Transactions_1.MatterCode, SUM(Transactions_1.OutlayValue) * - 1 AS OutlayBilled
                            FROM          dbo.Transactions AS Transactions_1 INNER JOIN
                                                   dbo.matters AS matters_2 ON Transactions_1.MatterCode = matters_2.Code
                            WHERE      (Transactions_1.TypeCode = ''Composite Xfer'') AND (Transactions_1.OutlayValue <> 0) AND (Transactions_1.Posted = ''Y'') AND 
                                                   (Transactions_1.CorrectionInd = ''L'') AND (Transactions_1.RecType <> ''V'') OR
                                                   (Transactions_1.OutlayValue <> 0) AND (Transactions_1.Posted = ''Y'') AND (Transactions_1.CorrectionInd = ''L'') AND 
                                                   (Transactions_1.RecType <> ''V'') AND (Transactions_1.XnType = ''I'') AND (Transactions_1.RecType = ''H'')
                            GROUP BY Transactions_1.MatterCode
                            HAVING      (SUM(Transactions_1.OutlayValue) <> 0)) T3 ON T3.MatterCode = matters_1.Code LEFT OUTER JOIN
                          (SELECT     Matter, SUM(Charge) AS FeesBilled
                            FROM          dbo.TimeEntry AS TimeEntry_1
                            WHERE      (TimeOrCharge = ''B'')
                            GROUP BY Matter
                            HAVING      (SUM(Charge) <> 0)) T4 ON matters_1.Code = T4.Matter LEFT OUTER JOIN
                          (SELECT     MatterCode, SUM(OutlayValue) AS UnbilledOutlay
                            FROM          dbo.Transactions AS Transactions_2
                            WHERE      (Posted = ''Y'') AND (CorrectionInd = ''L'') AND (RecType <> ''V'') AND (MatterCode IS NOT NULL)
                            GROUP BY MatterCode
                            HAVING      (SUM(OutlayValue) <> 0)) T5 ON T5.MatterCode = matters_1.Code LEFT OUTER JOIN
                          (SELECT     Matter, SUM(Charge) AS WIP
                            FROM          dbo.TimeEntry AS TimeEntry_1
                            WHERE      (InvoiceNo = 0)
                            GROUP BY Matter
                            HAVING      (SUM(Charge) <> 0)) T6 ON matters_1.Code = T6.Matter
ORDER BY matters_1.Matter'

    EXEC (@COMMAND)
  END
GO

CREATE VIEW [dbo].[T]
AS
SELECT     dbo.TimeEntry.Matter, RTRIM(dbo.TimeEntry.FeeEarn) AS FeeCode, dbo.TimeEntry.[DATE], dbo.TimeEntry.[TIME], dbo.TimeEntry.Rate, 
                      dbo.TimeEntry.Charge AS [Charged], dbo.TimeEntry.Task, dbo.TimeEntry.TimeOrCharge, dbo.TimeEntry.Units, dbo.TimeEntry.[TIME] / 60 AS Hours, 
                      dbo.Contacts.Name, dbo.matters.Description
FROM         dbo.TimeEntry LEFT OUTER JOIN
                      dbo.matters ON dbo.TimeEntry.Matter = dbo.matters.Code LEFT OUTER JOIN
                      dbo.Contacts ON dbo.matters.ClientCode = dbo.Contacts.Code
GO

IF [dbo].[ISSAM4]() = 1
  BEGIN
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'CREATE VIEW [dbo].[TimeRecordedByFe]
AS
SELECT     TOP 100 PERCENT dbo.Departments.Parent, dbo.Handlers.Dept, dbo.TimeEntry.FeeEarn, SUM(dbo.TimeEntry.Charge) AS Charged, 
                      SUM(dbo.TimeEntry.[TIME]) AS Minutes
FROM         dbo.TimeEntry LEFT OUTER JOIN
                      dbo.Handlers ON dbo.TimeEntry.FeeEarn = dbo.Handlers.CODE LEFT OUTER JOIN
                      dbo.Departments ON dbo.Handlers.Dept = dbo.Departments.CODE
WHERE     (dbo.TimeEntry.TimeOrCharge <> ''B'') AND (dbo.TimeEntry.[DATE] >=
                          (SELECT     ctrlDate.Datevalue
                            FROM          ctrlDate
                            WHERE      ctrlDate.code = ''StartofYear''))
GROUP BY dbo.Departments.Parent, dbo.Handlers.Dept, dbo.TimeEntry.FeeEarn
ORDER BY dbo.Departments.Parent, dbo.Handlers.Dept, dbo.TimeEntry.FeeEarn'

    EXEC (@COMMAND)
  END
GO

IF [dbo].[ISSAM4]() = 1
  BEGIN
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'CREATE VIEW [dbo].[zWIPClosed]
AS
SELECT     TOP 100 PERCENT dbo.matters.Closed, SUM(dbo.TimeEntry.Charge) AS Expr1, SUM(dbo.TimeEntry.[TIME]) AS Expr2, dbo.TimeEntry.Matter
FROM         dbo.TimeEntry INNER JOIN
                      dbo.matters ON dbo.TimeEntry.Matter = dbo.matters.Code
WHERE     (dbo.TimeEntry.InvoiceNo = 0) AND (dbo.TimeEntry.TimeOrCharge <> ''B'') AND (dbo.TimeEntry.Rec_irr = ''C'')
GROUP BY dbo.matters.Closed, dbo.TimeEntry.Matter
HAVING      (dbo.matters.Closed = ''Y'') AND (SUM(dbo.TimeEntry.Charge) <> 0)
ORDER BY dbo.TimeEntry.Matter'

    EXEC (@COMMAND)
  END
GO

CREATE VIEW [dbo].[TimeWIPByFE]
AS
SELECT     TOP 100 PERCENT dbo.Departments.Parent, dbo.Handlers.Dept, dbo.TimeEntry.FeeEarn, SUM(dbo.TimeEntry.Charge) AS Charged, 
                      SUM(dbo.TimeEntry.[TIME]) AS Minutes
FROM         dbo.TimeEntry LEFT OUTER JOIN
                      dbo.Handlers ON dbo.TimeEntry.FeeEarn = dbo.Handlers.CODE LEFT OUTER JOIN
                      dbo.Departments ON dbo.Handlers.Dept = dbo.Departments.CODE
WHERE     (dbo.TimeEntry.InvoiceNo = 0 OR
                      dbo.TimeEntry.InvoiceNo IS NULL) AND (dbo.TimeEntry.TimeOrCharge <> 'B')
GROUP BY dbo.Departments.Parent, dbo.Handlers.Dept, dbo.TimeEntry.FeeEarn
ORDER BY dbo.Departments.Parent, dbo.Handlers.Dept, dbo.TimeEntry.FeeEarn
GO

CREATE VIEW [dbo].[TotalChagenbyTeamInvoiceNo]
AS
SELECT     InvoiceNo, Team, FeeEarn, SUM(Charge) AS TotalCharge
FROM         dbo.TimeEntry
WHERE     (TimeOrCharge <> 'B')
GROUP BY InvoiceNo, FeeEarn, Team
HAVING      (InvoiceNo <> 0)
GO

CREATE VIEW [dbo].[TotalChargeByInovieNo]
AS
SELECT     InvoiceNo, FeeEarn, SUM(Charge) AS TotalCharge
FROM         dbo.TimeEntry
WHERE     (TimeOrCharge <> 'B')
GROUP BY InvoiceNo, FeeEarn
HAVING      (InvoiceNo <> 0)
GO

DECLARE @COMMAND VARCHAR(MAX)

IF [dbo].[ISSAM4]() = 1
  BEGIN
    SET @COMMAND = 'CREATE VIEW [dbo].[zAuotwriteoff]
AS
SELECT     TOP 100 PERCENT SUM(dbo.TimeEntry.Charge) AS TotalCharge, SUM(dbo.TimeEntry.[TIME]) AS TotalTime, dbo.TimeEntry.Matter, 
                      ''Auto WriteOff'' AS Narr, dbo.matters.ClosingDate AS Today, ''T'' AS TorC, ''WRI'' AS TaskCode
FROM         dbo.TimeEntry INNER JOIN
                      dbo.matters ON dbo.TimeEntry.Matter = dbo.matters.Code
WHERE     (dbo.matters.Closed = ''Y'') AND (dbo.TimeEntry.InvoiceNo = 0) AND (dbo.TimeEntry.TimeOrCharge <> ''B'')
GROUP BY dbo.TimeEntry.Matter, dbo.matters.ClosingDate
HAVING      (SUM(dbo.TimeEntry.Charge) < 500 AND SUM(dbo.TimeEntry.Charge) > 0)
ORDER BY dbo.TimeEntry.Matter'
  END
ELSE
  BEGIN
    SET @COMMAND = 'CREATE VIEW [dbo].[zAuotwriteoff]
AS
SELECT     TOP 100 PERCENT SUM(dbo.TimeEntry.Charge) AS TotalCharge, SUM(dbo.TimeEntry.[TIME]) AS TotalTime, dbo.TimeEntry.Matter, 
                      ''Auto WriteOff'' AS Narr, dbo.matters.CloseDate AS Today, ''T'' AS TorC, ''WRI'' AS TaskCode
FROM         dbo.TimeEntry INNER JOIN
                      dbo.matters ON dbo.TimeEntry.Matter = dbo.matters.Code
WHERE     (dbo.matters.Closed = ''Y'') AND (dbo.TimeEntry.InvoiceNo = 0) AND (dbo.TimeEntry.TimeOrCharge <> ''B'')
GROUP BY dbo.TimeEntry.Matter, dbo.matters.CloseDate
HAVING      (SUM(dbo.TimeEntry.Charge) < 500 AND SUM(dbo.TimeEntry.Charge) > 0)
ORDER BY dbo.TimeEntry.Matter'
  END

EXEC (@COMMAND)
GO

CREATE VIEW [dbo].[zAutoWriteOffRecords]
AS
SELECT     Matter, 'ADM' AS FnCode, Today AS [Date], TotalTime * - 1 AS [time], 1 AS Rate, TotalCharge * - 1 AS Charged, TaskCode AS Task, 'T' AS TimeOrCharge, 
                      Narr AS Comment, 0 AS Billed, '' AS NCCode, 'GEN' AS Team, 'C' AS REc_Irr, 0 AS InvoiceNo, MONTH(Today) AS Period, YEAR(Today) AS [Year], 
                      TotalTime / 6 AS Units, 3 AS MatterLevel, 'C' AS TaskLevel, 'C' AS Branch
FROM         dbo.zAuotwriteoff

GO

CREATE VIEW [dbo].[WIPByMatter]
AS
SELECT     dbo.matters.Code AS Matter, SUM(dbo.TimeEntry.Charge) AS WIP, SUM(dbo.TimeEntry.TIME) AS WipTime, SUM(dbo.TimeEntry.Units) 
                      AS WipUnits
FROM         dbo.TimeEntry RIGHT OUTER JOIN
                      dbo.matters ON dbo.TimeEntry.Matter = dbo.matters.Code
WHERE     (dbo.TimeEntry.InvoiceNo = 0) AND (dbo.TimeEntry.Rec_irr <> 'N') AND (dbo.TimeEntry.TimeOrCharge <> 'B')
GROUP BY dbo.matters.Code
GO

IF [dbo].[ISSAM4]() = 1
  BEGIN
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'CREATE VIEW [dbo].[SolicitorsStatsReport]
AS
SELECT     ISNULL(dbo.SolicitorsDetails.Parent, ISNULL(dbo.FeesPaidAndIssuedCurrentPeriod.Parent, ISNULL(dbo.FeesIssuedAndPaidYearToDate.Parent, 
                      ISNULL(dbo.FeesIssuedAndPaidLAstYear.Parent, dbo.NumberFilesPerFe.Parent)))) AS Parent, ISNULL(dbo.Departments.Description, ''Blank'') AS Department, 
                      ISNULL(dbo.SolicitorsDetails.NAME, ''Blank'') AS FeName, ISNULL(dbo.NumberFilesPerFe.NumberFiles, 0) AS NoFiles, 
                      ISNULL(dbo.NumberFilesCurrentPeriod.NumberMatters, 0) AS NewFiles, dbo.FeBudgetCurrent.Budget AS BudgetCurrent, 
                      ISNULL(dbo.FeesPaidAndIssuedCurrentPeriod.IssuedFees, 0) AS CurrentIssued, ISNULL(dbo.FeesPaidAndIssuedCurrentPeriod.PaidFees, 0) AS CurrentPaid, 
                      dbo.FeBudgetYTD.Budget AS BudgetYTD, ISNULL(dbo.FeesIssuedAndPaidYearToDate.FeeIssued, 0) AS YTDIssued, 
                      ISNULL(dbo.FeesIssuedAndPaidYearToDate.FeesPaid, 0) AS YTDPaid, ISNULL(dbo.FeesIssuedAndPaidLAstYear.FeeIssued, 0) AS LastIssued, 
                      ISNULL(dbo.FeesIssuedAndPaidLAstYear.FeesPaid, 0) AS LastPaid, ISNULL(dbo.TimeRecordedByFe.Minutes / 60 /
                          (SELECT     NumValue
                            FROM          dbo.CtrlNum
                            WHERE      (Code = ''WeekNo'')), 0) AS TimeRecorded, ISNULL(dbo.TimeWIPByFE.Charged, 0) AS WIP, ISNULL(dbo.OutstandingFeesbyfe60Days.FeesOs, 0) 
                      AS FeesOs60, ISNULL(dbo.OutstandingFeesbyFe.FeesOs, ''0'') AS FeesOs, ISNULL(dbo.SolicitorsDetails.Dept, 
                      ISNULL(dbo.FeesPaidAndIssuedCurrentPeriod.Department, ISNULL(dbo.FeesIssuedAndPaidYearToDate.Department, 
                      ISNULL(dbo.FeesIssuedAndPaidLAstYear.Department, dbo.NumberFilesPerFe.Department)))) AS Dept, ISNULL(dbo.SolicitorsDetails.CODE, 
                      ISNULL(dbo.FeesPaidAndIssuedCurrentPeriod.FeCode, ISNULL(dbo.FeesIssuedAndPaidYearToDate.FeCode, ISNULL(dbo.FeesIssuedAndPaidLAstYear.FeCode, 
                      ISNULL(dbo.TimeWIPByFE.FeeEarn, dbo.NumberFilesPerFe.FECode))))) AS FeCode, dbo.FeesPaidAndIssuedCurrentPeriod.Parent AS ParentCurrent, 
                      dbo.FeesIssuedAndPaidYearToDate.Parent AS ParentYTD, dbo.FeesIssuedAndPaidLAstYear.Parent AS ParentLastYear, 
                      dbo.FeesPaidAndIssuedCurrentPeriod.Department AS DepCurrent, dbo.FeesIssuedAndPaidYearToDate.Department AS DepYTD, 
                      dbo.FeesIssuedAndPaidLAstYear.Department AS DepLastYear, dbo.FeesPaidAndIssuedCurrentPeriod.FeCode AS FeCodeCurrent, 
                      dbo.FeesIssuedAndPaidYearToDate.FeCode AS FeCodeYTD, dbo.FeesIssuedAndPaidLAstYear.FeCode AS FeCodeLastYear, dbo.TimeWIPByFE.Parent AS WIPParent, 
                      dbo.TimeWIPByFE.Dept AS WIPDept, dbo.TimeWIPByFE.FeeEarn AS WIPFeCode, ISNULL(dbo.FeBudgetCurrent.BudgetHours, 0) AS BudgetHoursCurrent, 
                      ISNULL(dbo.FeBudgetYTD.BudgetHours, 0) AS BudgetHoursYTD, dbo.NumberFilesPerFe.Parent AS NoFilesParent, dbo.NumberFilesPerFe.Department AS NoFilesDept,
                       dbo.NumberFilesPerFe.FECode AS NoFilesFe, dbo.NumberFilesCurrentPeriod.Parent AS NoCuParent, dbo.NumberFilesCurrentPeriod.Department AS NoCuDept, 
                      dbo.NumberFilesCurrentPeriod.FECode AS NoCuFeCode, dbo.SolicitorsDetails.Branch, dbo.SolicitorsDetails.Type
FROM         dbo.SolicitorsDetails LEFT OUTER JOIN
                      dbo.OutstandingFeesbyfe60Days ON dbo.SolicitorsDetails.Parent = dbo.OutstandingFeesbyfe60Days.Parent AND 
                      dbo.SolicitorsDetails.Dept = dbo.OutstandingFeesbyfe60Days.Dept AND dbo.SolicitorsDetails.CODE = dbo.OutstandingFeesbyfe60Days.FE_Code LEFT OUTER JOIN
                      dbo.OutstandingFeesbyFe ON dbo.SolicitorsDetails.Parent = dbo.OutstandingFeesbyFe.Parent AND dbo.SolicitorsDetails.Dept = dbo.OutstandingFeesbyFe.Dept AND 
                      dbo.SolicitorsDetails.CODE = dbo.OutstandingFeesbyFe.FE_Code LEFT OUTER JOIN
                      dbo.FeBudgetCurrent ON dbo.SolicitorsDetails.CODE = dbo.FeBudgetCurrent.FeCode LEFT OUTER JOIN
                      dbo.FeBudgetYTD ON dbo.SolicitorsDetails.CODE = dbo.FeBudgetYTD.FeCode LEFT OUTER JOIN
                      dbo.Departments ON dbo.SolicitorsDetails.Dept = dbo.Departments.CODE FULL OUTER JOIN
                      dbo.TimeRecordedByFe ON dbo.SolicitorsDetails.Parent = dbo.TimeRecordedByFe.Parent AND dbo.SolicitorsDetails.Dept = dbo.TimeRecordedByFe.Dept AND 
                      dbo.SolicitorsDetails.CODE = dbo.TimeRecordedByFe.FeeEarn FULL OUTER JOIN
                      dbo.NumberFilesCurrentPeriod ON dbo.SolicitorsDetails.Parent = dbo.NumberFilesCurrentPeriod.Parent AND 
                      dbo.SolicitorsDetails.Dept = dbo.NumberFilesCurrentPeriod.Department AND dbo.SolicitorsDetails.CODE = dbo.NumberFilesCurrentPeriod.FECode FULL OUTER JOIN
                      dbo.NumberFilesPerFe ON dbo.SolicitorsDetails.Parent = dbo.NumberFilesPerFe.Parent AND dbo.SolicitorsDetails.Dept = dbo.NumberFilesPerFe.Department AND 
                      dbo.SolicitorsDetails.CODE = dbo.NumberFilesPerFe.FECode FULL OUTER JOIN
                      dbo.TimeWIPByFE ON dbo.SolicitorsDetails.Parent = dbo.TimeWIPByFE.Parent AND dbo.SolicitorsDetails.Dept = dbo.TimeWIPByFE.Dept AND 
                      dbo.SolicitorsDetails.CODE = dbo.TimeWIPByFE.FeeEarn FULL OUTER JOIN
                      dbo.FeesPaidAndIssuedCurrentPeriod ON dbo.SolicitorsDetails.Parent = dbo.FeesPaidAndIssuedCurrentPeriod.Parent AND 
                      dbo.SolicitorsDetails.Dept = dbo.FeesPaidAndIssuedCurrentPeriod.Department AND 
                      dbo.SolicitorsDetails.CODE = dbo.FeesPaidAndIssuedCurrentPeriod.FeCode FULL OUTER JOIN
                      dbo.FeesIssuedAndPaidLAstYear ON dbo.SolicitorsDetails.Parent = dbo.FeesIssuedAndPaidLAstYear.Parent AND 
                      dbo.SolicitorsDetails.Dept = dbo.FeesIssuedAndPaidLAstYear.Department AND 
                      dbo.SolicitorsDetails.CODE = dbo.FeesIssuedAndPaidLAstYear.FeCode FULL OUTER JOIN
                      dbo.FeesIssuedAndPaidYearToDate ON dbo.SolicitorsDetails.Parent = dbo.FeesIssuedAndPaidYearToDate.Parent AND 
                      dbo.SolicitorsDetails.Dept = dbo.FeesIssuedAndPaidYearToDate.Department AND dbo.SolicitorsDetails.CODE = dbo.FeesIssuedAndPaidYearToDate.FeCode'

    EXEC (@COMMAND)
  END
GO

CREATE VIEW [dbo].[MatterRecovery]
AS
SELECT     Code,
                          (SELECT     SUM(Charge) AS Charged
                            FROM          dbo.TimeEntry
                            WHERE      (TimeOrCharge <> 'B') AND (Task <> 'WRI') AND (Matter = dbo.matters.Code)) AS Charged,
                          (SELECT     SUM(Charge) AS Charged
                            FROM          dbo.TimeEntry AS TimeEntry_1
                            WHERE      (TimeOrCharge = 'B') AND (Matter = dbo.matters.Code)) AS Billed,
                          (SELECT     SUM(Charge) AS Charged
                            FROM          dbo.TimeEntry AS TimeEntry_2
                            WHERE      (TimeOrCharge <> 'B') AND (Task = 'WRI') AND (Matter = dbo.matters.Code)) AS WO
FROM         dbo.matters
GO

IF [dbo].[ISSAM4]() = 1
  BEGIN
    DECLARE @COMMAND VARCHAR(MAX)

    SET @COMMAND = 'CREATE VIEW 
       [dbo].[DebtorsLedger]
AS
  SELECT TOP 100 PERCENT 
         TRN.[XnID],
         TRN.[BatchNo],
         TRN.[XnType],
         TRN.[RecType],
         TRN.[PostRef],
         TRN.[TransRef],
         TRN.[TransDate],
         TRN.[MatterCode],
         TRN.[Narrative],
         TRN.[DebtorsValue],
         TRN.[FeesBilled],
         TRN.[OutlayNV], 
         TRN.[OutlayV],
         TRN.[VATBilled],
         TRN.[EntryDate],
         TRN.[DebtorsValueOS],
         TRN.[FeesOS],
         TRN.[VATonFeesOS],
         TRN.[OutlayNVOS],
         TRN.[OutlayVOS],
         TRN.[VATOutlayOS],
         TRN.[MiscOS],
         TRN.[VATMiscOS],
         TRN.[VATonFees], 
         TRN.[VATonOutlay],
         TRN.[MiscBilled],
         TRN.[VATonMisc],
         TRN.[TypeCode],
         TRN.[AllocPending],
         TRN.[PostingYear],
         TRN.[CorrectionInd],
         TRN.[MatterCode] AS [MATTER],
         TRN.[TransDate] AS [DATE],
         TRN.[FeesOS] AS [OSFees],
         TRN.[OutlayNVOS] + TRN.[OutlayVOS] AS [OSValue],
         TRN.[TransRef] AS [Ref]
    FROM [dbo].[Transactions] TRN
   WHERE TRN.[DebtorsValue] <> 0
     AND TRN.[Posted] = ''Y''
     AND TRN.[RecType] <> ''V''
     AND (   TRN.[CorrectionInd] = ''L'' 
          OR TRN.[CorrectionInd] = ''C'')
ORDER BY TRN.[MatterCode]'

    EXEC (@COMMAND)
  END
GO

DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'ALTER DATABASE [' + DB_NAME() + '] SET RECOVERY FULL'

EXEC (@COMMAND)
GO

UPDATE SKL
   SET SKL.[COMMENT] = '001 MakeSAM4SAM3Compatible.SQL' 
  FROM [dbo].[KYScriptLog] SKL
 WHERE SKL.[MajorVersion] = 5
   AND SKL.[MinorVersion] = 1
   AND SKL.[Build] = 1
   AND SKL.[Revision] = 163
   AND SKL.[COMMENT] = '001 MakeSAM4SAM3Compatible.SQL **FAILED**'
GO

SET NOEXEC OFF
SET NOCOUNT OFF
GO
